/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.converter.export;

import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.converter.export.AbstractPlanItemDefinitionExport;
import org.flowable.cmmn.model.FieldExtension;
import org.flowable.cmmn.model.ImplementationType;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.cmmn.model.ServiceTask;

public class ServiceTaskExport
extends AbstractPlanItemDefinitionExport {
    public static void writeTask(ServiceTask task, XMLStreamWriter xtw) throws Exception {
        xtw.writeStartElement("task");
        ServiceTaskExport.writeCommonPlanItemDefinitionAttributes((PlanItemDefinition)task, xtw);
        if (!task.isBlocking()) {
            xtw.writeAttribute("isBlocking", "false");
        }
        if (StringUtils.isNotEmpty((CharSequence)task.getType())) {
            xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "type", task.getType());
            if ("java".equals(task.getType())) {
                if (StringUtils.isNotEmpty((CharSequence)task.getImplementation())) {
                    if (ImplementationType.IMPLEMENTATION_TYPE_CLASS.equals(task.getImplementationType())) {
                        xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "class", task.getImplementation());
                    } else if (ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION.equals(task.getImplementationType())) {
                        xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "expression", task.getImplementation());
                    } else if (ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equals(task.getImplementationType())) {
                        xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "delegateExpression", task.getImplementation());
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)task.getResultVariableName())) {
                    xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "resultVariableName", task.getResultVariableName());
                }
            }
        }
        if (task.getFieldExtensions().size() > 0) {
            xtw.writeStartElement("extensions");
            for (FieldExtension fieldExtension : task.getFieldExtensions()) {
                xtw.writeStartElement("flowable", "field", "http://flowable.org/cmmn");
                xtw.writeAttribute("name", fieldExtension.getFieldName());
                if (StringUtils.isNotEmpty((CharSequence)fieldExtension.getStringValue())) {
                    xtw.writeStartElement("flowable", "string", "http://flowable.org/cmmn");
                    xtw.writeCData(fieldExtension.getStringValue());
                } else {
                    xtw.writeStartElement("flowable", "expression", "http://flowable.org/cmmn");
                    xtw.writeCData(fieldExtension.getExpression());
                }
                xtw.writeEndElement();
                xtw.writeEndElement();
            }
            xtw.writeEndElement();
        }
        xtw.writeEndElement();
    }
}

