/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.converter.export;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.converter.CmmnXmlConstants;
import org.flowable.cmmn.converter.util.CmmnXmlUtil;
import org.flowable.cmmn.model.CompletionNeutralRule;
import org.flowable.cmmn.model.ManualActivationRule;
import org.flowable.cmmn.model.ParentCompletionRule;
import org.flowable.cmmn.model.PlanItemControl;
import org.flowable.cmmn.model.ReactivationRule;
import org.flowable.cmmn.model.RepetitionRule;
import org.flowable.cmmn.model.RequiredRule;
import org.flowable.cmmn.model.VariableAggregationDefinition;
import org.flowable.cmmn.model.VariableAggregationDefinitions;

public class PlanItemControlExport
implements CmmnXmlConstants {
    public static void writeItemControl(PlanItemControl planItemControl, XMLStreamWriter xtw) throws Exception {
        xtw.writeStartElement("itemControl");
        PlanItemControlExport.writeItemControlContent(planItemControl, xtw);
        xtw.writeEndElement();
    }

    public static void writeDefaultControl(PlanItemControl planItemControl, XMLStreamWriter xtw) throws Exception {
        xtw.writeStartElement("defaultControl");
        PlanItemControlExport.writeItemControlContent(planItemControl, xtw);
        xtw.writeEndElement();
    }

    protected static void writeItemControlContent(PlanItemControl planItemControl, XMLStreamWriter xtw) throws Exception {
        boolean hasWrittenExtensionElements = PlanItemControlExport.writeCompletionNeutralRule(planItemControl.getCompletionNeutralRule(), xtw);
        hasWrittenExtensionElements = PlanItemControlExport.writeParentCompletionRule(planItemControl.getParentCompletionRule(), hasWrittenExtensionElements, xtw);
        hasWrittenExtensionElements = PlanItemControlExport.writeReactivationRule(planItemControl.getReactivationRule(), hasWrittenExtensionElements, xtw);
        if (hasWrittenExtensionElements) {
            xtw.writeEndElement();
        }
        PlanItemControlExport.writeRepetitionRule(planItemControl.getRepetitionRule(), xtw);
        PlanItemControlExport.writeRequiredRule(planItemControl.getRequiredRule(), xtw);
        PlanItemControlExport.writeManualActivationRule(planItemControl.getManualActivationRule(), xtw);
    }

    public static void writeRequiredRule(RequiredRule requiredRule, XMLStreamWriter xtw) throws XMLStreamException {
        if (requiredRule != null) {
            xtw.writeStartElement("requiredRule");
            if (StringUtils.isNotEmpty((CharSequence)requiredRule.getCondition())) {
                xtw.writeStartElement("condition");
                xtw.writeCData(requiredRule.getCondition());
                xtw.writeEndElement();
            }
            xtw.writeEndElement();
        }
    }

    public static void writeRepetitionRule(RepetitionRule repetitionRule, XMLStreamWriter xtw) throws XMLStreamException {
        if (repetitionRule != null) {
            boolean hasWrittenExtensionElements;
            xtw.writeStartElement("repetitionRule");
            if (StringUtils.isNotEmpty((CharSequence)repetitionRule.getRepetitionCounterVariableName())) {
                xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "counterVariable", repetitionRule.getRepetitionCounterVariableName());
            }
            if (repetitionRule.getMaxInstanceCount() != null) {
                if (repetitionRule.getMaxInstanceCount() == -1) {
                    xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "maxInstanceCount", "unlimited");
                } else {
                    xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "maxInstanceCount", Integer.toString(repetitionRule.getMaxInstanceCount()));
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)repetitionRule.getCollectionVariableName())) {
                xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "collectionVariable", repetitionRule.getCollectionVariableName());
            }
            if (StringUtils.isNotEmpty((CharSequence)repetitionRule.getElementVariableName())) {
                xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "elementVariable", repetitionRule.getElementVariableName());
            }
            if (StringUtils.isNotEmpty((CharSequence)repetitionRule.getElementIndexVariableName())) {
                xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "elementIndexVariable", repetitionRule.getElementIndexVariableName());
            }
            if (hasWrittenExtensionElements = PlanItemControlExport.writeVariableAggregations(repetitionRule.getAggregations(), xtw)) {
                xtw.writeEndElement();
            }
            if (StringUtils.isNotEmpty((CharSequence)repetitionRule.getCondition())) {
                xtw.writeStartElement("condition");
                xtw.writeCData(repetitionRule.getCondition());
                xtw.writeEndElement();
            }
            xtw.writeEndElement();
        }
    }

    protected static boolean writeVariableAggregations(VariableAggregationDefinitions aggregationDefinitions, XMLStreamWriter xtw) throws XMLStreamException {
        boolean hasWrittenExtensionElements = false;
        if (aggregationDefinitions != null) {
            xtw.writeStartElement("extensionElements");
            hasWrittenExtensionElements = true;
            for (VariableAggregationDefinition aggregation : aggregationDefinitions.getAggregations()) {
                xtw.writeStartElement("http://flowable.org/cmmn", "variableAggregation");
                CmmnXmlUtil.writeDefaultAttribute("target", aggregation.getTarget(), xtw);
                CmmnXmlUtil.writeDefaultAttribute("targetExpression", aggregation.getTargetExpression(), xtw);
                if (aggregation.isStoreAsTransientVariable()) {
                    CmmnXmlUtil.writeDefaultAttribute("storeAsTransientVariable", "true", xtw);
                }
                if (aggregation.isCreateOverviewVariable()) {
                    CmmnXmlUtil.writeDefaultAttribute("createOverviewVariable", "true", xtw);
                }
                if (StringUtils.isNotEmpty((CharSequence)aggregation.getImplementationType())) {
                    CmmnXmlUtil.writeDefaultAttribute(aggregation.getImplementationType(), aggregation.getImplementation(), xtw);
                }
                for (VariableAggregationDefinition.Variable definition : aggregation.getDefinitions()) {
                    xtw.writeStartElement("variable");
                    CmmnXmlUtil.writeDefaultAttribute("source", definition.getSource(), xtw);
                    CmmnXmlUtil.writeDefaultAttribute("sourceExpression", definition.getSourceExpression(), xtw);
                    CmmnXmlUtil.writeDefaultAttribute("target", definition.getTarget(), xtw);
                    CmmnXmlUtil.writeDefaultAttribute("targetExpression", definition.getTargetExpression(), xtw);
                    xtw.writeEndElement();
                }
                xtw.writeEndElement();
            }
        }
        return hasWrittenExtensionElements;
    }

    public static void writeManualActivationRule(ManualActivationRule manualActivationRule, XMLStreamWriter xtw) throws XMLStreamException {
        if (manualActivationRule != null) {
            xtw.writeStartElement("manualActivationRule");
            if (StringUtils.isNotEmpty((CharSequence)manualActivationRule.getCondition())) {
                xtw.writeStartElement("condition");
                xtw.writeCData(manualActivationRule.getCondition());
                xtw.writeEndElement();
            }
            xtw.writeEndElement();
        }
    }

    public static boolean writeCompletionNeutralRule(CompletionNeutralRule completionNeutralRule, XMLStreamWriter xtw) throws XMLStreamException {
        boolean hasWrittenExtensionElements = false;
        if (completionNeutralRule != null) {
            xtw.writeStartElement("extensionElements");
            xtw.writeStartElement("flowable", "completionNeutralRule", "http://flowable.org/cmmn");
            if (StringUtils.isNotBlank((CharSequence)completionNeutralRule.getCondition())) {
                xtw.writeStartElement("condition");
                xtw.writeCData(completionNeutralRule.getCondition());
                xtw.writeEndElement();
            }
            xtw.writeEndElement();
            hasWrittenExtensionElements = true;
        }
        return hasWrittenExtensionElements;
    }

    public static boolean writeParentCompletionRule(ParentCompletionRule parentCompletionRule, boolean hasWrittenExtensionElements, XMLStreamWriter xtw) throws XMLStreamException {
        if (parentCompletionRule != null) {
            if (!hasWrittenExtensionElements) {
                xtw.writeStartElement("extensionElements");
            }
            xtw.writeStartElement("flowable", "parentCompletionRule", "http://flowable.org/cmmn");
            if (StringUtils.isNotEmpty((CharSequence)parentCompletionRule.getType())) {
                xtw.writeAttribute("type", parentCompletionRule.getType());
            }
            xtw.writeEndElement();
            hasWrittenExtensionElements = true;
        }
        return hasWrittenExtensionElements;
    }

    public static boolean writeReactivationRule(ReactivationRule reactivationRule, boolean hasWrittenExtensionElements, XMLStreamWriter xtw) throws XMLStreamException {
        if (reactivationRule != null) {
            if (!hasWrittenExtensionElements) {
                xtw.writeStartElement("extensionElements");
            }
            xtw.writeStartElement("flowable", "reactivationRule", "http://flowable.org/cmmn");
            PlanItemControlExport.writeReactivationRuleAttributes(reactivationRule, xtw);
            xtw.writeEndElement();
            hasWrittenExtensionElements = true;
        }
        return hasWrittenExtensionElements;
    }

    public static void writeReactivationRuleAttributes(ReactivationRule reactivationRule, XMLStreamWriter xtw) throws XMLStreamException {
        if (StringUtils.isNotEmpty((CharSequence)reactivationRule.getActivateCondition())) {
            xtw.writeAttribute("activateCondition", reactivationRule.getActivateCondition());
        }
        if (StringUtils.isNotEmpty((CharSequence)reactivationRule.getIgnoreCondition())) {
            xtw.writeAttribute("ignoreCondition", reactivationRule.getIgnoreCondition());
        }
        if (StringUtils.isNotEmpty((CharSequence)reactivationRule.getDefaultCondition())) {
            xtw.writeAttribute("defaultCondition", reactivationRule.getDefaultCondition());
        }
    }
}

