/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.converter;

import javax.xml.stream.XMLStreamReader;
import org.flowable.cmmn.converter.BaseCmmnXmlConverter;
import org.flowable.cmmn.converter.ConversionHelper;
import org.flowable.cmmn.converter.exception.XMLException;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.CmmnDiEdge;
import org.flowable.cmmn.model.GraphicInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmmnDiExtensionXmlConverter
extends BaseCmmnXmlConverter {
    protected static final Logger LOGGER = LoggerFactory.getLogger(CmmnDiExtensionXmlConverter.class);

    @Override
    public String getXMLElementName() {
        return "extension";
    }

    @Override
    public boolean hasChildElements() {
        return false;
    }

    @Override
    protected BaseElement convert(XMLStreamReader xtr, ConversionHelper conversionHelper) {
        CmmnDiEdge edgeInfo = conversionHelper.getCurrentDiEdge();
        if (edgeInfo == null) {
            return null;
        }
        boolean readyWithChildElements = false;
        try {
            while (!readyWithChildElements && xtr.hasNext()) {
                xtr.next();
                if (xtr.isStartElement()) {
                    String type;
                    if (!"docker".equals(xtr.getLocalName()) || !"source".equals(type = xtr.getAttributeValue(null, "type")) && !"target".equals(type)) continue;
                    GraphicInfo graphicInfo = new GraphicInfo();
                    graphicInfo.setX(Double.valueOf(xtr.getAttributeValue(null, "x")).doubleValue());
                    graphicInfo.setY(Double.valueOf(xtr.getAttributeValue(null, "y")).doubleValue());
                    if ("source".equals(type)) {
                        edgeInfo.setSourceDockerInfo(graphicInfo);
                        continue;
                    }
                    edgeInfo.setTargetDockerInfo(graphicInfo);
                    continue;
                }
                if (!xtr.isEndElement() || !"extension".equalsIgnoreCase(xtr.getLocalName())) continue;
                readyWithChildElements = true;
            }
        }
        catch (Exception ex) {
            LOGGER.error("Error processing CMMN document", (Throwable)ex);
            throw new XMLException("Error processing CMMN document", ex);
        }
        return null;
    }
}

