/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.converter.export;

import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.stream.XMLStreamWriter;
import org.flowable.cmmn.converter.CmmnXmlConstants;
import org.flowable.cmmn.model.Association;
import org.flowable.cmmn.model.CmmnDiEdge;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.Criterion;
import org.flowable.cmmn.model.GraphicInfo;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.Stage;
import org.flowable.cmmn.model.TextAnnotation;

public class CmmnDIExport
implements CmmnXmlConstants {
    public static void writeCmmnDI(CmmnModel model, XMLStreamWriter xtw) throws Exception {
        xtw.writeStartElement("cmmndi", "CMMNDI", "http://www.omg.org/spec/CMMN/20151109/CMMNDI");
        xtw.writeStartElement("cmmndi", "CMMNDiagram", "http://www.omg.org/spec/CMMN/20151109/CMMNDI");
        String caseId = model.getPrimaryCase().getId();
        xtw.writeAttribute("id", "CMMNDiagram_" + caseId);
        for (String elementId : model.getLocationMap().keySet()) {
            if (elementId.equals(model.getPrimaryCase().getPlanModel().getId())) {
                CmmnDIExport.writePlanModel(model.getPrimaryCase().getPlanModel(), model, xtw);
                continue;
            }
            PlanItem planItem = model.findPlanItem(elementId);
            if (planItem != null) {
                CmmnDIExport.writePlanItem(planItem, model, xtw);
                continue;
            }
            TextAnnotation textAnnotation = model.findTextAnnotation(elementId);
            if (textAnnotation == null) continue;
            CmmnDIExport.writeTextAnnotation(textAnnotation, model, xtw);
        }
        if (model.getFlowLocationMap().size() > 0) {
            LinkedHashMap<String, Association> associationMap = new LinkedHashMap<String, Association>();
            for (Association association : model.getAssociations()) {
                associationMap.put(association.getId(), association);
            }
            for (String elementId : model.getFlowLocationMap().keySet()) {
                Association association = (Association)associationMap.get(elementId);
                if (association == null) continue;
                CmmnDIExport.createCmmnEdge(model, association.getId(), association.getSourceRef(), association.getTargetRef(), xtw);
            }
        }
        xtw.writeEndElement();
        xtw.writeEndElement();
    }

    protected static void writePlanModel(Stage stage, CmmnModel model, XMLStreamWriter xtw) throws Exception {
        CmmnDIExport.createCmmnShape(model, stage.getId(), xtw);
        for (Criterion criterion : stage.getExitCriteria()) {
            CmmnDIExport.createCmmnShape(model, criterion.getId(), xtw);
        }
    }

    protected static void writePlanItem(PlanItem planItem, CmmnModel model, XMLStreamWriter xtw) throws Exception {
        CmmnDIExport.createCmmnShape(model, planItem.getId(), xtw);
        for (Criterion criterion : planItem.getEntryCriteria()) {
            CmmnDIExport.createCmmnShape(model, criterion.getId(), xtw);
        }
        for (Criterion criterion : planItem.getExitCriteria()) {
            CmmnDIExport.createCmmnShape(model, criterion.getId(), xtw);
        }
    }

    protected static void writeTextAnnotation(TextAnnotation textAnnotation, CmmnModel model, XMLStreamWriter xtw) throws Exception {
        CmmnDIExport.createCmmnShape(model, textAnnotation.getId(), xtw);
    }

    protected static void createCmmnShape(CmmnModel model, String elementId, XMLStreamWriter xtw) throws Exception {
        GraphicInfo graphicInfo = model.getGraphicInfo(elementId);
        if (graphicInfo == null) {
            return;
        }
        xtw.writeStartElement("cmmndi", "CMMNShape", "http://www.omg.org/spec/CMMN/20151109/CMMNDI");
        String shapeId = "CMMNShape_" + elementId;
        xtw.writeAttribute("id", shapeId);
        xtw.writeAttribute("cmmnElementRef", elementId);
        xtw.writeStartElement("dc", "Bounds", "http://www.omg.org/spec/CMMN/20151109/DC");
        xtw.writeAttribute("height", String.valueOf(graphicInfo.getHeight()));
        xtw.writeAttribute("width", String.valueOf(graphicInfo.getWidth()));
        xtw.writeAttribute("x", String.valueOf(graphicInfo.getX()));
        xtw.writeAttribute("y", String.valueOf(graphicInfo.getY()));
        xtw.writeEndElement();
        xtw.writeStartElement("cmmndi", "CMMNLabel", "http://www.omg.org/spec/CMMN/20151109/CMMNDI");
        xtw.writeEndElement();
        xtw.writeEndElement();
    }

    protected static void createCmmnEdge(CmmnModel model, String associationId, String sourceElementId, String targetElementId, XMLStreamWriter xtw) throws Exception {
        xtw.writeStartElement("cmmndi", "CMMNEdge", "http://www.omg.org/spec/CMMN/20151109/CMMNDI");
        Object edgeId = associationId;
        if (!((String)edgeId).startsWith("CMMNEdge_")) {
            edgeId = "CMMNEdge_" + associationId;
        }
        xtw.writeAttribute("id", (String)edgeId);
        xtw.writeAttribute("cmmnElementRef", sourceElementId);
        xtw.writeAttribute("targetCMMNElementRef", targetElementId);
        CmmnDiEdge edgeInfo = model.getEdgeInfo(associationId);
        if (edgeInfo.getSourceDockerInfo() != null && edgeInfo.getTargetDockerInfo() != null) {
            xtw.writeStartElement("di", "extension", "http://www.omg.org/spec/CMMN/20151109/DI");
            xtw.writeStartElement("flowable", "docker", "http://flowable.org/cmmn");
            xtw.writeAttribute("type", "source");
            xtw.writeAttribute("x", String.valueOf(edgeInfo.getSourceDockerInfo().getX()));
            xtw.writeAttribute("y", String.valueOf(edgeInfo.getSourceDockerInfo().getY()));
            xtw.writeEndElement();
            xtw.writeStartElement("flowable", "docker", "http://flowable.org/cmmn");
            xtw.writeAttribute("type", "target");
            xtw.writeAttribute("x", String.valueOf(edgeInfo.getTargetDockerInfo().getX()));
            xtw.writeAttribute("y", String.valueOf(edgeInfo.getTargetDockerInfo().getY()));
            xtw.writeEndElement();
            xtw.writeEndElement();
        }
        List graphicInfoList = model.getFlowLocationGraphicInfo(associationId);
        for (GraphicInfo graphicInfo : graphicInfoList) {
            xtw.writeStartElement("di", "waypoint", "http://www.omg.org/spec/CMMN/20151109/DI");
            xtw.writeAttribute("x", String.valueOf(graphicInfo.getX()));
            xtw.writeAttribute("y", String.valueOf(graphicInfo.getY()));
            xtw.writeEndElement();
        }
        xtw.writeStartElement("cmmndi", "CMMNLabel", "http://www.omg.org/spec/CMMN/20151109/CMMNDI");
        xtw.writeEndElement();
        xtw.writeEndElement();
    }
}

