/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.converter.export;

import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.converter.CmmnXmlConstants;
import org.flowable.cmmn.converter.CmmnXmlConverterOptions;
import org.flowable.cmmn.converter.export.FlowableListenerExport;
import org.flowable.cmmn.converter.export.PlanItemControlExport;
import org.flowable.cmmn.converter.util.CmmnXmlUtil;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.PlanItemDefinition;

public abstract class AbstractPlanItemDefinitionExport<T extends PlanItemDefinition>
implements CmmnXmlConstants {
    protected abstract Class<? extends T> getExportablePlanItemDefinitionClass();

    public void writePlanItemDefinition(CmmnModel model, T planItemDefinition, XMLStreamWriter xtw, CmmnXmlConverterOptions options) throws Exception {
        this.writePlanItemDefinitionStartElement(planItemDefinition, xtw);
        this.writePlanItemDefinitionCommonAttributes(planItemDefinition, xtw, options);
        this.writePlanItemDefinitionSpecificAttributes(planItemDefinition, xtw);
        boolean didWriteExtensionElement = this.writePlanItemDefinitionCommonElements(model, planItemDefinition, xtw, options);
        didWriteExtensionElement = this.writePlanItemDefinitionExtensionElements(model, planItemDefinition, didWriteExtensionElement, xtw);
        if (didWriteExtensionElement) {
            xtw.writeEndElement();
        }
        this.writePlanItemDefinitionDefaultItemControl(model, planItemDefinition, xtw);
        this.writePlanItemDefinitionBody(model, planItemDefinition, xtw, options);
        this.writePlanItemDefinitionEndElement(xtw);
    }

    protected void writePlanItemDefinitionStartElement(T planItemDefinition, XMLStreamWriter xtw) throws Exception {
        xtw.writeStartElement(this.getPlanItemDefinitionXmlElementValue(planItemDefinition));
    }

    protected abstract String getPlanItemDefinitionXmlElementValue(T var1);

    protected void writePlanItemDefinitionCommonAttributes(T planItemDefinition, XMLStreamWriter xtw, CmmnXmlConverterOptions options) throws Exception {
        xtw.writeAttribute("id", planItemDefinition.getId());
        if (!(!StringUtils.isNotEmpty((CharSequence)planItemDefinition.getName()) || options.isSaveElementNameWithNewLineInExtensionElement() && CmmnXmlUtil.containsNewLine(planItemDefinition.getName()))) {
            xtw.writeAttribute("name", planItemDefinition.getName());
        }
    }

    protected void writePlanItemDefinitionSpecificAttributes(T planItemDefinition, XMLStreamWriter xtw) throws Exception {
    }

    protected boolean writePlanItemDefinitionCommonElements(CmmnModel model, T planItemDefinition, XMLStreamWriter xtw, CmmnXmlConverterOptions options) throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)planItemDefinition.getDocumentation())) {
            xtw.writeStartElement("documentation");
            xtw.writeCharacters(planItemDefinition.getDocumentation());
            xtw.writeEndElement();
        }
        boolean didWriteExtensionStartElement = false;
        if (options.isSaveElementNameWithNewLineInExtensionElement()) {
            didWriteExtensionStartElement = CmmnXmlUtil.writeElementNameExtensionElement(planItemDefinition, didWriteExtensionStartElement, xtw);
        }
        return CmmnXmlUtil.writeExtensionElements(planItemDefinition, didWriteExtensionStartElement, model.getNamespaces(), xtw);
    }

    protected boolean writePlanItemDefinitionExtensionElements(CmmnModel model, T planItemDefinition, boolean didWriteExtensionElement, XMLStreamWriter xtw) throws Exception {
        return FlowableListenerExport.writeFlowableListeners(xtw, "planItemLifecycleListener", planItemDefinition.getLifecycleListeners(), didWriteExtensionElement);
    }

    protected void writePlanItemDefinitionDefaultItemControl(CmmnModel model, T planItemDefinition, XMLStreamWriter xtw) throws Exception {
        if (planItemDefinition.getDefaultControl() != null) {
            PlanItemControlExport.writeDefaultControl(model, planItemDefinition.getDefaultControl(), xtw);
        }
    }

    protected void writePlanItemDefinitionBody(CmmnModel model, T planItemDefinition, XMLStreamWriter xtw, CmmnXmlConverterOptions options) throws Exception {
    }

    protected void writePlanItemDefinitionEndElement(XMLStreamWriter xtw) throws Exception {
        xtw.writeEndElement();
    }
}

