/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.converter.export;

import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.converter.CmmnXmlConverterOptions;
import org.flowable.cmmn.converter.export.AbstractPlanItemDefinitionExport;
import org.flowable.cmmn.converter.export.TaskExport;
import org.flowable.cmmn.converter.util.CmmnXmlUtil;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.FormAwareServiceTask;
import org.flowable.cmmn.model.HttpServiceTask;
import org.flowable.cmmn.model.ScriptServiceTask;
import org.flowable.cmmn.model.ServiceTask;

public abstract class AbstractServiceTaskExport<T extends ServiceTask>
extends AbstractPlanItemDefinitionExport<T> {
    @Override
    public String getPlanItemDefinitionXmlElementValue(ServiceTask serviceTask) {
        return "task";
    }

    @Override
    public void writePlanItemDefinitionSpecificAttributes(T serviceTask, XMLStreamWriter xtw) throws Exception {
        super.writePlanItemDefinitionSpecificAttributes(serviceTask, xtw);
        TaskExport.writeCommonTaskAttributes(serviceTask, xtw);
        if (StringUtils.isNotEmpty((CharSequence)serviceTask.getType())) {
            xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "type", serviceTask.getType());
        }
        switch (serviceTask.getType()) {
            case "java": {
                if (StringUtils.isNotEmpty((CharSequence)serviceTask.getImplementation())) {
                    if ("class".equals(serviceTask.getImplementationType())) {
                        xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "class", serviceTask.getImplementation());
                    } else if ("expression".equals(serviceTask.getImplementationType())) {
                        xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "expression", serviceTask.getImplementation());
                    } else if ("delegateExpression".equals(serviceTask.getImplementationType())) {
                        xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "delegateExpression", serviceTask.getImplementation());
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)serviceTask.getResultVariableName())) {
                    xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "resultVariableName", serviceTask.getResultVariableName());
                }
                if (!serviceTask.isStoreResultVariableAsTransient()) break;
                xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "storeResultVariableAsTransient", String.valueOf(serviceTask.isStoreResultVariableAsTransient()));
                break;
            }
            case "http": {
                Boolean parallelInSameTransaction;
                if (StringUtils.isNotEmpty((CharSequence)serviceTask.getImplementation())) {
                    xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "class", serviceTask.getImplementation());
                }
                if ((parallelInSameTransaction = ((HttpServiceTask)serviceTask).getParallelInSameTransaction()) == null) break;
                xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "parallelInSameTransaction", parallelInSameTransaction.toString());
                break;
            }
            case "script": {
                if (StringUtils.isNotBlank((CharSequence)serviceTask.getImplementationType())) {
                    xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "scriptFormat", serviceTask.getImplementationType());
                }
                if (StringUtils.isNotEmpty((CharSequence)serviceTask.getResultVariableName())) {
                    xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "resultVariableName", serviceTask.getResultVariableName());
                }
                if (((ScriptServiceTask)serviceTask).isAutoStoreVariables()) {
                    xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "autoStoreVariables", "true");
                }
                if (!((ScriptServiceTask)serviceTask).isDoNotIncludeVariables()) break;
                xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "doNotIncludeVariables", "true");
                break;
            }
        }
    }

    @Override
    protected boolean writePlanItemDefinitionExtensionElements(CmmnModel model, T serviceTask, boolean didWriteExtensionElement, XMLStreamWriter xtw) throws Exception {
        boolean extensionElementWritten = super.writePlanItemDefinitionExtensionElements(model, serviceTask, didWriteExtensionElement, xtw);
        return TaskExport.writeTaskFieldExtensions(serviceTask, extensionElementWritten, xtw);
    }

    @Override
    protected void writePlanItemDefinitionBody(CmmnModel model, T serviceTask, XMLStreamWriter xtw, CmmnXmlConverterOptions options) throws Exception {
        super.writePlanItemDefinitionBody(model, serviceTask, xtw, options);
    }

    public static class FormAwareServiceTaskExport
    extends AbstractServiceTaskExport<FormAwareServiceTask> {
        @Override
        protected Class<? extends FormAwareServiceTask> getExportablePlanItemDefinitionClass() {
            return FormAwareServiceTask.class;
        }

        @Override
        public void writePlanItemDefinitionSpecificAttributes(FormAwareServiceTask formAwareServiceTask, XMLStreamWriter xtw) throws Exception {
            super.writePlanItemDefinitionSpecificAttributes(formAwareServiceTask, xtw);
            if (StringUtils.isNotBlank((CharSequence)formAwareServiceTask.getFormKey())) {
                xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "formKey", formAwareServiceTask.getFormKey());
            }
            if (StringUtils.isNotBlank((CharSequence)formAwareServiceTask.getValidateFormFields())) {
                xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "formFieldValidation", formAwareServiceTask.getValidateFormFields());
            }
        }
    }

    public static class ScriptServiceTaskExport
    extends AbstractServiceTaskExport<ScriptServiceTask> {
        @Override
        protected Class<? extends ScriptServiceTask> getExportablePlanItemDefinitionClass() {
            return ScriptServiceTask.class;
        }

        @Override
        protected boolean writePlanItemDefinitionExtensionElements(CmmnModel model, ScriptServiceTask serviceTask, boolean didWriteExtensionElement, XMLStreamWriter xtw) throws Exception {
            boolean extensionElementWritten = super.writePlanItemDefinitionExtensionElements(model, serviceTask, didWriteExtensionElement, xtw);
            extensionElementWritten = CmmnXmlUtil.writeIOParameters("externalWorkerInParameter", serviceTask.getInParameters(), extensionElementWritten, xtw);
            return extensionElementWritten;
        }
    }

    public static class HttpServiceTaskExport
    extends AbstractServiceTaskExport<HttpServiceTask> {
        @Override
        protected Class<? extends HttpServiceTask> getExportablePlanItemDefinitionClass() {
            return HttpServiceTask.class;
        }
    }

    public static class ServiceTaskExport
    extends AbstractServiceTaskExport<ServiceTask> {
        @Override
        protected Class<? extends ServiceTask> getExportablePlanItemDefinitionClass() {
            return ServiceTask.class;
        }
    }
}

