/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.configurator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.cmmn.engine.CmmnEngine;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.configurator.impl.deployer.CmmnDeployer;
import org.flowable.cmmn.engine.configurator.impl.process.DefaultProcessInstanceService;
import org.flowable.cmmn.engine.impl.callback.ChildProcessInstanceStateChangeCallback;
import org.flowable.cmmn.engine.impl.db.EntityDependencyOrder;
import org.flowable.cmmn.engine.impl.process.ProcessInstanceService;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.AbstractEngineConfigurator;
import org.flowable.common.engine.impl.EngineDeployer;
import org.flowable.common.engine.impl.HasTaskIdGeneratorEngineConfiguration;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;

public class CmmnEngineConfigurator
extends AbstractEngineConfigurator {
    protected CmmnEngineConfiguration cmmnEngineConfiguration;

    public int getPriority() {
        return 500000;
    }

    protected List<EngineDeployer> getCustomDeployers() {
        return Collections.singletonList(new CmmnDeployer());
    }

    protected String getMybatisCfgPath() {
        return "org/flowable/cmmn/db/mapping/mappings.xml";
    }

    public void configure(AbstractEngineConfiguration engineConfiguration) {
        if (this.cmmnEngineConfiguration == null) {
            this.cmmnEngineConfiguration = new CmmnEngineConfiguration();
        }
        this.initialiseCommonProperties(engineConfiguration, (AbstractEngineConfiguration)this.cmmnEngineConfiguration);
        if (engineConfiguration.getEngineConfigurations().containsKey("cfg.processEngine")) {
            ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)engineConfiguration.getEngineConfigurations().get("cfg.processEngine");
            this.initProcessInstanceService(processEngineConfiguration);
            this.initProcessInstanceStateChangedCallbacks(processEngineConfiguration);
            this.cmmnEngineConfiguration.setEnableTaskRelationshipCounts(processEngineConfiguration.getPerformanceSettings().isEnableTaskRelationshipCounts());
            this.cmmnEngineConfiguration.setTaskQueryLimit(processEngineConfiguration.getTaskQueryLimit());
            this.cmmnEngineConfiguration.setHistoricTaskQueryLimit(processEngineConfiguration.getHistoricTaskQueryLimit());
            this.cmmnEngineConfiguration.setCaseQueryLimit(processEngineConfiguration.getExecutionQueryLimit());
            this.cmmnEngineConfiguration.setHistoricCaseQueryLimit(processEngineConfiguration.getHistoricProcessInstancesQueryLimit());
        }
        this.cmmnEngineConfiguration.setExecuteServiceDbSchemaManagers(false);
        this.initCmmnEngine();
        this.initServiceConfigurations(engineConfiguration, (AbstractEngineConfiguration)this.cmmnEngineConfiguration);
    }

    protected void initProcessInstanceService(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.cmmnEngineConfiguration.setProcessInstanceService((ProcessInstanceService)new DefaultProcessInstanceService(processEngineConfiguration.getRuntimeService()));
    }

    protected void initProcessInstanceStateChangedCallbacks(ProcessEngineConfigurationImpl processEngineConfiguration) {
        Map callbacks;
        if (processEngineConfiguration.getProcessInstanceStateChangedCallbacks() == null) {
            processEngineConfiguration.setProcessInstanceStateChangedCallbacks(new HashMap());
        }
        if (!(callbacks = processEngineConfiguration.getProcessInstanceStateChangedCallbacks()).containsKey("cmmn-1.1-to-bpmn-2.0-child-process")) {
            callbacks.put("cmmn-1.1-to-bpmn-2.0-child-process", new ArrayList());
        }
        ((List)callbacks.get("cmmn-1.1-to-bpmn-2.0-child-process")).add(new ChildProcessInstanceStateChangeCallback(this.cmmnEngineConfiguration));
    }

    protected List<Class<? extends Entity>> getEntityInsertionOrder() {
        return EntityDependencyOrder.INSERT_ORDER;
    }

    protected List<Class<? extends Entity>> getEntityDeletionOrder() {
        return EntityDependencyOrder.DELETE_ORDER;
    }

    protected synchronized CmmnEngine initCmmnEngine() {
        if (this.cmmnEngineConfiguration == null) {
            throw new FlowableException("CmmnEngineConfiguration is required");
        }
        return this.cmmnEngineConfiguration.buildCmmnEngine();
    }

    protected void initIdGenerator(AbstractEngineConfiguration engineConfiguration, AbstractEngineConfiguration targetEngineConfiguration) {
        HasTaskIdGeneratorEngineConfiguration targetEgineConfiguration;
        super.initIdGenerator(engineConfiguration, targetEngineConfiguration);
        if (targetEngineConfiguration instanceof HasTaskIdGeneratorEngineConfiguration && (targetEgineConfiguration = (HasTaskIdGeneratorEngineConfiguration)targetEngineConfiguration).getTaskIdGenerator() == null) {
            if (engineConfiguration instanceof HasTaskIdGeneratorEngineConfiguration) {
                targetEgineConfiguration.setTaskIdGenerator(((HasTaskIdGeneratorEngineConfiguration)engineConfiguration).getTaskIdGenerator());
            } else {
                targetEgineConfiguration.setTaskIdGenerator(engineConfiguration.getIdGenerator());
            }
        }
    }

    public CmmnEngineConfiguration getCmmnEngineConfiguration() {
        return this.cmmnEngineConfiguration;
    }

    public CmmnEngineConfigurator setCmmnEngineConfiguration(CmmnEngineConfiguration cmmnEngineConfiguration) {
        this.cmmnEngineConfiguration = cmmnEngineConfiguration;
        return this;
    }
}

