/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.configurator.impl.cmmn;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.CmmnRuntimeService;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.api.runtime.CaseInstanceBuilder;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.cmmn.CaseInstanceService;
import org.flowable.eventsubscription.service.impl.persistence.entity.EventSubscriptionEntity;

public class DefaultCaseInstanceService
implements CaseInstanceService {
    protected CmmnEngineConfiguration cmmnEngineConfiguration;

    public DefaultCaseInstanceService(CmmnEngineConfiguration cmmnEngineConfiguration) {
        this.cmmnEngineConfiguration = cmmnEngineConfiguration;
    }

    public String generateNewCaseInstanceId() {
        if (this.cmmnEngineConfiguration.isUsePrefixId()) {
            return "CAS-" + this.cmmnEngineConfiguration.getIdGenerator().getNextId();
        }
        return this.cmmnEngineConfiguration.getIdGenerator().getNextId();
    }

    public String startCaseInstanceByKey(String caseDefinitionKey, String predefinedCaseInstanceId, String caseInstanceName, String businessKey, String executionId, String tenantId, boolean fallbackToDefaultTenant, String parentDeploymentId, Map<String, Object> inParametersMap) {
        CaseInstanceBuilder caseInstanceBuilder = this.cmmnEngineConfiguration.getCmmnRuntimeService().createCaseInstanceBuilder();
        caseInstanceBuilder.caseDefinitionKey(caseDefinitionKey);
        if (parentDeploymentId != null) {
            caseInstanceBuilder.caseDefinitionParentDeploymentId(parentDeploymentId);
        }
        if (predefinedCaseInstanceId != null) {
            caseInstanceBuilder.predefinedCaseInstanceId(predefinedCaseInstanceId);
        }
        if (tenantId != null) {
            caseInstanceBuilder.tenantId(tenantId);
        }
        if (executionId != null) {
            caseInstanceBuilder.callbackId(executionId);
            caseInstanceBuilder.callbackType("bpmn-2.0-to-cmmn-1.1-child-case");
        }
        for (String target : inParametersMap.keySet()) {
            caseInstanceBuilder.variable(target, inParametersMap.get(target));
        }
        if (fallbackToDefaultTenant) {
            caseInstanceBuilder.fallbackToDefaultTenant();
        }
        if (businessKey != null) {
            caseInstanceBuilder.businessKey(businessKey);
        }
        if (caseInstanceName != null) {
            caseInstanceBuilder.name(caseInstanceName);
        }
        CaseInstance caseInstance = caseInstanceBuilder.start();
        return caseInstance.getId();
    }

    public void handleSignalEvent(EventSubscriptionEntity eventSubscription, Map<String, Object> variables) {
        if (StringUtils.isEmpty((CharSequence)eventSubscription.getSubScopeId())) {
            throw new FlowableException("Plan item instance for event subscription can not be found with empty sub scope id value");
        }
        CmmnRuntimeService cmmnRuntimeService = this.cmmnEngineConfiguration.getCmmnRuntimeService();
        PlanItemInstance planItemInstance = (PlanItemInstance)cmmnRuntimeService.createPlanItemInstanceQuery().planItemInstanceId(eventSubscription.getSubScopeId()).singleResult();
        if (planItemInstance == null) {
            throw new FlowableException("Plan item instance for event subscription can not be found with sub scope id " + eventSubscription.getSubScopeId());
        }
        cmmnRuntimeService.createPlanItemInstanceTransitionBuilder(planItemInstance.getId()).variables(variables).trigger();
    }

    public void deleteCaseInstance(String caseInstanceId) {
        this.cmmnEngineConfiguration.getCommandExecutor().execute(commandContext -> {
            CaseInstanceEntity caseInstanceEntity = (CaseInstanceEntity)CommandContextUtil.getCaseInstanceEntityManager((CommandContext)commandContext).findById(caseInstanceId);
            if (caseInstanceEntity == null || caseInstanceEntity.isDeleted()) {
                return null;
            }
            CommandContextUtil.getAgenda((CommandContext)commandContext).planManualTerminateCaseInstanceOperation(caseInstanceEntity.getId());
            return null;
        });
    }

    public void deleteCaseInstancesForExecutionId(String executionId) {
        CmmnRuntimeService cmmnRuntimeService = this.cmmnEngineConfiguration.getCmmnRuntimeService();
        List caseInstances = cmmnRuntimeService.createCaseInstanceQuery().caseInstanceCallbackType("bpmn-2.0-to-cmmn-1.1-child-case").caseInstanceCallbackId(executionId).list();
        for (CaseInstance caseInstance : caseInstances) {
            this.deleteCaseInstance(caseInstance.getId());
        }
    }

    public void deleteCaseInstanceWithoutAgenda(String caseInstanceId) {
        this.cmmnEngineConfiguration.getCommandExecutor().execute(commandContext -> {
            CaseInstanceEntity caseInstanceEntity = (CaseInstanceEntity)CommandContextUtil.getCaseInstanceEntityManager((CommandContext)commandContext).findById(caseInstanceId);
            if (caseInstanceEntity == null || caseInstanceEntity.isDeleted()) {
                return null;
            }
            this.cmmnEngineConfiguration.getCmmnHistoryManager().recordCaseInstanceEnd(caseInstanceEntity, "terminated", this.cmmnEngineConfiguration.getClock().getCurrentTime());
            this.cmmnEngineConfiguration.getCaseInstanceEntityManager().delete(caseInstanceEntity.getId(), false, "cmmn-state-transition-delete-case");
            return null;
        });
    }
}

