/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.agenda;

import org.flowable.cmmn.engine.impl.agenda.CmmnEngineAgenda;
import org.flowable.cmmn.engine.impl.agenda.operation.ActivatePlanItemInstanceOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.CmmnOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.CompleteCaseInstanceOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.CompletePlanItemInstanceOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.EvaluateCriteriaOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.ExitPlanItemInstanceOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.InitPlanModelInstanceOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.InitStageInstanceOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.OccurPlanItemInstanceOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.TerminateCaseInstanceOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.TerminatePlanItemInstanceOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.TriggerPlanItemInstanceOperation;
import org.flowable.cmmn.engine.impl.criteria.PlanItemLifeCycleEvent;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.engine.common.impl.agenda.AbstractAgenda;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCmmnEngineAgenda
extends AbstractAgenda
implements CmmnEngineAgenda {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCmmnEngineAgenda.class);

    public DefaultCmmnEngineAgenda(CommandContext commandContext) {
        super(commandContext);
    }

    public void addOperation(CmmnOperation operation, String caseInstanceId) {
        this.operations.add(operation);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Planned {}", (Object)operation);
        }
        if (caseInstanceId != null) {
            CommandContextUtil.addInvolvedCaseInstanceId(this.commandContext, caseInstanceId);
        }
    }

    @Override
    public void planInitPlanModelOperation(CaseInstanceEntity caseInstanceEntity) {
        this.addOperation(new InitPlanModelInstanceOperation(this.commandContext, caseInstanceEntity), caseInstanceEntity.getId());
    }

    @Override
    public void planInitStageOperation(PlanItemInstanceEntity planItemInstanceEntity) {
        this.addOperation(new InitStageInstanceOperation(this.commandContext, planItemInstanceEntity), planItemInstanceEntity.getCaseInstanceId());
    }

    @Override
    public void planEvaluateCriteria(String caseInstanceEntityId) {
        this.addOperation(new EvaluateCriteriaOperation(this.commandContext, caseInstanceEntityId), caseInstanceEntityId);
    }

    @Override
    public void planEvaluateCriteria(String caseInstanceEntityId, PlanItemLifeCycleEvent lifeCycleEvent) {
        this.addOperation(new EvaluateCriteriaOperation(this.commandContext, caseInstanceEntityId, lifeCycleEvent), caseInstanceEntityId);
    }

    @Override
    public void planActivatePlanItemInstance(PlanItemInstanceEntity planItemInstanceEntity) {
        this.addOperation(new ActivatePlanItemInstanceOperation(this.commandContext, planItemInstanceEntity), planItemInstanceEntity.getCaseInstanceId());
    }

    @Override
    public void planCompletePlanItemInstance(PlanItemInstanceEntity planItemInstanceEntity) {
        this.addOperation(new CompletePlanItemInstanceOperation(this.commandContext, planItemInstanceEntity), planItemInstanceEntity.getCaseInstanceId());
    }

    @Override
    public void planOccurPlanItemInstance(PlanItemInstanceEntity planItemInstanceEntity) {
        this.addOperation(new OccurPlanItemInstanceOperation(this.commandContext, planItemInstanceEntity), planItemInstanceEntity.getCaseInstanceId());
    }

    @Override
    public void planExitPlanItemInstance(PlanItemInstanceEntity planItemInstanceEntity) {
        this.addOperation(new ExitPlanItemInstanceOperation(this.commandContext, planItemInstanceEntity), planItemInstanceEntity.getCaseInstanceId());
    }

    @Override
    public void planTerminatePlanItemInstance(PlanItemInstanceEntity planItemInstanceEntity) {
        this.addOperation(new TerminatePlanItemInstanceOperation(this.commandContext, planItemInstanceEntity), planItemInstanceEntity.getCaseInstanceId());
    }

    @Override
    public void planTriggerPlanItemInstance(PlanItemInstanceEntity planItemInstanceEntity) {
        this.addOperation(new TriggerPlanItemInstanceOperation(this.commandContext, planItemInstanceEntity), planItemInstanceEntity.getCaseInstanceId());
    }

    @Override
    public void planCompleteCaseInstance(CaseInstanceEntity caseInstanceEntity) {
        this.addOperation(new CompleteCaseInstanceOperation(this.commandContext, caseInstanceEntity), caseInstanceEntity.getId());
    }

    @Override
    public void planTerminateCaseInstance(String caseInstanceEntityId, boolean manualTermination) {
        this.addOperation(new TerminateCaseInstanceOperation(this.commandContext, caseInstanceEntityId, manualTermination), caseInstanceEntityId);
    }
}

