/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.agenda.operation;

import java.util.ArrayList;
import java.util.List;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntityManager;
import org.flowable.cmmn.engine.impl.repository.CaseDefinitionUtil;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.cmmn.model.Stage;
import org.flowable.engine.common.api.delegate.Expression;
import org.flowable.engine.common.api.variable.VariableContainer;
import org.flowable.engine.common.impl.el.ExpressionManager;
import org.flowable.engine.common.impl.interceptor.CommandContext;

public abstract class CmmnOperation
implements Runnable {
    protected CommandContext commandContext;

    public CmmnOperation() {
    }

    public CmmnOperation(CommandContext commandContext) {
        this.commandContext = commandContext;
    }

    protected Stage getStage(PlanItemInstanceEntity planItemInstanceEntity) {
        if (planItemInstanceEntity.getPlanItem() != null && planItemInstanceEntity.getPlanItem().getPlanItemDefinition() != null) {
            PlanItemDefinition planItemDefinition = planItemInstanceEntity.getPlanItem().getPlanItemDefinition();
            if (planItemDefinition instanceof Stage) {
                return (Stage)planItemDefinition;
            }
            return planItemDefinition.getParentStage();
        }
        return this.getStage(planItemInstanceEntity.getCaseDefinitionId(), planItemInstanceEntity.getElementId());
    }

    protected Stage getStage(String caseDefinitionId, String stageId) {
        return CaseDefinitionUtil.getCase(caseDefinitionId).findStage(stageId);
    }

    protected boolean isStage(PlanItemInstanceEntity planItemInstanceEntity) {
        return planItemInstanceEntity.getPlanItem() != null && planItemInstanceEntity.getPlanItem().getPlanItemDefinition() != null && planItemInstanceEntity.getPlanItem().getPlanItemDefinition() instanceof Stage;
    }

    protected Stage getPlanModel(CaseInstanceEntity caseInstanceEntity) {
        return CaseDefinitionUtil.getCase(caseInstanceEntity.getCaseDefinitionId()).getPlanModel();
    }

    protected List<PlanItemInstanceEntity> createPlanItemInstances(CommandContext commandContext, List<PlanItem> planItems, String caseDefinitionId, String caseInstanceId, String stagePlanItemInstanceId, String tenantId) {
        ExpressionManager expressionManager = CommandContextUtil.getExpressionManager(commandContext);
        PlanItemInstanceEntityManager planItemInstanceEntityManager = CommandContextUtil.getPlanItemInstanceEntityManager(commandContext);
        CaseInstanceEntity caseInstanceEntity = (CaseInstanceEntity)CommandContextUtil.getCaseInstanceEntityManager(commandContext).findById(caseInstanceId);
        ArrayList<PlanItemInstanceEntity> planItemInstances = new ArrayList<PlanItemInstanceEntity>();
        for (PlanItem planItem : planItems) {
            PlanItemInstanceEntity planItemInstanceEntity = (PlanItemInstanceEntity)planItemInstanceEntityManager.create();
            planItemInstanceEntity.setCaseDefinitionId(caseDefinitionId);
            planItemInstanceEntity.setCaseInstanceId(caseInstanceId);
            if (planItem.getName() != null) {
                Expression nameExpression = expressionManager.createExpression(planItem.getName());
                planItemInstanceEntity.setName(nameExpression.getValue((VariableContainer)caseInstanceEntity).toString());
            }
            planItemInstanceEntity.setState("available");
            planItemInstanceEntity.setStartTime(CommandContextUtil.getCmmnEngineConfiguration(commandContext).getClock().getCurrentTime());
            planItemInstanceEntity.setElementId(planItem.getId());
            planItemInstanceEntity.setStage(false);
            planItemInstanceEntity.setStageInstanceId(stagePlanItemInstanceId);
            planItemInstanceEntity.setTenantId(tenantId);
            planItemInstanceEntityManager.insert(planItemInstanceEntity);
            planItemInstances.add(planItemInstanceEntity);
        }
        return planItemInstances;
    }
}

