/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.agenda.operation;

import java.util.HashSet;
import java.util.List;
import org.flowable.cmmn.engine.impl.agenda.operation.AbstractCaseInstanceOperation;
import org.flowable.cmmn.engine.impl.criteria.PlanItemLifeCycleEvent;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.EntityWithSentryPartInstances;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.SentryPartInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.SentryPartInstanceEntityManager;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.Criterion;
import org.flowable.cmmn.model.HasExitCriteria;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.Sentry;
import org.flowable.cmmn.model.SentryIfPart;
import org.flowable.cmmn.model.SentryOnPart;
import org.flowable.cmmn.model.Stage;
import org.flowable.engine.common.api.delegate.Expression;
import org.flowable.engine.common.api.variable.VariableContainer;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluateCriteriaOperation
extends AbstractCaseInstanceOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(EvaluateCriteriaOperation.class);
    protected PlanItemLifeCycleEvent planItemLifeCycleEvent;

    public EvaluateCriteriaOperation(CommandContext commandContext, String caseInstanceEntityId) {
        super(commandContext, caseInstanceEntityId, null);
    }

    public EvaluateCriteriaOperation(CommandContext commandContext, String caseInstanceEntityId, PlanItemLifeCycleEvent planItemLifeCycleEvent) {
        super(commandContext, caseInstanceEntityId, null);
        this.planItemLifeCycleEvent = planItemLifeCycleEvent;
    }

    @Override
    public void run() {
        super.run();
        CriteriaEvaluationResult planModelExitCriteriaEvaluationResult = this.evaluateExitCriteria(this.caseInstanceEntity, (HasExitCriteria)this.getPlanModel(this.caseInstanceEntity));
        if (CriteriaEvaluationResult.SENTRY_SATISFIED.equals((Object)planModelExitCriteriaEvaluationResult)) {
            CommandContextUtil.getAgenda(this.commandContext).planTerminateCaseInstance(this.caseInstanceEntity.getId(), false);
        } else {
            boolean criteriaChangeOrActiveChildren = this.evaluatePlanItemsCriteria(this.caseInstanceEntity.getChildPlanItemInstances());
            if (!criteriaChangeOrActiveChildren) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("No active plan items found for plan model, completing case instance");
                }
                CommandContextUtil.getAgenda(this.commandContext).planCompleteCaseInstance(this.caseInstanceEntity);
            }
        }
    }

    protected boolean evaluatePlanItemsCriteria(List<PlanItemInstanceEntity> planItemInstances) {
        int activeChildren = 0;
        boolean criteriaChanged = false;
        for (PlanItemInstanceEntity planItemInstanceEntity : planItemInstances) {
            PlanItem planItem = planItemInstanceEntity.getPlanItem();
            CriteriaEvaluationResult evaluationResult = null;
            if ("available".equals(planItemInstanceEntity.getState())) {
                evaluationResult = this.evaluateEntryCriteria(planItemInstanceEntity, planItem);
                if (evaluationResult.equals((Object)CriteriaEvaluationResult.SENTRY_SATISFIED)) {
                    CommandContextUtil.getAgenda(this.commandContext).planActivatePlanItemInstance(planItemInstanceEntity);
                }
            } else if ("active".equals(planItemInstanceEntity.getState())) {
                evaluationResult = this.evaluateExitCriteria(planItemInstanceEntity, (HasExitCriteria)planItem);
                if (evaluationResult.equals((Object)CriteriaEvaluationResult.SENTRY_SATISFIED)) {
                    CommandContextUtil.getAgenda(this.commandContext).planExitPlanItemInstance(planItemInstanceEntity);
                } else if (planItem.getPlanItemDefinition() instanceof Stage) {
                    boolean criteriaChangeOrActiveChildrenForStage = this.evaluateStagePlanItemInstance(planItemInstanceEntity);
                    if (criteriaChangeOrActiveChildrenForStage) {
                        ++activeChildren;
                    } else {
                        CommandContextUtil.getAgenda(this.commandContext).planCompletePlanItemInstance(planItemInstanceEntity);
                    }
                } else {
                    ++activeChildren;
                }
            }
            if (evaluationResult == null || evaluationResult.equals((Object)CriteriaEvaluationResult.NONE)) continue;
            criteriaChanged = true;
        }
        return criteriaChanged || activeChildren > 0;
    }

    protected boolean evaluateStagePlanItemInstance(PlanItemInstanceEntity stagePlanItemInstanceEntity) {
        if (!"active".equals(stagePlanItemInstanceEntity.getState())) {
            return false;
        }
        if (stagePlanItemInstanceEntity.getChildren() != null) {
            return this.evaluatePlanItemsCriteria(stagePlanItemInstanceEntity.getChildren());
        }
        return false;
    }

    protected CriteriaEvaluationResult evaluateEntryCriteria(PlanItemInstanceEntity planItemInstanceEntity, PlanItem planItem) {
        List criteria = planItem.getEntryCriteria();
        if (criteria == null || criteria.isEmpty()) {
            return CriteriaEvaluationResult.SENTRY_SATISFIED;
        }
        return this.evaluateCriteria(planItemInstanceEntity, criteria);
    }

    protected CriteriaEvaluationResult evaluateExitCriteria(EntityWithSentryPartInstances entityWithSentryPartInstances, HasExitCriteria hasExitCriteria) {
        List criteria = hasExitCriteria.getExitCriteria();
        if (criteria != null && !criteria.isEmpty()) {
            return this.evaluateCriteria(entityWithSentryPartInstances, criteria);
        }
        return CriteriaEvaluationResult.NONE;
    }

    protected CriteriaEvaluationResult evaluateCriteria(EntityWithSentryPartInstances entityWithSentryPartInstances, List<Criterion> criteria) {
        boolean partTriggered = false;
        for (Criterion entryCriterion : criteria) {
            Sentry sentry = entryCriterion.getSentry();
            if (sentry.getOnParts().size() == 1 && sentry.getSentryIfPart() == null) {
                SentryOnPart sentryOnPart;
                if (this.planItemLifeCycleEvent == null || !this.sentryOnPartMatchesCurrentLifeCycleEvent(sentryOnPart = (SentryOnPart)sentry.getOnParts().get(0))) continue;
                return CriteriaEvaluationResult.SENTRY_SATISFIED;
            }
            if (sentry.getOnParts().isEmpty() && sentry.getSentryIfPart() != null) {
                if (!this.evaluateSentryIfPart(sentry, entityWithSentryPartInstances)) continue;
                return CriteriaEvaluationResult.SENTRY_SATISFIED;
            }
            boolean sentryIfPartSatisfied = false;
            HashSet<String> satisfiedSentryOnPartIds = new HashSet<String>(1);
            for (SentryPartInstanceEntity sentryPartInstanceEntity : entityWithSentryPartInstances.getSatisfiedSentryPartInstances()) {
                if (sentryPartInstanceEntity.getOnPartId() != null) {
                    satisfiedSentryOnPartIds.add(sentryPartInstanceEntity.getOnPartId());
                    continue;
                }
                if (sentryPartInstanceEntity.getIfPartId() == null || !sentryPartInstanceEntity.getIfPartId().equals(sentry.getSentryIfPart().getId())) continue;
                sentryIfPartSatisfied = true;
            }
            boolean criteriaSatisfied = false;
            for (SentryOnPart sentryOnPart : sentry.getOnParts()) {
                if (satisfiedSentryOnPartIds.contains(sentryOnPart.getId()) || this.planItemLifeCycleEvent == null || !this.sentryOnPartMatchesCurrentLifeCycleEvent(sentryOnPart)) continue;
                this.createSentryPartInstanceEntity(entityWithSentryPartInstances, sentryOnPart, null);
                satisfiedSentryOnPartIds.add(sentryOnPart.getId());
                criteriaSatisfied = true;
            }
            if (sentry.getSentryIfPart() != null && !sentryIfPartSatisfied && this.evaluateSentryIfPart(sentry, entityWithSentryPartInstances)) {
                this.createSentryPartInstanceEntity(entityWithSentryPartInstances, null, sentry.getSentryIfPart());
                sentryIfPartSatisfied = true;
                criteriaSatisfied = true;
            }
            if (entityWithSentryPartInstances.getSatisfiedSentryPartInstances().size() == sentry.getOnParts().size() + (sentry.getSentryIfPart() != null ? 1 : 0)) {
                return CriteriaEvaluationResult.SENTRY_SATISFIED;
            }
            if (!criteriaSatisfied) continue;
            partTriggered = true;
        }
        return partTriggered ? CriteriaEvaluationResult.PART_TRIGGERED : CriteriaEvaluationResult.NONE;
    }

    public boolean sentryOnPartMatchesCurrentLifeCycleEvent(SentryOnPart sentryOnPart) {
        return this.planItemLifeCycleEvent.getPlanItem().getId().equals(sentryOnPart.getSourceRef()) && this.planItemLifeCycleEvent.getTransition().equals(sentryOnPart.getStandardEvent());
    }

    protected SentryPartInstanceEntity createSentryPartInstanceEntity(EntityWithSentryPartInstances entityWithSentryPartInstances, SentryOnPart sentryOnPart, SentryIfPart sentryIfPart) {
        SentryPartInstanceEntityManager sentryPartInstanceEntityManager = CommandContextUtil.getSentryPartInstanceEntityManager(this.commandContext);
        SentryPartInstanceEntity sentryPartInstanceEntity = (SentryPartInstanceEntity)sentryPartInstanceEntityManager.create();
        sentryPartInstanceEntity.setTimeStamp(CommandContextUtil.getCmmnEngineConfiguration(this.commandContext).getClock().getCurrentTime());
        if (sentryOnPart != null) {
            sentryPartInstanceEntity.setOnPartId(sentryOnPart.getId());
        } else if (sentryIfPart != null) {
            sentryPartInstanceEntity.setIfPartId(sentryIfPart.getId());
        }
        if (entityWithSentryPartInstances instanceof CaseInstanceEntity) {
            sentryPartInstanceEntity.setCaseInstanceId(((CaseInstanceEntity)entityWithSentryPartInstances).getId());
            sentryPartInstanceEntity.setCaseDefinitionId(((CaseInstanceEntity)entityWithSentryPartInstances).getCaseDefinitionId());
        } else if (entityWithSentryPartInstances instanceof PlanItemInstanceEntity) {
            sentryPartInstanceEntity.setCaseInstanceId(((PlanItemInstanceEntity)entityWithSentryPartInstances).getCaseInstanceId());
            sentryPartInstanceEntity.setCaseDefinitionId(((PlanItemInstanceEntity)entityWithSentryPartInstances).getCaseDefinitionId());
            sentryPartInstanceEntity.setPlanItemInstanceId(((PlanItemInstanceEntity)entityWithSentryPartInstances).getId());
        }
        sentryPartInstanceEntityManager.insert(sentryPartInstanceEntity);
        entityWithSentryPartInstances.getSatisfiedSentryPartInstances().add(sentryPartInstanceEntity);
        return sentryPartInstanceEntity;
    }

    protected boolean evaluateSentryIfPart(Sentry sentry, EntityWithSentryPartInstances entityWithSentryPartInstances) {
        Expression conditionExpression = CommandContextUtil.getExpressionManager(this.commandContext).createExpression(sentry.getSentryIfPart().getCondition());
        Object result = conditionExpression.getValue((VariableContainer)entityWithSentryPartInstances);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[Evaluate Criteria] case instance ");
        if (this.caseInstanceEntity != null) {
            stringBuilder.append(this.caseInstanceEntity.getId());
        } else {
            stringBuilder.append(this.caseInstanceEntityId);
        }
        if (this.planItemLifeCycleEvent != null) {
            stringBuilder.append(" with transition ").append(this.planItemLifeCycleEvent.getTransition()).append(" having fired");
            if (this.planItemLifeCycleEvent.getPlanItem() != null) {
                stringBuilder.append(" for plan item ").append(this.planItemLifeCycleEvent.getPlanItem().getId());
                if (this.planItemLifeCycleEvent.getPlanItem().getName() != null) {
                    stringBuilder.append(" (").append(this.planItemLifeCycleEvent.getPlanItem().getName()).append(")");
                }
            }
        }
        return stringBuilder.toString();
    }

    private static enum CriteriaEvaluationResult {
        SENTRY_SATISFIED,
        PART_TRIGGERED,
        NONE;

    }
}

