/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.behavior.impl;

import java.util.List;
import org.flowable.cmmn.api.delegate.PlanItemJavaDelegate;
import org.flowable.cmmn.engine.impl.behavior.CoreCmmnActivityBehavior;
import org.flowable.cmmn.engine.impl.behavior.PlanItemActivityBehavior;
import org.flowable.cmmn.engine.impl.behavior.impl.PlanItemJavaDelegateActivityBehavior;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.engine.impl.util.DelegateExpressionUtil;
import org.flowable.cmmn.model.FieldExtension;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.delegate.Expression;
import org.flowable.engine.common.impl.interceptor.CommandContext;

public class PlanItemDelegateExpressionActivityBehavior
extends CoreCmmnActivityBehavior {
    protected String expression;
    protected List<FieldExtension> fieldExtensions;

    public PlanItemDelegateExpressionActivityBehavior(String expression, List<FieldExtension> fieldExtensions) {
        this.expression = expression;
        this.fieldExtensions = fieldExtensions;
    }

    @Override
    public void execute(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        block4: {
            try {
                Expression expressionObject = CommandContextUtil.getCmmnEngineConfiguration(commandContext).getExpressionManager().createExpression(this.expression);
                Object delegate = DelegateExpressionUtil.resolveDelegateExpression(expressionObject, planItemInstanceEntity, this.fieldExtensions);
                if (delegate instanceof PlanItemActivityBehavior) {
                    ((PlanItemActivityBehavior)delegate).execute(planItemInstanceEntity);
                    break block4;
                }
                if (delegate instanceof PlanItemJavaDelegate) {
                    PlanItemJavaDelegateActivityBehavior behavior = new PlanItemJavaDelegateActivityBehavior((PlanItemJavaDelegate)delegate);
                    behavior.execute(planItemInstanceEntity);
                    break block4;
                }
                throw new FlowableIllegalArgumentException("Delegate expression " + this.expression + " did neither resolve to an implementation of " + PlanItemActivityBehavior.class + " nor " + PlanItemJavaDelegate.class);
            }
            catch (Exception exc) {
                throw new FlowableException(exc.getMessage(), (Throwable)exc);
            }
        }
    }
}

