/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.behavior.impl;

import java.util.List;
import org.flowable.cmmn.api.delegate.DelegatePlanItemInstance;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.engine.impl.behavior.CoreCmmnTriggerableActivityBehavior;
import org.flowable.cmmn.engine.impl.behavior.PlanItemActivityBehavior;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.runtime.StateTransition;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.Stage;
import org.flowable.engine.common.api.delegate.Expression;
import org.flowable.engine.common.api.variable.VariableContainer;
import org.flowable.engine.common.impl.interceptor.CommandContext;

public class StageActivityBehavior
extends CoreCmmnTriggerableActivityBehavior
implements PlanItemActivityBehavior {
    protected Stage stage;

    public StageActivityBehavior(Stage stage) {
        this.stage = stage;
    }

    @Override
    public void execute(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        if (planItemInstanceEntity.getPlanItem().getName() != null) {
            Expression nameExpression = CommandContextUtil.getExpressionManager(commandContext).createExpression(planItemInstanceEntity.getPlanItem().getName());
            planItemInstanceEntity.setName(nameExpression.getValue((VariableContainer)planItemInstanceEntity).toString());
        }
        CommandContextUtil.getAgenda(commandContext).planInitStageOperation(planItemInstanceEntity);
    }

    @Override
    public void trigger(CommandContext commandContext, PlanItemInstanceEntity planItemInstance) {
        List<PlanItemInstanceEntity> childPlanItemInstances = planItemInstance.getChildren();
        if (childPlanItemInstances != null) {
            for (PlanItemInstanceEntity childPlanItemInstance : childPlanItemInstances) {
                if (!StateTransition.isPossible((PlanItemInstance)planItemInstance, "complete")) continue;
                CommandContextUtil.getAgenda().planCompletePlanItemInstance(childPlanItemInstance);
            }
        }
        CommandContextUtil.getAgenda(commandContext).planCompletePlanItemInstance(planItemInstance);
    }

    @Override
    public void onStateTransition(CommandContext commandContext, DelegatePlanItemInstance planItemInstance, String transition) {
        if ("terminate".equals(transition) || "exit".equals(transition)) {
            this.handleChildPlanItemInstances(commandContext, planItemInstance, transition);
        }
    }

    protected void handleChildPlanItemInstances(CommandContext commandContext, DelegatePlanItemInstance planItemInstance, String transition) {
        PlanItemInstanceEntity planItemInstanceEntity = (PlanItemInstanceEntity)planItemInstance;
        List<PlanItemInstanceEntity> childPlanItemInstances = planItemInstanceEntity.getChildren();
        if (childPlanItemInstances != null) {
            for (PlanItemInstanceEntity childPlanItemInstance : childPlanItemInstances) {
                if (!StateTransition.isPossible((PlanItemInstance)planItemInstance, transition)) continue;
                if ("terminate".equals(transition)) {
                    CommandContextUtil.getAgenda(commandContext).planTerminatePlanItemInstance(childPlanItemInstance);
                    continue;
                }
                if (!"exit".equals(transition)) continue;
                CommandContextUtil.getAgenda(commandContext).planExitPlanItemInstance(childPlanItemInstance);
            }
        }
    }
}

