/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseDefinitionEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.CmmnDeploymentEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.CmmnResourceEntity;
import org.flowable.cmmn.model.Case;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.engine.common.api.FlowableException;

public class CmmnParseResult {
    protected CmmnDeploymentEntity deploymentEntity;
    protected List<CaseDefinitionEntity> definitions = new ArrayList<CaseDefinitionEntity>();
    protected Map<CaseDefinitionEntity, CmmnModel> mapDefinitionsToCmmnModel = new HashMap<CaseDefinitionEntity, CmmnModel>();
    protected Map<CaseDefinitionEntity, CmmnResourceEntity> mapDefinitionsToResources = new HashMap<CaseDefinitionEntity, CmmnResourceEntity>();

    public CmmnParseResult() {
    }

    public CmmnParseResult(CmmnDeploymentEntity entity) {
        this.deploymentEntity = entity;
    }

    public CmmnDeploymentEntity getDeployment() {
        return this.deploymentEntity;
    }

    public void addCaseDefinition(CaseDefinitionEntity caseDefinitionEntity) {
        this.definitions.add(caseDefinitionEntity);
    }

    public List<CaseDefinitionEntity> getAllCaseDefinitions() {
        return this.definitions;
    }

    public void addCaseDefinition(CaseDefinitionEntity caseDefinitionEntity, CmmnResourceEntity resourceEntity, CmmnModel cmmnModel) {
        this.definitions.add(caseDefinitionEntity);
        this.mapDefinitionsToResources.put(caseDefinitionEntity, resourceEntity);
        this.mapDefinitionsToCmmnModel.put(caseDefinitionEntity, cmmnModel);
    }

    public CmmnResourceEntity getResourceForCaseDefinition(CaseDefinitionEntity caseDefinition) {
        return this.mapDefinitionsToResources.get(caseDefinition);
    }

    public CmmnModel getCmmnModelForCaseDefinition(CaseDefinitionEntity caseDefinition) {
        return this.mapDefinitionsToCmmnModel.get(caseDefinition);
    }

    public Case getCmmnCaseForCaseDefinition(CaseDefinitionEntity caseDefinition) {
        CmmnModel model = this.getCmmnModelForCaseDefinition(caseDefinition);
        return model == null ? null : model.getCaseById(caseDefinition.getKey());
    }

    public void merge(CmmnParseResult cmmnParseResult) {
        if (this.deploymentEntity == null) {
            throw new FlowableException("Cannot merge from a parse result without a deployment entity");
        }
        if (cmmnParseResult.getDeployment() != null && !this.deploymentEntity.equals(cmmnParseResult.getDeployment())) {
            throw new FlowableException("Cannot merge parse results with different deployment entities");
        }
        for (CaseDefinitionEntity caseDefinitionEntity : cmmnParseResult.getAllCaseDefinitions()) {
            this.addCaseDefinition(caseDefinitionEntity, cmmnParseResult.getResourceForCaseDefinition(caseDefinitionEntity), cmmnParseResult.getCmmnModelForCaseDefinition(caseDefinitionEntity));
        }
    }
}

