/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.flowable.cmmn.converter.CmmnXMLException;
import org.flowable.cmmn.converter.CmmnXmlConverter;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.parser.CmmnActivityBehaviorFactory;
import org.flowable.cmmn.engine.impl.parser.CmmnParseResult;
import org.flowable.cmmn.engine.impl.parser.CmmnParser;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseDefinitionEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.CmmnResourceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.Case;
import org.flowable.cmmn.model.CaseTask;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.HumanTask;
import org.flowable.cmmn.model.ImplementationType;
import org.flowable.cmmn.model.Milestone;
import org.flowable.cmmn.model.PlanFragment;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.cmmn.model.ProcessTask;
import org.flowable.cmmn.model.ServiceTask;
import org.flowable.cmmn.model.Stage;
import org.flowable.cmmn.model.Task;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.io.InputStreamProvider;
import org.flowable.engine.common.impl.el.ExpressionManager;
import org.flowable.engine.common.impl.util.io.InputStreamSource;
import org.flowable.engine.common.impl.util.io.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmmnParserImpl
implements CmmnParser {
    private final Logger logger = LoggerFactory.getLogger(CmmnParserImpl.class);
    protected CmmnActivityBehaviorFactory activityBehaviorFactory;
    protected ExpressionManager expressionManager;

    @Override
    public CmmnParseResult parse(CmmnResourceEntity resourceEntity) {
        CmmnParseResult parseResult = new CmmnParseResult();
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(resourceEntity.getBytes());){
            Pair<CmmnModel, List<CaseDefinitionEntity>> pair = this.parse(resourceEntity, parseResult, (StreamSource)new InputStreamSource((InputStream)inputStream));
            for (CaseDefinitionEntity caseDefinitionEntity : (List)pair.getRight()) {
                parseResult.addCaseDefinition(caseDefinitionEntity, resourceEntity, (CmmnModel)pair.getLeft());
            }
        }
        catch (IOException e) {
            this.logger.error("Could not read bytes from CMMN resource", (Throwable)e);
        }
        return parseResult;
    }

    public Pair<CmmnModel, List<CaseDefinitionEntity>> parse(CmmnResourceEntity resourceEntity, CmmnParseResult parseResult, StreamSource cmmnSource) {
        try {
            boolean enableSafeBpmnXml = false;
            String encoding = null;
            CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration();
            if (cmmnEngineConfiguration != null) {
                enableSafeBpmnXml = cmmnEngineConfiguration.isEnableSafeCmmnXml();
                encoding = cmmnEngineConfiguration.getXmlEncoding();
            }
            CmmnModel cmmnModel = new CmmnXmlConverter().convertToCmmnModel((InputStreamProvider)cmmnSource, true, enableSafeBpmnXml, encoding);
            List<CaseDefinitionEntity> caseDefinitionEntities = this.processCmmnElements(resourceEntity, cmmnModel);
            return Pair.of((Object)cmmnModel, caseDefinitionEntities);
        }
        catch (Exception e) {
            if (e instanceof FlowableException) {
                throw (FlowableException)e;
            }
            if (e instanceof CmmnXMLException) {
                throw (CmmnXMLException)e;
            }
            throw new FlowableException("Error parsing XML", (Throwable)e);
        }
    }

    protected List<CaseDefinitionEntity> processCmmnElements(CmmnResourceEntity resourceEntity, CmmnModel cmmnModel) {
        ArrayList<CaseDefinitionEntity> caseDefinitionEntities = new ArrayList<CaseDefinitionEntity>();
        for (Case caze : cmmnModel.getCases()) {
            CaseDefinitionEntity caseDefinitionEntity = (CaseDefinitionEntity)CommandContextUtil.getCaseDefinitionEntityManager().create();
            caseDefinitionEntity.setKey(caze.getId());
            caseDefinitionEntity.setName(caze.getName());
            caseDefinitionEntity.setCategory(cmmnModel.getTargetNamespace());
            caseDefinitionEntity.setDeploymentId(resourceEntity.getDeploymentId());
            caseDefinitionEntities.add(caseDefinitionEntity);
            this.processPlanFragment((PlanFragment)caze.getPlanModel());
        }
        return caseDefinitionEntities;
    }

    protected void processPlanFragment(PlanFragment planFragment) {
        for (PlanItem planItem : planFragment.getPlanItems()) {
            PlanItemDefinition planItemDefinition = planItem.getPlanItemDefinition();
            if (planItemDefinition instanceof Stage) {
                Stage stage = (Stage)planItemDefinition;
                planItem.setBehavior((Object)this.activityBehaviorFactory.createStageActivityBehavoir(planItem, stage));
            } else if (planItemDefinition instanceof HumanTask) {
                HumanTask humanTask = (HumanTask)planItemDefinition;
                planItem.setBehavior((Object)this.activityBehaviorFactory.createHumanTaskActivityBehavior(planItem, humanTask));
            } else if (planItemDefinition instanceof CaseTask) {
                CaseTask caseTask = (CaseTask)planItemDefinition;
                planItem.setBehavior((Object)this.activityBehaviorFactory.createCaseTaskActivityBehavior(planItem, caseTask));
            } else if (planItemDefinition instanceof ProcessTask) {
                ProcessTask processTask = (ProcessTask)planItemDefinition;
                planItem.setBehavior((Object)this.activityBehaviorFactory.createProcessTaskActivityBehavior(planItem, processTask));
            } else if (planItemDefinition instanceof Milestone) {
                Milestone milestone = (Milestone)planItemDefinition;
                planItem.setBehavior((Object)this.activityBehaviorFactory.createMilestoneActivityBehavior(planItem, milestone));
            } else if (planItemDefinition instanceof Task) {
                Task task = (Task)planItemDefinition;
                if (task instanceof ServiceTask) {
                    ServiceTask serviceTask = (ServiceTask)task;
                    if (StringUtils.isNotEmpty((CharSequence)serviceTask.getImplementation())) {
                        if (ImplementationType.IMPLEMENTATION_TYPE_CLASS.equals(serviceTask.getImplementationType())) {
                            planItem.setBehavior((Object)this.activityBehaviorFactory.createCmmnClassDelegate(planItem, serviceTask));
                        } else if (ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION.equals(serviceTask.getImplementationType())) {
                            planItem.setBehavior((Object)this.activityBehaviorFactory.createPlanItemExpressionActivityBehavior(planItem, serviceTask));
                        } else if (ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equals(serviceTask.getImplementationType())) {
                            planItem.setBehavior((Object)this.activityBehaviorFactory.createPlanItemDelegateExpressionActivityBehavior(planItem, serviceTask));
                        }
                    }
                } else {
                    planItem.setBehavior((Object)this.activityBehaviorFactory.createTaskActivityBehavior(planItem, task));
                }
            }
            if (!(planItemDefinition instanceof PlanFragment)) continue;
            this.processPlanFragment((PlanFragment)planItemDefinition);
        }
    }

    public CmmnActivityBehaviorFactory getActivityBehaviorFactory() {
        return this.activityBehaviorFactory;
    }

    public void setActivityBehaviorFactory(CmmnActivityBehaviorFactory activityBehaviorFactory) {
        this.activityBehaviorFactory = activityBehaviorFactory;
    }

    public ExpressionManager getExpressionManager() {
        return this.expressionManager;
    }

    public void setExpressionManager(ExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
    }
}

