/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.persistence.entity;

import java.util.List;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.api.runtime.CaseInstanceQuery;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.persistence.entity.AbstractCmmnEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.MilestoneInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.MilestoneInstanceEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.SentryPartInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.data.CaseInstanceDataManager;
import org.flowable.cmmn.engine.impl.runtime.CaseInstanceQueryImpl;
import org.flowable.cmmn.engine.impl.task.TaskHelper;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.common.impl.persistence.entity.Entity;
import org.flowable.engine.common.impl.persistence.entity.data.DataManager;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.task.service.impl.persistence.entity.TaskEntityManager;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntityManager;

public class CaseInstanceEntityManagerImpl
extends AbstractCmmnEntityManager<CaseInstanceEntity>
implements CaseInstanceEntityManager {
    protected CaseInstanceDataManager caseInstanceDataManager;

    public CaseInstanceEntityManagerImpl(CmmnEngineConfiguration cmmnEngineConfiguration, CaseInstanceDataManager caseInstanceDataManager) {
        super(cmmnEngineConfiguration);
        this.caseInstanceDataManager = caseInstanceDataManager;
    }

    @Override
    protected DataManager<CaseInstanceEntity> getDataManager() {
        return this.caseInstanceDataManager;
    }

    @Override
    public CaseInstanceQuery createCaseInstanceQuery() {
        return new CaseInstanceQueryImpl(this.cmmnEngineConfiguration.getCommandExecutor());
    }

    @Override
    public List<CaseInstanceEntity> findCaseInstancesByCaseDefinitionId(String caseDefinitionId) {
        return this.caseInstanceDataManager.findCaseInstancesByCaseDefinitionId(caseDefinitionId);
    }

    @Override
    public List<CaseInstance> findByCriteria(CaseInstanceQuery query) {
        return this.caseInstanceDataManager.findByCriteria((CaseInstanceQueryImpl)query);
    }

    @Override
    public long countByCriteria(CaseInstanceQuery query) {
        return this.caseInstanceDataManager.countByCriteria((CaseInstanceQueryImpl)query);
    }

    @Override
    public void deleteByCaseDefinitionId(String caseDefinitionId) {
        this.caseInstanceDataManager.deleteByCaseDefinitionId(caseDefinitionId);
    }

    @Override
    public void deleteCaseInstanceAndRelatedData(String caseInstanceId, String deleteReason) {
        CaseInstanceEntity caseInstanceEntity = (CaseInstanceEntity)this.caseInstanceDataManager.findById(caseInstanceId);
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        VariableInstanceEntityManager variableInstanceEntityManager = CommandContextUtil.getVariableServiceConfiguration(commandContext).getVariableInstanceEntityManager();
        List variableInstanceEntities = variableInstanceEntityManager.findVariableInstanceByScopeIdAndScopeType(caseInstanceId, "cmmn");
        for (VariableInstanceEntity variableInstanceEntity : variableInstanceEntities) {
            variableInstanceEntityManager.delete((Entity)variableInstanceEntity);
        }
        TaskEntityManager taskEntityManager = CommandContextUtil.getTaskServiceConfiguration(commandContext).getTaskEntityManager();
        List taskEntities = taskEntityManager.findTasksByScopeIdAndScopeType(caseInstanceId, "cmmn");
        for (Object taskEntity : taskEntities) {
            TaskHelper.deleteTask((TaskEntity)taskEntity, deleteReason, false, true);
        }
        List sentryPartInstances = caseInstanceEntity.getSatisfiedSentryPartInstances();
        for (SentryPartInstanceEntity sentryPartInstanceEntity : sentryPartInstances) {
            CommandContextUtil.getSentryPartInstanceEntityManager(commandContext).delete(sentryPartInstanceEntity);
        }
        MilestoneInstanceEntityManager milestoneInstanceEntityManager = CommandContextUtil.getMilestoneInstanceEntityManager(commandContext);
        List<MilestoneInstanceEntity> milestoneInstanceEntities = milestoneInstanceEntityManager.findMilestoneInstancesByCaseInstanceId(caseInstanceId);
        if (milestoneInstanceEntities != null) {
            for (MilestoneInstanceEntity milestoneInstanceEntity : milestoneInstanceEntities) {
                milestoneInstanceEntityManager.delete(milestoneInstanceEntity);
            }
        }
        this.delete(caseInstanceEntity);
    }
}

