/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.persistence.entity;

import java.util.List;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.api.repository.CmmnDeployment;
import org.flowable.cmmn.api.repository.CmmnDeploymentQuery;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.persistence.entity.AbstractCmmnEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseDefinitionEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.CmmnDeploymentEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.CmmnDeploymentEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.CmmnResourceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.data.CmmnDeploymentDataManager;
import org.flowable.cmmn.engine.impl.repository.CmmnDeploymentQueryImpl;
import org.flowable.engine.common.impl.persistence.entity.data.DataManager;

public class CmmnDeploymentEntityManagerImpl
extends AbstractCmmnEntityManager<CmmnDeploymentEntity>
implements CmmnDeploymentEntityManager {
    protected CmmnDeploymentDataManager deploymentDataManager;

    public CmmnDeploymentEntityManagerImpl(CmmnEngineConfiguration cmmnEngineConfiguration, CmmnDeploymentDataManager deploymentDataManager) {
        super(cmmnEngineConfiguration);
        this.deploymentDataManager = deploymentDataManager;
    }

    @Override
    protected DataManager<CmmnDeploymentEntity> getDataManager() {
        return this.deploymentDataManager;
    }

    @Override
    public void insert(CmmnDeploymentEntity deployment) {
        super.insert(deployment, true);
        for (CmmnResourceEntity resource : deployment.getResources().values()) {
            resource.setDeploymentId(deployment.getId());
            this.getCmmnResourceEntityManager().insert(resource);
        }
    }

    @Override
    public void deleteDeploymentAndRelatedData(String deploymentId, boolean cascade) {
        CaseDefinitionEntityManager caseDefinitionEntityManager = this.getCaseDefinitionEntityManager();
        List caseDefinitions = caseDefinitionEntityManager.createCaseDefinitionQuery().deploymentId(deploymentId).list();
        for (CaseDefinition caseDefinition : caseDefinitions) {
            if (cascade) {
                caseDefinitionEntityManager.deleteCaseDefinitionAndRelatedData(caseDefinition.getId(), true);
                continue;
            }
            caseDefinitionEntityManager.delete(caseDefinition.getId());
        }
        this.getCmmnResourceEntityManager().deleteResourcesByDeploymentId(deploymentId);
        this.delete(this.findById(deploymentId));
    }

    @Override
    public CmmnDeploymentEntity findLatestDeploymentByName(String deploymentName) {
        return this.deploymentDataManager.findLatestDeploymentByName(deploymentName);
    }

    @Override
    public List<String> getDeploymentResourceNames(String deploymentId) {
        return this.deploymentDataManager.getDeploymentResourceNames(deploymentId);
    }

    @Override
    public CmmnDeploymentQuery createDeploymentQuery() {
        return new CmmnDeploymentQueryImpl(this.cmmnEngineConfiguration.getCommandExecutor());
    }

    @Override
    public List<CmmnDeployment> findDeploymentsByQueryCriteria(CmmnDeploymentQuery deploymentQuery) {
        return this.deploymentDataManager.findDeploymentsByQueryCriteria((CmmnDeploymentQueryImpl)deploymentQuery);
    }

    @Override
    public long findDeploymentCountByQueryCriteria(CmmnDeploymentQuery deploymentQuery) {
        return this.deploymentDataManager.findDeploymentCountByQueryCriteria((CmmnDeploymentQueryImpl)deploymentQuery);
    }

    public CmmnDeploymentDataManager getDeploymentDataManager() {
        return this.deploymentDataManager;
    }

    public void setDeploymentDataManager(CmmnDeploymentDataManager deploymentDataManager) {
        this.deploymentDataManager = deploymentDataManager;
    }
}

