/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.runtime;

import java.util.Map;
import org.flowable.cmmn.api.CmmnRuntimeService;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.api.runtime.CaseInstanceBuilder;
import org.flowable.cmmn.api.runtime.CaseInstanceQuery;
import org.flowable.cmmn.api.runtime.MilestoneInstanceQuery;
import org.flowable.cmmn.api.runtime.PlanItemInstanceQuery;
import org.flowable.cmmn.engine.impl.ServiceImpl;
import org.flowable.cmmn.engine.impl.cmd.EvaluateCriteriaCmd;
import org.flowable.cmmn.engine.impl.cmd.GetVariableCmd;
import org.flowable.cmmn.engine.impl.cmd.GetVariablesCmd;
import org.flowable.cmmn.engine.impl.cmd.RemoveVariableCmd;
import org.flowable.cmmn.engine.impl.cmd.SetVariablesCmd;
import org.flowable.cmmn.engine.impl.cmd.StartCaseInstanceCmd;
import org.flowable.cmmn.engine.impl.cmd.TerminateCaseInstanceCmd;
import org.flowable.cmmn.engine.impl.cmd.TriggerPlanItemInstanceCmd;
import org.flowable.cmmn.engine.impl.runtime.CaseInstanceBuilderImpl;
import org.flowable.engine.common.impl.interceptor.Command;

public class CmmnRuntimeServiceImpl
extends ServiceImpl
implements CmmnRuntimeService {
    public CaseInstanceBuilder createCaseInstanceBuilder() {
        return new CaseInstanceBuilderImpl(this);
    }

    public CaseInstance startCaseInstance(CaseInstanceBuilder caseInstanceBuilder) {
        return (CaseInstance)this.commandExecutor.execute((Command)new StartCaseInstanceCmd(caseInstanceBuilder));
    }

    public void triggerPlanItemInstance(String planItemInstanceId) {
        this.commandExecutor.execute((Command)new TriggerPlanItemInstanceCmd(planItemInstanceId));
    }

    public void terminateCaseInstance(String caseInstanceId) {
        this.commandExecutor.execute((Command)new TerminateCaseInstanceCmd(caseInstanceId));
    }

    public void evaluateCriteria(String caseInstanceId) {
        this.commandExecutor.execute((Command)new EvaluateCriteriaCmd(caseInstanceId));
    }

    public Map<String, Object> getVariables(String caseInstanceId) {
        return (Map)this.commandExecutor.execute((Command)new GetVariablesCmd(caseInstanceId));
    }

    public Object getVariable(String caseInstanceId, String variableName) {
        return this.commandExecutor.execute((Command)new GetVariableCmd(caseInstanceId, variableName));
    }

    public void setVariables(String caseInstanceId, Map<String, Object> variables) {
        this.commandExecutor.execute((Command)new SetVariablesCmd(caseInstanceId, variables));
    }

    public void removeVariable(String caseInstanceId, String variableName) {
        this.commandExecutor.execute((Command)new RemoveVariableCmd(caseInstanceId, variableName));
    }

    public CaseInstanceQuery createCaseInstanceQuery() {
        return this.cmmnEngineConfiguration.getCaseInstanceEntityManager().createCaseInstanceQuery();
    }

    public PlanItemInstanceQuery createPlanItemInstanceQuery() {
        return this.cmmnEngineConfiguration.getPlanItemInstanceEntityManager().createPlanItemInstanceQuery();
    }

    public MilestoneInstanceQuery createMilestoneInstanceQuery() {
        return this.cmmnEngineConfiguration.getMilestoneInstanceEntityManager().createMilestoneInstanceQuery();
    }
}

