/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.runtime;

import java.util.Date;
import java.util.List;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.api.runtime.PlanItemInstanceQuery;
import org.flowable.cmmn.engine.impl.runtime.PlanItemInstanceQueryProperty;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.impl.AbstractQuery;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.common.impl.interceptor.CommandExecutor;

public class PlanItemInstanceQueryImpl
extends AbstractQuery<PlanItemInstanceQuery, PlanItemInstance>
implements PlanItemInstanceQuery {
    protected String caseDefinitionId;
    protected String caseInstanceId;
    protected String stageInstanceId;
    protected String elementId;
    protected String name;
    protected String state;
    protected Date startedBefore;
    protected Date startedAfter;
    protected String startUserId;
    protected String referenceId;
    protected String referenceType;
    protected String tenantId;
    protected boolean withoutTenantId;

    public PlanItemInstanceQueryImpl() {
    }

    public PlanItemInstanceQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public PlanItemInstanceQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    public PlanItemInstanceQuery caseDefinitionId(String caseDefinitionId) {
        if (caseDefinitionId == null) {
            throw new FlowableIllegalArgumentException("Case definition id is null");
        }
        this.caseDefinitionId = caseDefinitionId;
        return this;
    }

    public PlanItemInstanceQuery caseInstanceId(String caseInstanceId) {
        if (caseInstanceId == null) {
            throw new FlowableIllegalArgumentException("Case instance id is null");
        }
        this.caseInstanceId = caseInstanceId;
        return this;
    }

    public PlanItemInstanceQuery stageInstanceId(String stageInstanceId) {
        if (stageInstanceId == null) {
            throw new FlowableIllegalArgumentException("Stage instance id is null");
        }
        this.stageInstanceId = stageInstanceId;
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceElementId(String elementId) {
        if (elementId == null) {
            throw new FlowableIllegalArgumentException("Element id is null");
        }
        this.elementId = elementId;
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceName(String name) {
        if (name == null) {
            throw new FlowableIllegalArgumentException("Name is null");
        }
        this.name = name;
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceState(String state) {
        if (state == null) {
            throw new FlowableIllegalArgumentException("State is null");
        }
        this.state = state;
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceStateActive() {
        return this.planItemInstanceState("active");
    }

    public PlanItemInstanceQuery planItemInstanceStateAvailable() {
        return this.planItemInstanceState("available");
    }

    public PlanItemInstanceQuery planItemInstanceStateCompleted() {
        return this.planItemInstanceState("completed");
    }

    public PlanItemInstanceQuery planItemInstanceStateTerminated() {
        return this.planItemInstanceState("terminated");
    }

    public PlanItemInstanceQuery planItemInstanceStartedBefore(Date startedBefore) {
        if (startedBefore == null) {
            throw new FlowableIllegalArgumentException("StartedBefore is null");
        }
        this.startedBefore = startedBefore;
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceStarterAfter(Date startedAfer) {
        if (startedAfer == null) {
            throw new FlowableIllegalArgumentException("StartedAfter is null");
        }
        this.startedAfter = startedAfer;
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceStartUserId(String startUserId) {
        if (startUserId == null) {
            throw new FlowableIllegalArgumentException("Start user id is null");
        }
        this.startUserId = startUserId;
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceReferenceId(String referenceId) {
        this.referenceId = referenceId;
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceReferenceType(String referenceType) {
        this.referenceType = referenceType;
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceTenantId(String tenantId) {
        if (tenantId == null) {
            throw new FlowableIllegalArgumentException("Tenant id is null");
        }
        this.tenantId = tenantId;
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceWithoutTenantId() {
        this.withoutTenantId = true;
        return this;
    }

    public long executeCount(CommandContext commandContext) {
        return CommandContextUtil.getPlanItemInstanceEntityManager(commandContext).countByCriteria(this);
    }

    public List<PlanItemInstance> executeList(CommandContext commandContext) {
        return CommandContextUtil.getPlanItemInstanceEntityManager(commandContext).findByCriteria(this);
    }

    public PlanItemInstanceQuery orderByStartTime() {
        this.orderProperty = PlanItemInstanceQueryProperty.START_TIME;
        return this;
    }

    public PlanItemInstanceQuery orderByName() {
        this.orderProperty = PlanItemInstanceQueryProperty.NAME;
        return this;
    }

    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public String getStageInstanceId() {
        return this.stageInstanceId;
    }

    public String getElementId() {
        return this.elementId;
    }

    public String getName() {
        return this.name;
    }

    public String getState() {
        return this.state;
    }

    public Date getStartedBefore() {
        return this.startedBefore;
    }

    public Date getStartedAfter() {
        return this.startedAfter;
    }

    public String getStartUserId() {
        return this.startUserId;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public String getReferenceType() {
        return this.referenceType;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public boolean isWithoutTenantId() {
        return this.withoutTenantId;
    }
}

