/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.agenda.operation;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.repository.CaseDefinitionUtil;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.cmmn.model.Stage;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.delegate.Expression;
import org.flowable.engine.common.api.variable.VariableContainer;
import org.flowable.engine.common.impl.interceptor.CommandContext;

public abstract class CmmnOperation
implements Runnable {
    protected CommandContext commandContext;

    public CmmnOperation() {
    }

    public CmmnOperation(CommandContext commandContext) {
        this.commandContext = commandContext;
    }

    protected Stage getStage(PlanItemInstanceEntity planItemInstanceEntity) {
        if (planItemInstanceEntity.getPlanItem() != null && planItemInstanceEntity.getPlanItem().getPlanItemDefinition() != null) {
            PlanItemDefinition planItemDefinition = planItemInstanceEntity.getPlanItem().getPlanItemDefinition();
            if (planItemDefinition instanceof Stage) {
                return (Stage)planItemDefinition;
            }
            return planItemDefinition.getParentStage();
        }
        return this.getStage(planItemInstanceEntity.getCaseDefinitionId(), planItemInstanceEntity.getElementId());
    }

    protected Stage getStage(String caseDefinitionId, String stageId) {
        return CaseDefinitionUtil.getCase(caseDefinitionId).findStage(stageId);
    }

    protected boolean isStage(PlanItemInstanceEntity planItemInstanceEntity) {
        return planItemInstanceEntity.getPlanItem() != null && planItemInstanceEntity.getPlanItem().getPlanItemDefinition() != null && planItemInstanceEntity.getPlanItem().getPlanItemDefinition() instanceof Stage;
    }

    protected Stage getPlanModel(CaseInstanceEntity caseInstanceEntity) {
        return CaseDefinitionUtil.getCase(caseInstanceEntity.getCaseDefinitionId()).getPlanModel();
    }

    protected List<PlanItemInstanceEntity> createPlanItemInstances(CommandContext commandContext, List<PlanItem> planItems, String caseDefinitionId, String caseInstanceId, String stagePlanItemInstanceId, String tenantId) {
        ArrayList<PlanItemInstanceEntity> planItemInstances = new ArrayList<PlanItemInstanceEntity>();
        for (PlanItem planItem : planItems) {
            planItemInstances.add(CommandContextUtil.getPlanItemInstanceEntityManager(commandContext).createChildPlanItemInstance(planItem, caseDefinitionId, caseInstanceId, stagePlanItemInstanceId, tenantId, true));
        }
        for (PlanItemInstanceEntity planItemInstance : planItemInstances) {
            CommandContextUtil.getAgenda(commandContext).planCreatePlanItemInstanceOperation(planItemInstance);
        }
        return planItemInstances;
    }

    protected PlanItemInstanceEntity copyAndInsertPlanItemInstance(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntityToCopy) {
        return this.copyAndInsertPlanItemInstance(commandContext, planItemInstanceEntityToCopy, true);
    }

    protected PlanItemInstanceEntity copyAndInsertPlanItemInstance(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntityToCopy, boolean addToParent) {
        PlanItemInstanceEntity planItemInstanceEntity = CommandContextUtil.getPlanItemInstanceEntityManager(commandContext).createChildPlanItemInstance(planItemInstanceEntityToCopy.getPlanItem(), planItemInstanceEntityToCopy.getCaseDefinitionId(), planItemInstanceEntityToCopy.getCaseInstanceId(), planItemInstanceEntityToCopy.getStageInstanceId(), planItemInstanceEntityToCopy.getTenantId(), addToParent);
        return planItemInstanceEntity;
    }

    protected int getRepetitionCounter(PlanItemInstanceEntity repeatingPlanItemInstanceEntity) {
        Integer counter = (Integer)repeatingPlanItemInstanceEntity.getVariableLocal(this.getCounterVariable(repeatingPlanItemInstanceEntity));
        if (counter == null) {
            return 0;
        }
        return counter;
    }

    protected void setRepetitionCounter(PlanItemInstanceEntity repeatingPlanItemInstanceEntity, int counterValue) {
        repeatingPlanItemInstanceEntity.setVariableLocal(this.getCounterVariable(repeatingPlanItemInstanceEntity), counterValue);
    }

    protected String getCounterVariable(PlanItemInstanceEntity repeatingPlanItemInstanceEntity) {
        String repetitionCounterVariableName = repeatingPlanItemInstanceEntity.getPlanItem().getItemControl().getRepetitionRule().getRepetitionCounterVariableName();
        return repetitionCounterVariableName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean evaluateRepetitionRule(PlanItemInstanceEntity planItemInstanceEntity) {
        if (planItemInstanceEntity.getPlanItem() == null) return false;
        PlanItem planItem = planItemInstanceEntity.getPlanItem();
        if (planItem.getItemControl() == null) return false;
        if (planItem.getItemControl().getRepetitionRule() == null) return false;
        String repetitionCondition = planItem.getItemControl().getRepetitionRule().getCondition();
        boolean isRepeating = false;
        if (!StringUtils.isNotEmpty((CharSequence)repetitionCondition)) return true;
        Expression repetitionExpression = CommandContextUtil.getExpressionManager(this.commandContext).createExpression(repetitionCondition);
        Object evaluationResult = repetitionExpression.getValue((VariableContainer)planItemInstanceEntity);
        if (evaluationResult instanceof Boolean) {
            return (Boolean)evaluationResult;
        }
        if (!(evaluationResult instanceof String)) throw new FlowableException("Repetition condition " + repetitionCondition + " did not evaluate to a boolean value");
        return ((String)evaluationResult).toLowerCase().equals("true");
    }
}

