/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.engine.impl.cmd.NeedsActiveTaskCmd;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.content.api.ContentItem;
import org.flowable.content.api.ContentService;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.form.api.FormRepositoryService;
import org.flowable.form.api.FormService;
import org.flowable.form.model.FormField;
import org.flowable.form.model.FormModel;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public class CompleteTaskWithFormCmd
extends NeedsActiveTaskCmd<Void> {
    private static final long serialVersionUID = 1L;
    protected String formDefinitionId;
    protected String outcome;
    protected Map<String, Object> variables;
    protected Map<String, Object> transientVariables;
    protected boolean localScope;

    public CompleteTaskWithFormCmd(String taskId, String formDefinitionId, String outcome, Map<String, Object> variables) {
        super(taskId);
        this.formDefinitionId = formDefinitionId;
        this.outcome = outcome;
        this.variables = variables;
    }

    public CompleteTaskWithFormCmd(String taskId, String formDefinitionId, String outcome, Map<String, Object> variables, boolean localScope) {
        this(taskId, formDefinitionId, outcome, variables);
        this.localScope = localScope;
    }

    public CompleteTaskWithFormCmd(String taskId, String formDefinitionId, String outcome, Map<String, Object> variables, Map<String, Object> transientVariables) {
        this(taskId, formDefinitionId, outcome, variables);
        this.transientVariables = transientVariables;
    }

    @Override
    protected Void execute(CommandContext commandContext, TaskEntity task) {
        FormService formService = CommandContextUtil.getFormService();
        if (formService == null) {
            throw new FlowableIllegalArgumentException("Form engine is not initialized");
        }
        FormRepositoryService formRepositoryService = CommandContextUtil.getFormRepositoryService();
        FormModel formModel = formRepositoryService.getFormModelById(this.formDefinitionId);
        if (formModel != null) {
            Map formVariables = formService.getVariablesFromFormSubmission(formModel, this.variables, this.outcome);
            if (task.getProcessInstanceId() != null) {
                formService.saveFormInstance(formVariables, formModel, task.getId(), task.getProcessInstanceId(), task.getProcessDefinitionId());
            } else if (task.getScopeId() != null) {
                formService.saveFormInstanceWithScopeId(formVariables, formModel, task.getId(), task.getScopeId(), task.getScopeType(), task.getScopeDefinitionId());
            }
            this.processUploadFieldsIfNeeded(formModel, task, commandContext);
            this.completeTask(commandContext, task, formVariables);
        } else {
            this.completeTask(commandContext, task, this.variables);
        }
        return null;
    }

    protected void completeTask(CommandContext commandContext, TaskEntity task, Map<String, Object> taskVariables) {
        String planItemInstanceId = task.getSubScopeId();
        PlanItemInstanceEntity planItemInstanceEntity = (PlanItemInstanceEntity)CommandContextUtil.getPlanItemInstanceEntityManager(commandContext).findById(planItemInstanceId);
        if (planItemInstanceEntity == null) {
            throw new FlowableException("Could not find plan item instance for task " + this.taskId);
        }
        if (taskVariables != null) {
            if (this.localScope) {
                task.setVariablesLocal(taskVariables);
            } else {
                task.setVariables(taskVariables);
            }
        }
        if (this.transientVariables != null) {
            if (this.localScope) {
                task.setTransientVariablesLocal(this.transientVariables);
            } else {
                task.setTransientVariables(this.transientVariables);
            }
        }
        CommandContextUtil.getAgenda(commandContext).planTriggerPlanItemInstanceOperation(planItemInstanceEntity);
    }

    protected void processUploadFieldsIfNeeded(FormModel formModel, TaskEntity task, CommandContext commandContext) {
        ContentService contentService = CommandContextUtil.getContentService();
        if (contentService == null) {
            return;
        }
        if (formModel != null && formModel.getFields() != null) {
            for (FormField formField : formModel.getFields()) {
                String variableValue;
                String variableName;
                if (!"upload".equals(formField.getType()) || !this.variables.containsKey(variableName = formField.getId()) || !StringUtils.isNotEmpty((CharSequence)(variableValue = (String)this.variables.get(variableName)))) continue;
                String[] contentItemIds = StringUtils.split((String)variableValue, (String)",");
                HashSet contentItemIdSet = new HashSet();
                Collections.addAll(contentItemIdSet, contentItemIds);
                List contentItems = contentService.createContentItemQuery().ids(contentItemIdSet).list();
                for (ContentItem contentItem : contentItems) {
                    contentItem.setTaskId(task.getId());
                    contentItem.setProcessInstanceId(task.getProcessInstanceId());
                    contentItem.setField(formField.getId());
                    contentService.saveContentItem(contentItem);
                }
            }
        }
    }

    @Override
    protected String getSuspendedTaskException() {
        return "Cannot complete a suspended task";
    }
}

