/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;

public class RemoveVariableCmd
implements Command<Void> {
    protected String caseInstanceId;
    protected String variableName;

    public RemoveVariableCmd(String caseInstanceId, String variableName) {
        this.caseInstanceId = caseInstanceId;
        this.variableName = variableName;
    }

    public Void execute(CommandContext commandContext) {
        if (this.caseInstanceId == null) {
            throw new FlowableIllegalArgumentException("caseInstanceId is null");
        }
        if (this.variableName == null) {
            throw new FlowableIllegalArgumentException("variableName is null");
        }
        CaseInstanceEntity caseInstanceEntity = (CaseInstanceEntity)CommandContextUtil.getCaseInstanceEntityManager(commandContext).findById(this.caseInstanceId);
        if (caseInstanceEntity == null) {
            throw new FlowableObjectNotFoundException("No case instance found for id " + this.caseInstanceId, CaseInstanceEntity.class);
        }
        caseInstanceEntity.removeVariable(this.variableName);
        return null;
    }
}

