/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.history;

import java.util.Date;
import java.util.List;
import java.util.Set;
import org.flowable.cmmn.api.history.HistoricCaseInstance;
import org.flowable.cmmn.api.history.HistoricCaseInstanceQuery;
import org.flowable.cmmn.engine.impl.history.HistoricCaseInstanceQueryProperty;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.common.impl.interceptor.CommandExecutor;
import org.flowable.variable.service.impl.AbstractVariableQueryImpl;

public class HistoricCaseInstanceQueryImpl
extends AbstractVariableQueryImpl<HistoricCaseInstanceQuery, HistoricCaseInstance>
implements HistoricCaseInstanceQuery {
    private static final long serialVersionUID = 1L;
    protected String caseDefinitionId;
    protected String caseDefinitionKey;
    protected Set<String> caseDefinitionKeys;
    protected Set<String> caseDefinitionIds;
    protected String caseDefinitionName;
    protected String caseDefinitionCategory;
    protected Integer caseDefinitionVersion;
    protected String caseInstanceId;
    protected Set<String> caseInstanceIds;
    protected String businessKey;
    protected String caseInstanceParentId;
    protected String deploymentId;
    protected List<String> deploymentIds;
    protected boolean finished;
    protected boolean unfinished;
    protected Date startedBefore;
    protected Date startedAfter;
    protected Date finishedBefore;
    protected Date finishedAfter;
    protected String startedBy;
    protected String callbackId;
    protected String callbackType;
    protected String tenantId;
    protected boolean withoutTenantId;

    public HistoricCaseInstanceQueryImpl() {
    }

    public HistoricCaseInstanceQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public HistoricCaseInstanceQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    public HistoricCaseInstanceQueryImpl caseDefinitionId(String caseDefinitionId) {
        if (caseDefinitionId == null) {
            throw new FlowableIllegalArgumentException("Case definition id is null");
        }
        this.caseDefinitionId = caseDefinitionId;
        return this;
    }

    public HistoricCaseInstanceQueryImpl caseDefinitionKey(String caseDefinitionKey) {
        if (caseDefinitionKey == null) {
            throw new FlowableIllegalArgumentException("Case definition key is null");
        }
        this.caseDefinitionKey = caseDefinitionKey;
        return this;
    }

    public HistoricCaseInstanceQueryImpl caseDefinitionCategory(String caseDefinitionCategory) {
        if (caseDefinitionCategory == null) {
            throw new FlowableIllegalArgumentException("Case definition category is null");
        }
        this.caseDefinitionCategory = caseDefinitionCategory;
        return this;
    }

    public HistoricCaseInstanceQueryImpl caseDefinitionName(String caseDefinitionName) {
        if (caseDefinitionName == null) {
            throw new FlowableIllegalArgumentException("Case definition name is null");
        }
        this.caseDefinitionName = caseDefinitionName;
        return this;
    }

    public HistoricCaseInstanceQueryImpl caseDefinitionVersion(Integer caseDefinitionVersion) {
        if (caseDefinitionVersion == null) {
            throw new FlowableIllegalArgumentException("Case definition version is null");
        }
        this.caseDefinitionVersion = caseDefinitionVersion;
        return this;
    }

    public HistoricCaseInstanceQueryImpl caseInstanceId(String caseInstanceId) {
        if (caseInstanceId == null) {
            throw new FlowableIllegalArgumentException("Case instance id is null");
        }
        this.caseInstanceId = caseInstanceId;
        return this;
    }

    public HistoricCaseInstanceQueryImpl caseInstanceIds(Set<String> caseInstanceIds) {
        if (caseInstanceIds == null) {
            throw new FlowableIllegalArgumentException("Case instance ids is null");
        }
        this.caseInstanceIds = caseInstanceIds;
        return this;
    }

    public HistoricCaseInstanceQueryImpl caseInstanceBusinessKey(String businessKey) {
        if (businessKey == null) {
            throw new FlowableIllegalArgumentException("Business key is null");
        }
        this.businessKey = businessKey;
        return this;
    }

    public HistoricCaseInstanceQueryImpl caseDefinitionKeys(Set<String> caseDefinitionKeys) {
        if (caseDefinitionKeys == null) {
            throw new FlowableIllegalArgumentException("Case definition keys is null");
        }
        this.caseDefinitionKeys = caseDefinitionKeys;
        return this;
    }

    public HistoricCaseInstanceQueryImpl caseInstanceParentId(String parentId) {
        if (parentId == null) {
            throw new FlowableIllegalArgumentException("Parent id is null");
        }
        this.caseInstanceParentId = parentId;
        return this;
    }

    public HistoricCaseInstanceQueryImpl deploymentId(String deploymentId) {
        if (deploymentId == null) {
            throw new FlowableIllegalArgumentException("Deployment id is null");
        }
        this.deploymentId = deploymentId;
        return this;
    }

    public HistoricCaseInstanceQueryImpl deploymentIds(List<String> deploymentIds) {
        if (deploymentIds == null) {
            throw new FlowableIllegalArgumentException("Deployment ids is null");
        }
        this.deploymentIds = deploymentIds;
        return this;
    }

    public HistoricCaseInstanceQueryImpl finished() {
        this.finished = true;
        return this;
    }

    public HistoricCaseInstanceQueryImpl unfinished() {
        this.unfinished = true;
        return this;
    }

    public HistoricCaseInstanceQueryImpl finishedBefore(Date beforeTime) {
        if (beforeTime == null) {
            throw new FlowableIllegalArgumentException("before time is null");
        }
        this.finishedBefore = beforeTime;
        return this;
    }

    public HistoricCaseInstanceQueryImpl finishedAfter(Date afterTime) {
        if (afterTime == null) {
            throw new FlowableIllegalArgumentException("after time is null");
        }
        this.finishedAfter = afterTime;
        return this;
    }

    public HistoricCaseInstanceQueryImpl startedBefore(Date beforeTime) {
        if (beforeTime == null) {
            throw new FlowableIllegalArgumentException("before time is null");
        }
        this.startedBefore = beforeTime;
        return this;
    }

    public HistoricCaseInstanceQueryImpl startedAfter(Date afterTime) {
        if (afterTime == null) {
            throw new FlowableIllegalArgumentException("after time is null");
        }
        this.startedAfter = afterTime;
        return this;
    }

    public HistoricCaseInstanceQueryImpl startedBy(String userId) {
        if (userId == null) {
            throw new FlowableIllegalArgumentException("user id is null");
        }
        this.startedBy = userId;
        return this;
    }

    public HistoricCaseInstanceQuery caseInstanceCallbackId(String callbackId) {
        this.callbackId = callbackId;
        return this;
    }

    public HistoricCaseInstanceQuery caseInstanceCallbackType(String callbackType) {
        this.callbackType = callbackType;
        return this;
    }

    public HistoricCaseInstanceQueryImpl caseInstanceTenantId(String tenantId) {
        if (tenantId == null) {
            throw new FlowableIllegalArgumentException("caseInstance tenant id is null");
        }
        this.tenantId = tenantId;
        return this;
    }

    public HistoricCaseInstanceQueryImpl caseInstanceWithoutTenantId() {
        this.withoutTenantId = true;
        return this;
    }

    public HistoricCaseInstanceQueryImpl orderByCaseInstanceId() {
        this.orderProperty = HistoricCaseInstanceQueryProperty.CASE_INSTANCE_ID;
        return this;
    }

    public HistoricCaseInstanceQueryImpl orderByCaseDefinitionId() {
        this.orderProperty = HistoricCaseInstanceQueryProperty.CASE_DEFINITION_ID;
        return this;
    }

    public HistoricCaseInstanceQueryImpl orderByCaseDefinitionKey() {
        this.orderProperty = HistoricCaseInstanceQueryProperty.CASE_DEFINITION_KEY;
        return this;
    }

    public HistoricCaseInstanceQueryImpl orderByStartTime() {
        this.orderProperty = HistoricCaseInstanceQueryProperty.CASE_START_TIME;
        return this;
    }

    public HistoricCaseInstanceQueryImpl orderByEndTime() {
        this.orderProperty = HistoricCaseInstanceQueryProperty.CASE_END_TIME;
        return this;
    }

    public HistoricCaseInstanceQueryImpl orderByTenantId() {
        this.orderProperty = HistoricCaseInstanceQueryProperty.TENANT_ID;
        return this;
    }

    public long executeCount(CommandContext commandContext) {
        this.ensureVariablesInitialized();
        return CommandContextUtil.getHistoricCaseInstanceEntityManager(commandContext).countByCriteria(this);
    }

    public List<HistoricCaseInstance> executeList(CommandContext commandContext) {
        this.ensureVariablesInitialized();
        return CommandContextUtil.getHistoricCaseInstanceEntityManager(commandContext).findByCriteria(this);
    }

    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    public String getCaseDefinitionKey() {
        return this.caseDefinitionKey;
    }

    public Set<String> getCaseDefinitionKeys() {
        return this.caseDefinitionKeys;
    }

    public Set<String> getCaseDefinitionIds() {
        return this.caseDefinitionIds;
    }

    public String getCaseDefinitionName() {
        return this.caseDefinitionName;
    }

    public String getCaseDefinitionCategory() {
        return this.caseDefinitionCategory;
    }

    public Integer getCaseDefinitionVersion() {
        return this.caseDefinitionVersion;
    }

    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public String getCaseInstanceParentId() {
        return this.caseInstanceParentId;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isUnfinished() {
        return this.unfinished;
    }

    public Date getStartedBefore() {
        return this.startedBefore;
    }

    public Date getStartedAfter() {
        return this.startedAfter;
    }

    public Date getFinishedBefore() {
        return this.finishedBefore;
    }

    public Date getFinishedAfter() {
        return this.finishedAfter;
    }

    public String getStartedBy() {
        return this.startedBy;
    }

    public String getCallbackId() {
        return this.callbackId;
    }

    public String getCallbackType() {
        return this.callbackType;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public boolean isWithoutTenantId() {
        return this.withoutTenantId;
    }
}

