/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.repository;

import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.engine.impl.deployer.CmmnDeploymentManager;
import org.flowable.cmmn.engine.impl.persistence.entity.CmmnDeploymentEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.deploy.CaseDefinitionCacheEntry;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.Case;
import org.flowable.cmmn.model.CmmnModel;

public class CaseDefinitionUtil {
    public static String getDefinitionDeploymentId(String caseDefinitionId) {
        CmmnDeploymentManager deploymentManager = CommandContextUtil.getCmmnEngineConfiguration().getDeploymentManager();
        CaseDefinitionCacheEntry cacheEntry = (CaseDefinitionCacheEntry)deploymentManager.getCaseDefinitionCache().get(caseDefinitionId);
        CaseDefinition caseDefinition = CaseDefinitionUtil.getCaseDefinition(caseDefinitionId, deploymentManager, cacheEntry);
        CmmnDeploymentEntity caseDeployment = (CmmnDeploymentEntity)deploymentManager.getDeploymentEntityManager().findById(caseDefinition.getDeploymentId());
        if (StringUtils.isEmpty((CharSequence)caseDeployment.getParentDeploymentId())) {
            return caseDefinition.getDeploymentId();
        }
        return caseDeployment.getParentDeploymentId();
    }

    protected static CaseDefinition getCaseDefinition(String caseDefinitionId, CmmnDeploymentManager deploymentManager, CaseDefinitionCacheEntry cacheEntry) {
        if (cacheEntry != null) {
            return cacheEntry.getCaseDefinition();
        }
        return deploymentManager.findDeployedCaseDefinitionById(caseDefinitionId);
    }

    public static CmmnModel getCmmnModel(String caseDefinitionId) {
        CmmnDeploymentManager deploymentManager = CommandContextUtil.getCmmnEngineConfiguration().getDeploymentManager();
        CaseDefinitionCacheEntry cacheEntry = (CaseDefinitionCacheEntry)deploymentManager.getCaseDefinitionCache().get(caseDefinitionId);
        if (cacheEntry != null) {
            return cacheEntry.getCmmnModel();
        }
        deploymentManager.findDeployedCaseDefinitionById(caseDefinitionId);
        return ((CaseDefinitionCacheEntry)deploymentManager.getCaseDefinitionCache().get(caseDefinitionId)).getCmmnModel();
    }

    public static Case getCase(String caseDefinitionId) {
        return CaseDefinitionUtil.getCmmnModel(caseDefinitionId).getPrimaryCase();
    }
}

