/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.runtime;

import java.util.Map;
import org.flowable.cmmn.api.CmmnRuntimeService;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.api.runtime.CaseInstanceBuilder;
import org.flowable.cmmn.api.runtime.CaseInstanceQuery;
import org.flowable.cmmn.api.runtime.MilestoneInstanceQuery;
import org.flowable.cmmn.api.runtime.PlanItemInstanceQuery;
import org.flowable.cmmn.engine.impl.ServiceImpl;
import org.flowable.cmmn.engine.impl.cmd.EvaluateCriteriaCmd;
import org.flowable.cmmn.engine.impl.cmd.GetLocalVariableCmd;
import org.flowable.cmmn.engine.impl.cmd.GetLocalVariablesCmd;
import org.flowable.cmmn.engine.impl.cmd.GetVariableCmd;
import org.flowable.cmmn.engine.impl.cmd.GetVariablesCmd;
import org.flowable.cmmn.engine.impl.cmd.RemoveLocalVariableCmd;
import org.flowable.cmmn.engine.impl.cmd.RemoveVariableCmd;
import org.flowable.cmmn.engine.impl.cmd.SetLocalVariablesCmd;
import org.flowable.cmmn.engine.impl.cmd.SetVariablesCmd;
import org.flowable.cmmn.engine.impl.cmd.StartCaseInstanceCmd;
import org.flowable.cmmn.engine.impl.cmd.TerminateCaseInstanceCmd;
import org.flowable.cmmn.engine.impl.cmd.TriggerPlanItemInstanceCmd;
import org.flowable.cmmn.engine.impl.runtime.CaseInstanceBuilderImpl;
import org.flowable.engine.common.impl.interceptor.Command;

public class CmmnRuntimeServiceImpl
extends ServiceImpl
implements CmmnRuntimeService {
    public CaseInstanceBuilder createCaseInstanceBuilder() {
        return new CaseInstanceBuilderImpl(this);
    }

    public CaseInstance startCaseInstance(CaseInstanceBuilder caseInstanceBuilder) {
        return (CaseInstance)this.commandExecutor.execute((Command)new StartCaseInstanceCmd(caseInstanceBuilder));
    }

    public void triggerPlanItemInstance(String planItemInstanceId) {
        this.commandExecutor.execute((Command)new TriggerPlanItemInstanceCmd(planItemInstanceId));
    }

    public void terminateCaseInstance(String caseInstanceId) {
        this.commandExecutor.execute((Command)new TerminateCaseInstanceCmd(caseInstanceId));
    }

    public void evaluateCriteria(String caseInstanceId) {
        this.commandExecutor.execute((Command)new EvaluateCriteriaCmd(caseInstanceId));
    }

    public Map<String, Object> getVariables(String caseInstanceId) {
        return (Map)this.commandExecutor.execute((Command)new GetVariablesCmd(caseInstanceId));
    }

    public Map<String, Object> getLocalVariables(String planItemInstanceId) {
        return (Map)this.commandExecutor.execute((Command)new GetLocalVariablesCmd(planItemInstanceId));
    }

    public Object getVariable(String caseInstanceId, String variableName) {
        return this.commandExecutor.execute((Command)new GetVariableCmd(caseInstanceId, variableName));
    }

    public Object getLocalVariable(String planItemInstanceId, String variableName) {
        return this.commandExecutor.execute((Command)new GetLocalVariableCmd(planItemInstanceId, variableName));
    }

    public void setVariables(String caseInstanceId, Map<String, Object> variables) {
        this.commandExecutor.execute((Command)new SetVariablesCmd(caseInstanceId, variables));
    }

    public void setLocalVariables(String planItemInstanceId, Map<String, Object> variables) {
        this.commandExecutor.execute((Command)new SetLocalVariablesCmd(planItemInstanceId, variables));
    }

    public void removeVariable(String caseInstanceId, String variableName) {
        this.commandExecutor.execute((Command)new RemoveVariableCmd(caseInstanceId, variableName));
    }

    public void removeLocalVariable(String planItemInstanceId, String variableName) {
        this.commandExecutor.execute((Command)new RemoveLocalVariableCmd(planItemInstanceId, variableName));
    }

    public CaseInstanceQuery createCaseInstanceQuery() {
        return this.cmmnEngineConfiguration.getCaseInstanceEntityManager().createCaseInstanceQuery();
    }

    public PlanItemInstanceQuery createPlanItemInstanceQuery() {
        return this.cmmnEngineConfiguration.getPlanItemInstanceEntityManager().createPlanItemInstanceQuery();
    }

    public MilestoneInstanceQuery createMilestoneInstanceQuery() {
        return this.cmmnEngineConfiguration.getMilestoneInstanceEntityManager().createMilestoneInstanceQuery();
    }
}

