/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.engine.impl.util.IdentityLinkUtil;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;

public class DeleteIdentityLinkForCaseInstanceCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String caseInstanceId;
    protected String userId;
    protected String groupId;
    protected String type;

    public DeleteIdentityLinkForCaseInstanceCmd(String caseInstanceId, String userId, String groupId, String type) {
        this.validateParams(userId, groupId, caseInstanceId, type);
        this.caseInstanceId = caseInstanceId;
        this.userId = userId;
        this.groupId = groupId;
        this.type = type;
    }

    protected void validateParams(String userId, String groupId, String caseInstanceId, String type) {
        if (caseInstanceId == null) {
            throw new FlowableIllegalArgumentException("caseInstanceId is null");
        }
        if (type == null) {
            throw new FlowableIllegalArgumentException("type is required when deleting a process identity link");
        }
        if (userId == null && groupId == null) {
            throw new FlowableIllegalArgumentException("userId and groupId cannot both be null");
        }
    }

    public Void execute(CommandContext commandContext) {
        CaseInstance caseInstance = (CaseInstance)CommandContextUtil.getCaseInstanceEntityManager(commandContext).findById(this.caseInstanceId);
        if (caseInstance == null) {
            throw new FlowableObjectNotFoundException("Cannot find case instance with id " + this.caseInstanceId, CaseInstanceEntity.class);
        }
        IdentityLinkUtil.deleteCaseInstanceIdentityLinks(caseInstance, this.userId, this.groupId, this.type);
        return null;
    }
}

