/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;

public class HasCaseInstanceVariableCmd
implements Command<Boolean>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String caseInstanceId;
    protected String variableName;
    protected boolean isLocal;

    public HasCaseInstanceVariableCmd(String caseInstanceId, String variableName, boolean isLocal) {
        this.caseInstanceId = caseInstanceId;
        this.variableName = variableName;
        this.isLocal = isLocal;
    }

    public Boolean execute(CommandContext commandContext) {
        if (this.caseInstanceId == null) {
            throw new FlowableIllegalArgumentException("caseInstanceId is null");
        }
        if (this.variableName == null) {
            throw new FlowableIllegalArgumentException("variableName is null");
        }
        CaseInstanceEntity caseInstance = (CaseInstanceEntity)CommandContextUtil.getCaseInstanceEntityManager(commandContext).findById(this.caseInstanceId);
        if (caseInstance == null) {
            throw new FlowableObjectNotFoundException("case instance " + this.caseInstanceId + " doesn't exist", CaseInstance.class);
        }
        boolean hasVariable = false;
        hasVariable = this.isLocal ? caseInstance.hasVariableLocal(this.variableName) : caseInstance.hasVariable(this.variableName);
        return hasVariable;
    }
}

