/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.deployer;

import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.deployer.ResourceNameUtil;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseDefinitionEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.CmmnResourceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.engine.common.api.repository.EngineDeployment;
import org.flowable.engine.common.impl.util.IoUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseDefinitionDiagramHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(CaseDefinitionDiagramHelper.class);

    public CmmnResourceEntity createDiagramForCaseDefinition(CaseDefinitionEntity caseDefinition, CmmnModel cmmnModel) {
        if (StringUtils.isEmpty((CharSequence)caseDefinition.getKey()) || StringUtils.isEmpty((CharSequence)caseDefinition.getResourceName())) {
            throw new IllegalStateException("Provided case definition must have both key and resource name set.");
        }
        CmmnResourceEntity resource = this.createResourceEntity();
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration();
        try {
            byte[] diagramBytes = IoUtil.readInputStream((InputStream)cmmnEngineConfiguration.getCaseDiagramGenerator().generateDiagram(cmmnModel, "png", cmmnEngineConfiguration.getActivityFontName(), cmmnEngineConfiguration.getLabelFontName(), cmmnEngineConfiguration.getAnnotationFontName(), cmmnEngineConfiguration.getClassLoader()), null);
            String diagramResourceName = ResourceNameUtil.getCaseDiagramResourceName(caseDefinition.getResourceName(), caseDefinition.getKey(), "png");
            resource.setName(diagramResourceName);
            resource.setBytes(diagramBytes);
            resource.setDeploymentId(caseDefinition.getDeploymentId());
            resource.setGenerated(true);
        }
        catch (Throwable t) {
            LOGGER.warn("Error while generating case diagram, image will not be stored in repository", t);
            resource = null;
        }
        return resource;
    }

    protected CmmnResourceEntity createResourceEntity() {
        return (CmmnResourceEntity)CommandContextUtil.getCmmnEngineConfiguration().getCmmnResourceEntityManager().create();
    }

    public boolean shouldCreateDiagram(CaseDefinitionEntity caseDefinition, EngineDeployment deployment) {
        if (deployment.isNew() && caseDefinition.hasGraphicalNotation() && CommandContextUtil.getCmmnEngineConfiguration().isCreateDiagramOnDeploy()) {
            return ResourceNameUtil.getCaseDiagramResourceNameFromDeployment(caseDefinition, deployment.getResources()) == null;
        }
        return false;
    }
}

