/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.flowable.cmmn.api.CmmnTaskService;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.CmmnTaskBuilderImpl;
import org.flowable.cmmn.engine.impl.cmd.AddIdentityLinkCmd;
import org.flowable.cmmn.engine.impl.cmd.ClaimTaskCmd;
import org.flowable.cmmn.engine.impl.cmd.CompleteTaskCmd;
import org.flowable.cmmn.engine.impl.cmd.CompleteTaskWithFormCmd;
import org.flowable.cmmn.engine.impl.cmd.DelegateTaskCmd;
import org.flowable.cmmn.engine.impl.cmd.DeleteIdentityLinkCmd;
import org.flowable.cmmn.engine.impl.cmd.DeleteTaskCmd;
import org.flowable.cmmn.engine.impl.cmd.GetIdentityLinksForTaskCmd;
import org.flowable.cmmn.engine.impl.cmd.GetSubTasksCmd;
import org.flowable.cmmn.engine.impl.cmd.GetTaskFormModelCmd;
import org.flowable.cmmn.engine.impl.cmd.GetTaskVariableCmd;
import org.flowable.cmmn.engine.impl.cmd.GetTaskVariableInstanceCmd;
import org.flowable.cmmn.engine.impl.cmd.GetTaskVariableInstancesCmd;
import org.flowable.cmmn.engine.impl.cmd.GetTaskVariablesCmd;
import org.flowable.cmmn.engine.impl.cmd.GetTasksLocalVariablesCmd;
import org.flowable.cmmn.engine.impl.cmd.HasTaskVariableCmd;
import org.flowable.cmmn.engine.impl.cmd.NewTaskCmd;
import org.flowable.cmmn.engine.impl.cmd.RemoveTaskVariablesCmd;
import org.flowable.cmmn.engine.impl.cmd.ResolveTaskCmd;
import org.flowable.cmmn.engine.impl.cmd.SaveTaskCmd;
import org.flowable.cmmn.engine.impl.cmd.SetTaskDueDateCmd;
import org.flowable.cmmn.engine.impl.cmd.SetTaskPriorityCmd;
import org.flowable.cmmn.engine.impl.cmd.SetTaskVariablesCmd;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.service.CommonEngineServiceImpl;
import org.flowable.form.api.FormInfo;
import org.flowable.identitylink.api.IdentityLink;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskBuilder;
import org.flowable.task.api.TaskQuery;
import org.flowable.task.service.impl.TaskQueryImpl;
import org.flowable.variable.api.persistence.entity.VariableInstance;

public class CmmnTaskServiceImpl
extends CommonEngineServiceImpl<CmmnEngineConfiguration>
implements CmmnTaskService {
    public CmmnTaskServiceImpl(CmmnEngineConfiguration engineConfiguration) {
        super((AbstractEngineConfiguration)engineConfiguration);
    }

    public Task newTask() {
        return this.newTask(null);
    }

    public Task newTask(String taskId) {
        return (Task)this.commandExecutor.execute((Command)new NewTaskCmd(taskId));
    }

    public void saveTask(Task task) {
        this.commandExecutor.execute((Command)new SaveTaskCmd(task));
    }

    public void claim(String taskId, String userId) {
        this.commandExecutor.execute((Command)new ClaimTaskCmd(taskId, userId));
    }

    public void unclaim(String taskId) {
        this.commandExecutor.execute((Command)new ClaimTaskCmd(taskId, null));
    }

    public void complete(String taskId) {
        this.commandExecutor.execute((Command)new CompleteTaskCmd(taskId, null, null));
    }

    public void complete(String taskId, Map<String, Object> variables) {
        this.commandExecutor.execute((Command)new CompleteTaskCmd(taskId, variables, null));
    }

    public void complete(String taskId, Map<String, Object> variables, Map<String, Object> transientVariables) {
        this.commandExecutor.execute((Command)new CompleteTaskCmd(taskId, variables, transientVariables));
    }

    public void completeTaskWithForm(String taskId, String formDefinitionId, String outcome, Map<String, Object> variables) {
        this.commandExecutor.execute((Command)new CompleteTaskWithFormCmd(taskId, formDefinitionId, outcome, variables));
    }

    public void completeTaskWithForm(String taskId, String formDefinitionId, String outcome, Map<String, Object> variables, Map<String, Object> transientVariables) {
        this.commandExecutor.execute((Command)new CompleteTaskWithFormCmd(taskId, formDefinitionId, outcome, variables, transientVariables));
    }

    public void completeTaskWithForm(String taskId, String formDefinitionId, String outcome, Map<String, Object> variables, boolean localScope) {
        this.commandExecutor.execute((Command)new CompleteTaskWithFormCmd(taskId, formDefinitionId, outcome, variables, localScope));
    }

    public void delegateTask(String taskId, String userId) {
        this.commandExecutor.execute((Command)new DelegateTaskCmd(taskId, userId));
    }

    public void resolveTask(String taskId) {
        this.commandExecutor.execute((Command)new ResolveTaskCmd(taskId, null));
    }

    public void resolveTask(String taskId, Map<String, Object> variables) {
        this.commandExecutor.execute((Command)new ResolveTaskCmd(taskId, variables));
    }

    public void resolveTask(String taskId, Map<String, Object> variables, Map<String, Object> transientVariables) {
        this.commandExecutor.execute((Command)new ResolveTaskCmd(taskId, variables, transientVariables));
    }

    public void deleteTask(String taskId) {
        this.commandExecutor.execute((Command)new DeleteTaskCmd(taskId, null, false));
    }

    public void deleteTasks(Collection<String> taskIds) {
        this.commandExecutor.execute((Command)new DeleteTaskCmd(taskIds, null, false));
    }

    public void deleteTask(String taskId, boolean cascade) {
        this.commandExecutor.execute((Command)new DeleteTaskCmd(taskId, null, cascade));
    }

    public void deleteTasks(Collection<String> taskIds, boolean cascade) {
        this.commandExecutor.execute((Command)new DeleteTaskCmd(taskIds, null, cascade));
    }

    public void deleteTask(String taskId, String deleteReason) {
        this.commandExecutor.execute((Command)new DeleteTaskCmd(taskId, deleteReason, false));
    }

    public void deleteTasks(Collection<String> taskIds, String deleteReason) {
        this.commandExecutor.execute((Command)new DeleteTaskCmd(taskIds, deleteReason, false));
    }

    public FormInfo getTaskFormModel(String taskId) {
        return (FormInfo)this.commandExecutor.execute((Command)new GetTaskFormModelCmd(taskId));
    }

    public void setPriority(String taskId, int priority) {
        this.commandExecutor.execute((Command)new SetTaskPriorityCmd(taskId, priority));
    }

    public void setDueDate(String taskId, Date dueDate) {
        this.commandExecutor.execute((Command)new SetTaskDueDateCmd(taskId, dueDate));
    }

    public TaskQuery createTaskQuery() {
        return new TaskQueryImpl(this.commandExecutor);
    }

    public List<Task> getSubTasks(String parentTaskId) {
        return (List)this.commandExecutor.execute((Command)new GetSubTasksCmd(parentTaskId));
    }

    public Map<String, Object> getVariables(String taskId) {
        return (Map)this.commandExecutor.execute((Command)new GetTaskVariablesCmd(taskId, null, false));
    }

    public Map<String, Object> getVariablesLocal(String taskId) {
        return (Map)this.commandExecutor.execute((Command)new GetTaskVariablesCmd(taskId, null, true));
    }

    public Map<String, Object> getVariables(String taskId, Collection<String> variableNames) {
        return (Map)this.commandExecutor.execute((Command)new GetTaskVariablesCmd(taskId, variableNames, false));
    }

    public Map<String, Object> getVariablesLocal(String taskId, Collection<String> variableNames) {
        return (Map)this.commandExecutor.execute((Command)new GetTaskVariablesCmd(taskId, variableNames, true));
    }

    public Object getVariable(String taskId, String variableName) {
        return this.commandExecutor.execute((Command)new GetTaskVariableCmd(taskId, variableName, false));
    }

    public <T> T getVariable(String taskId, String variableName, Class<T> variableClass) {
        return variableClass.cast(this.getVariable(taskId, variableName));
    }

    public boolean hasVariable(String taskId, String variableName) {
        return (Boolean)this.commandExecutor.execute((Command)new HasTaskVariableCmd(taskId, variableName, false));
    }

    public Object getVariableLocal(String taskId, String variableName) {
        return this.commandExecutor.execute((Command)new GetTaskVariableCmd(taskId, variableName, true));
    }

    public <T> T getVariableLocal(String taskId, String variableName, Class<T> variableClass) {
        return variableClass.cast(this.getVariableLocal(taskId, variableName));
    }

    public List<VariableInstance> getVariableInstancesLocalByTaskIds(Set<String> taskIds) {
        return (List)this.commandExecutor.execute((Command)new GetTasksLocalVariablesCmd(taskIds));
    }

    public boolean hasVariableLocal(String taskId, String variableName) {
        return (Boolean)this.commandExecutor.execute((Command)new HasTaskVariableCmd(taskId, variableName, true));
    }

    public void setVariable(String taskId, String variableName, Object value) {
        if (variableName == null) {
            throw new FlowableIllegalArgumentException("variableName is null");
        }
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put(variableName, value);
        this.commandExecutor.execute((Command)new SetTaskVariablesCmd(taskId, variables, false));
    }

    public void setVariableLocal(String taskId, String variableName, Object value) {
        if (variableName == null) {
            throw new FlowableIllegalArgumentException("variableName is null");
        }
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put(variableName, value);
        this.commandExecutor.execute((Command)new SetTaskVariablesCmd(taskId, variables, true));
    }

    public void setVariables(String taskId, Map<String, ? extends Object> variables) {
        this.commandExecutor.execute((Command)new SetTaskVariablesCmd(taskId, variables, false));
    }

    public void setVariablesLocal(String taskId, Map<String, ? extends Object> variables) {
        this.commandExecutor.execute((Command)new SetTaskVariablesCmd(taskId, variables, true));
    }

    public void removeVariable(String taskId, String variableName) {
        ArrayList<String> variableNames = new ArrayList<String>();
        variableNames.add(variableName);
        this.commandExecutor.execute((Command)new RemoveTaskVariablesCmd(taskId, variableNames, false));
    }

    public void removeVariableLocal(String taskId, String variableName) {
        ArrayList<String> variableNames = new ArrayList<String>(1);
        variableNames.add(variableName);
        this.commandExecutor.execute((Command)new RemoveTaskVariablesCmd(taskId, variableNames, true));
    }

    public void removeVariables(String taskId, Collection<String> variableNames) {
        this.commandExecutor.execute((Command)new RemoveTaskVariablesCmd(taskId, variableNames, false));
    }

    public void removeVariablesLocal(String taskId, Collection<String> variableNames) {
        this.commandExecutor.execute((Command)new RemoveTaskVariablesCmd(taskId, variableNames, true));
    }

    public VariableInstance getVariableInstance(String taskId, String variableName) {
        return (VariableInstance)this.commandExecutor.execute((Command)new GetTaskVariableInstanceCmd(taskId, variableName, false));
    }

    public VariableInstance getVariableInstanceLocal(String taskId, String variableName) {
        return (VariableInstance)this.commandExecutor.execute((Command)new GetTaskVariableInstanceCmd(taskId, variableName, true));
    }

    public Map<String, VariableInstance> getVariableInstances(String taskId) {
        return (Map)this.commandExecutor.execute((Command)new GetTaskVariableInstancesCmd(taskId, null, false));
    }

    public Map<String, VariableInstance> getVariableInstances(String taskId, Collection<String> variableNames) {
        return (Map)this.commandExecutor.execute((Command)new GetTaskVariableInstancesCmd(taskId, variableNames, false));
    }

    public Map<String, VariableInstance> getVariableInstancesLocal(String taskId) {
        return (Map)this.commandExecutor.execute((Command)new GetTaskVariableInstancesCmd(taskId, null, true));
    }

    public Map<String, VariableInstance> getVariableInstancesLocal(String taskId, Collection<String> variableNames) {
        return (Map)this.commandExecutor.execute((Command)new GetTaskVariableInstancesCmd(taskId, variableNames, true));
    }

    public void setAssignee(String taskId, String userId) {
        this.commandExecutor.execute((Command)new AddIdentityLinkCmd(taskId, userId, AddIdentityLinkCmd.IDENTITY_USER, "assignee"));
    }

    public void setOwner(String taskId, String userId) {
        this.commandExecutor.execute((Command)new AddIdentityLinkCmd(taskId, userId, AddIdentityLinkCmd.IDENTITY_USER, "owner"));
    }

    public void addUserIdentityLink(String taskId, String userId, String identityLinkType) {
        this.commandExecutor.execute((Command)new AddIdentityLinkCmd(taskId, userId, AddIdentityLinkCmd.IDENTITY_USER, identityLinkType));
    }

    public void addGroupIdentityLink(String taskId, String groupId, String identityLinkType) {
        this.commandExecutor.execute((Command)new AddIdentityLinkCmd(taskId, groupId, AddIdentityLinkCmd.IDENTITY_GROUP, identityLinkType));
    }

    public void deleteGroupIdentityLink(String taskId, String groupId, String identityLinkType) {
        this.commandExecutor.execute((Command)new DeleteIdentityLinkCmd(taskId, null, groupId, identityLinkType));
    }

    public void deleteUserIdentityLink(String taskId, String userId, String identityLinkType) {
        this.commandExecutor.execute((Command)new DeleteIdentityLinkCmd(taskId, userId, null, identityLinkType));
    }

    public List<IdentityLink> getIdentityLinksForTask(String taskId) {
        return (List)this.commandExecutor.execute((Command)new GetIdentityLinksForTaskCmd(taskId));
    }

    public TaskBuilder createTaskBuilder() {
        return new CmmnTaskBuilderImpl(this.commandExecutor);
    }
}

