/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.agenda.operation;

import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.engine.impl.agenda.operation.AbstractPlanItemInstanceOperation;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.ManualActivationRule;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.PlanItemControl;
import org.flowable.cmmn.model.Task;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class ActivatePlanItemInstanceOperation
extends AbstractPlanItemInstanceOperation {
    public ActivatePlanItemInstanceOperation(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        super(commandContext, planItemInstanceEntity);
    }

    @Override
    public void run() {
        if (this.isAsync() && !"async-active".equals(this.planItemInstanceEntity.getState())) {
            CommandContextUtil.getAgenda(this.commandContext).planActivateAsyncPlanItemInstanceOperation(this.planItemInstanceEntity);
        } else {
            this.deleteSentryPartInstances();
            boolean isManuallyActivated = this.evaluateManualActivationRule();
            if (isManuallyActivated) {
                CommandContextUtil.getAgenda(this.commandContext).planEnablePlanItemInstanceOperation(this.planItemInstanceEntity);
            } else {
                CommandContextUtil.getAgenda(this.commandContext).planStartPlanItemInstanceOperation(this.planItemInstanceEntity);
            }
        }
    }

    protected boolean evaluateManualActivationRule() {
        PlanItemControl planItemControl = this.planItemInstanceEntity.getPlanItem().getItemControl();
        if (planItemControl != null && planItemControl.getManualActivationRule() != null) {
            ManualActivationRule manualActivationRule = planItemControl.getManualActivationRule();
            if (StringUtils.isNotEmpty((CharSequence)manualActivationRule.getCondition())) {
                return this.evaluateBooleanExpression(this.commandContext, this.planItemInstanceEntity, manualActivationRule.getCondition());
            }
            return true;
        }
        return false;
    }

    protected boolean isAsync() {
        Task task;
        return this.planItemInstanceEntity.getPlanItem().getPlanItemDefinition() instanceof Task && (task = (Task)this.planItemInstanceEntity.getPlanItem().getPlanItemDefinition()).isAsync();
    }

    public String toString() {
        PlanItem planItem = this.planItemInstanceEntity.getPlanItem();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[Activate PlanItem] ");
        if (planItem.getName() != null) {
            stringBuilder.append(planItem.getName());
            stringBuilder.append(" (");
            stringBuilder.append(planItem.getId());
            stringBuilder.append(")");
        } else {
            stringBuilder.append(planItem.getId());
        }
        return stringBuilder.toString();
    }
}

