/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.history.async.json.transformer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Date;
import org.flowable.cmmn.engine.impl.history.async.json.transformer.AbstractTaskHistoryJsonTransformer;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.service.impl.history.async.util.AsyncHistoryJsonUtil;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;
import org.flowable.task.service.HistoricTaskService;
import org.flowable.task.service.impl.persistence.entity.HistoricTaskInstanceEntity;

public class TaskEndedHistoryJsonTransformer
extends AbstractTaskHistoryJsonTransformer {
    public String getType() {
        return "cmmn-task-removed";
    }

    public boolean isApplicable(ObjectNode historicalData, CommandContext commandContext) {
        return this.getHistoricTaskEntity(historicalData, commandContext) != null;
    }

    public void transformJson(HistoryJobEntity job, ObjectNode historicalData, CommandContext commandContext) {
        HistoricTaskInstanceEntity historicTaskInstance = this.getHistoricTaskEntity(historicalData, commandContext);
        if (historicTaskInstance != null) {
            Date lastUpdateTime = AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"__timeStamp");
            if (historicTaskInstance.getLastUpdateTime() == null || !historicTaskInstance.getLastUpdateTime().after(lastUpdateTime)) {
                historicTaskInstance.setLastUpdateTime(lastUpdateTime);
                this.copyCommonHistoricTaskInstanceFields(historicalData, historicTaskInstance);
            }
            this.setEndProperties(historicalData, historicTaskInstance);
        } else {
            HistoricTaskService historicTaskService = CommandContextUtil.getHistoricTaskService(commandContext);
            HistoricTaskInstanceEntity historicTaskInstanceEntity = historicTaskService.createHistoricTask();
            this.copyCommonHistoricTaskInstanceFields(historicalData, historicTaskInstanceEntity);
            this.setEndProperties(historicalData, historicTaskInstance);
            historicTaskService.insertHistoricTask(historicTaskInstanceEntity, false);
        }
    }

    protected void setEndProperties(ObjectNode historicalData, HistoricTaskInstanceEntity historicTaskInstance) {
        Date endTime = AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"endTime");
        historicTaskInstance.setEndTime(endTime);
        historicTaskInstance.setDeleteReason(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"deleteReason"));
        Date startTime = historicTaskInstance.getStartTime();
        if (startTime != null && endTime != null) {
            historicTaskInstance.setDurationInMillis(Long.valueOf(endTime.getTime() - startTime.getTime()));
        }
    }
}

