/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.history.async;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.history.CmmnHistoryManager;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.HistoricCaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.HistoricCaseInstanceEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.MilestoneInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.repository.CaseDefinitionUtil;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.history.HistoryLevel;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.history.async.AsyncHistorySession;
import org.flowable.job.service.impl.history.async.util.AsyncHistoryJsonUtil;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;

public class AsyncCmmnHistoryManager
implements CmmnHistoryManager {
    protected CmmnEngineConfiguration cmmnEngineConfiguration;

    public AsyncCmmnHistoryManager(CmmnEngineConfiguration cmmnEngineConfiguration) {
        this.cmmnEngineConfiguration = cmmnEngineConfiguration;
    }

    protected AsyncHistorySession getAsyncHistorySession() {
        return (AsyncHistorySession)Context.getCommandContext().getSession(AsyncHistorySession.class);
    }

    @Override
    public void recordCaseInstanceStart(CaseInstanceEntity caseInstanceEntity) {
        if (this.cmmnEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.ACTIVITY)) {
            HashMap<String, String> data = new HashMap<String, String>();
            this.addCommonCaseInstanceFields(caseInstanceEntity, data);
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "cmmn-case-instance-start", data, caseInstanceEntity.getTenantId());
        }
    }

    @Override
    public void recordCaseInstanceEnd(CaseInstanceEntity caseInstanceEntity, String state) {
        if (this.cmmnEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.ACTIVITY)) {
            HashMap<String, String> data = new HashMap<String, String>();
            this.addCommonCaseInstanceFields(caseInstanceEntity, data);
            Date endTime = this.cmmnEngineConfiguration.getClock().getCurrentTime();
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"endTime", (Date)endTime);
            if (caseInstanceEntity.getStartTime() != null) {
                AsyncHistoryJsonUtil.putIfNotNull(data, (String)"duration", (Long)(endTime.getTime() - caseInstanceEntity.getStartTime().getTime()));
            }
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "cmmn-case-instance-end", data, caseInstanceEntity.getTenantId());
        }
    }

    protected void addCommonCaseInstanceFields(CaseInstanceEntity caseInstanceEntity, Map<String, String> data) {
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"id", (String)caseInstanceEntity.getId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"revision", (int)caseInstanceEntity.getRevision());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"name", (String)caseInstanceEntity.getName());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"state", (String)caseInstanceEntity.getState());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"businessKey", (String)caseInstanceEntity.getBusinessKey());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"parentId", (String)caseInstanceEntity.getParentId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"caseDefinitionId", (String)caseInstanceEntity.getCaseDefinitionId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"startUserId", (String)caseInstanceEntity.getStartUserId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"startTime", (Date)caseInstanceEntity.getStartTime());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"tenantId", (String)caseInstanceEntity.getTenantId());
        if (caseInstanceEntity.getCaseDefinitionId() != null) {
            CaseDefinition caseDefinition = CaseDefinitionUtil.getCaseDefinition(caseInstanceEntity.getCaseDefinitionId());
            this.addCaseDefinitionFields(data, caseDefinition);
        }
    }

    @Override
    public void recordHistoricCaseInstanceDeleted(String caseInstanceId) {
        if (this.cmmnEngineConfiguration.getHistoryLevel() != HistoryLevel.NONE) {
            HashMap<String, String> data = new HashMap<String, String>();
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"id", (String)caseInstanceId);
            HistoricCaseInstanceEntityManager historicCaseInstanceEntityManager = this.cmmnEngineConfiguration.getHistoricCaseInstanceEntityManager();
            HistoricCaseInstanceEntity historicCaseInstanceEntity = (HistoricCaseInstanceEntity)historicCaseInstanceEntityManager.findById(caseInstanceId);
            if (historicCaseInstanceEntity != null) {
                AsyncHistoryJsonUtil.putIfNotNull(data, (String)"id", (String)historicCaseInstanceEntity.getId());
                AsyncHistoryJsonUtil.putIfNotNull(data, (String)"revision", (int)historicCaseInstanceEntity.getRevision());
                AsyncHistoryJsonUtil.putIfNotNull(data, (String)"name", (String)historicCaseInstanceEntity.getName());
                AsyncHistoryJsonUtil.putIfNotNull(data, (String)"state", (String)historicCaseInstanceEntity.getState());
                AsyncHistoryJsonUtil.putIfNotNull(data, (String)"businessKey", (String)historicCaseInstanceEntity.getBusinessKey());
                AsyncHistoryJsonUtil.putIfNotNull(data, (String)"parentId", (String)historicCaseInstanceEntity.getParentId());
                AsyncHistoryJsonUtil.putIfNotNull(data, (String)"caseDefinitionId", (String)historicCaseInstanceEntity.getCaseDefinitionId());
                AsyncHistoryJsonUtil.putIfNotNull(data, (String)"startUserId", (String)historicCaseInstanceEntity.getStartUserId());
                AsyncHistoryJsonUtil.putIfNotNull(data, (String)"startTime", (Date)historicCaseInstanceEntity.getStartTime());
                AsyncHistoryJsonUtil.putIfNotNull(data, (String)"tenantId", (String)historicCaseInstanceEntity.getTenantId());
                if (historicCaseInstanceEntity.getCaseDefinitionId() != null) {
                    this.addCaseDefinitionFields(data, CaseDefinitionUtil.getCaseDefinition(historicCaseInstanceEntity.getCaseDefinitionId()));
                }
            }
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "cmmn-historic-case-instance-deleted", data, historicCaseInstanceEntity != null ? historicCaseInstanceEntity.getTenantId() : null);
        }
    }

    protected void addCaseDefinitionFields(Map<String, String> data, CaseDefinition caseDefinition) {
        if (caseDefinition != null) {
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"caseDefinitionId", (String)caseDefinition.getId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"caseDefinitionCategory", (String)caseDefinition.getCategory());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"caseDefinitionDeploymentId", (String)caseDefinition.getDeploymentId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"caseDefinitionDescription", (String)caseDefinition.getDescription());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"caseDefinitionKey", (String)caseDefinition.getKey());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"caseDefinitionName", (String)caseDefinition.getName());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"caseDefinitionVersion", (int)caseDefinition.getVersion());
        }
    }

    @Override
    public void recordMilestoneReached(MilestoneInstanceEntity milestoneInstanceEntity) {
        if (this.cmmnEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.ACTIVITY)) {
            HashMap<String, String> data = new HashMap<String, String>();
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"id", (String)milestoneInstanceEntity.getId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"revision", (int)milestoneInstanceEntity.getRevision());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"name", (String)milestoneInstanceEntity.getName());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"caseInstanceId", (String)milestoneInstanceEntity.getCaseInstanceId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"caseDefinitionId", (String)milestoneInstanceEntity.getCaseDefinitionId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"elementId", (String)milestoneInstanceEntity.getElementId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"createTime", (Date)milestoneInstanceEntity.getTimeStamp());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"tenantId", (String)milestoneInstanceEntity.getTenantId());
            if (milestoneInstanceEntity.getCaseDefinitionId() != null) {
                this.addCaseDefinitionFields(data, CaseDefinitionUtil.getCaseDefinition(milestoneInstanceEntity.getCaseDefinitionId()));
            }
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "cmmn-milestone-reached", data, milestoneInstanceEntity.getTenantId());
        }
    }

    @Override
    public void recordIdentityLinkCreated(IdentityLinkEntity identityLink) {
        if (this.cmmnEngineConfiguration.getHistoryLevel() != HistoryLevel.NONE && (identityLink.getScopeId() != null || identityLink.getTaskId() != null)) {
            HashMap<String, String> data = new HashMap<String, String>();
            this.addCommonIdentityLinkFields(identityLink, data);
            CaseDefinition caseDefinition = this.getCaseDefinition(identityLink);
            if (caseDefinition != null) {
                this.addCaseDefinitionFields(data, caseDefinition);
            }
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "cmmn-identity-link-created", data, caseDefinition != null ? caseDefinition.getTenantId() : null);
        }
    }

    @Override
    public void recordIdentityLinkDeleted(IdentityLinkEntity identityLink) {
        if (this.cmmnEngineConfiguration.getHistoryLevel() != HistoryLevel.NONE) {
            HashMap<String, String> data = new HashMap<String, String>();
            this.addCommonIdentityLinkFields(identityLink, data);
            CaseDefinition caseDefinition = this.getCaseDefinition(identityLink);
            if (caseDefinition != null) {
                this.addCaseDefinitionFields(data, caseDefinition);
            }
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "cmmn-identity-link-deleted", data, caseDefinition != null ? caseDefinition.getTenantId() : null);
        }
    }

    protected void addCommonIdentityLinkFields(IdentityLinkEntity identityLink, Map<String, String> data) {
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"id", (String)identityLink.getId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"groupId", (String)identityLink.getGroupId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"scopeDefinitionId", (String)identityLink.getScopeDefinitionId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"scopeId", (String)identityLink.getScopeId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"caseInstanceId", (String)identityLink.getScopeId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"scopeType", (String)identityLink.getScopeType());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"caseDefinitionId", (String)identityLink.getScopeType());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"taskId", (String)identityLink.getTaskId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"identityLinkType", (String)identityLink.getType());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"userId", (String)identityLink.getUserId());
    }

    protected CaseDefinition getCaseDefinition(IdentityLinkEntity identityLink) {
        TaskEntity task;
        String caseDefinitionId = null;
        if ("cmmn".equals(identityLink.getScopeType()) && identityLink.getScopeId() != null) {
            CaseInstance caseInstance = (CaseInstance)CommandContextUtil.getCaseInstanceEntityManager().findById(identityLink.getScopeId());
            if (caseInstance != null) {
                caseDefinitionId = caseInstance.getCaseDefinitionId();
            }
        } else if (identityLink.getTaskId() != null && (task = CommandContextUtil.getTaskService().getTask(identityLink.getTaskId())) != null && "cmmn".equals(task.getScopeType())) {
            caseDefinitionId = task.getScopeDefinitionId();
        }
        return CaseDefinitionUtil.getCaseDefinition(caseDefinitionId);
    }

    @Override
    public void recordVariableCreate(VariableInstanceEntity variable) {
        if (this.cmmnEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.AUDIT)) {
            HashMap<String, String> data = new HashMap<String, String>();
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"createTime", (Date)this.cmmnEngineConfiguration.getClock().getCurrentTime());
            this.addCommonVariableFields(variable, data);
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "cmmn-variable-created", data);
        }
    }

    @Override
    public void recordVariableUpdate(VariableInstanceEntity variable) {
        if (this.cmmnEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.AUDIT)) {
            HashMap<String, String> data = new HashMap<String, String>();
            this.addCommonVariableFields(variable, data);
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "cmmn-variable-updated", data);
        }
    }

    @Override
    public void recordVariableRemoved(VariableInstanceEntity variable) {
        if (this.cmmnEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.AUDIT)) {
            HashMap<String, String> data = new HashMap<String, String>();
            this.addCommonVariableFields(variable, data);
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "cmmn-variable-removed", data);
        }
    }

    protected void addCommonVariableFields(VariableInstanceEntity variable, Map<String, String> data) {
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"id", (String)variable.getId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"taskId", (String)variable.getTaskId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"revision", (int)variable.getRevision());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"name", (String)variable.getName());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"caseInstanceId", (String)variable.getScopeId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"scopeId", (String)variable.getScopeId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"caseInstanceId", (String)variable.getScopeId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"subScopeId", (String)variable.getSubScopeId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"planItemInstanceId", (String)variable.getSubScopeId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"scopeType", (String)variable.getScopeType());
        Date time = this.cmmnEngineConfiguration.getClock().getCurrentTime();
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"lastUpdateTime", (Date)time);
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"variableType", (String)variable.getType().getTypeName());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"variableTextValue", (String)variable.getTextValue());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"variableTextValue2", (String)variable.getTextValue2());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"variableDoubleValue", (Double)variable.getDoubleValue());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"variableLongValue", (Long)variable.getLongValue());
        if (variable.getByteArrayRef() != null) {
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"variableBytesValue", (String)AsyncHistoryJsonUtil.convertToBase64((VariableInstanceEntity)variable));
        }
        if (variable.getScopeId() != null && "cmmn".equals(variable.getScopeType())) {
            CaseInstance caseInstance = (CaseInstance)this.cmmnEngineConfiguration.getCaseInstanceEntityManager().findById(variable.getScopeId());
            this.addCaseDefinitionFields(data, CaseDefinitionUtil.getCaseDefinition(caseInstance.getCaseDefinitionId()));
        }
    }

    @Override
    public void recordTaskCreated(TaskEntity task) {
        if (this.cmmnEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.AUDIT)) {
            HashMap<String, String> data = new HashMap<String, String>();
            this.addCommonTaskFields(task, data);
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "cmmn-task-created", data, task.getTenantId());
        }
    }

    @Override
    public void recordTaskInfoChange(TaskEntity task) {
        if (this.cmmnEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.AUDIT)) {
            HashMap<String, String> data = new HashMap<String, String>();
            this.addCommonTaskFields(task, data);
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "cmmn-task-updated", data, task.getTenantId());
        }
    }

    @Override
    public void recordTaskEnd(TaskEntity task, String deleteReason) {
        if (this.cmmnEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.AUDIT)) {
            HashMap<String, String> data = new HashMap<String, String>();
            this.addCommonTaskFields(task, data);
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"deleteReason", (String)deleteReason);
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"endTime", (Date)this.cmmnEngineConfiguration.getClock().getCurrentTime());
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "cmmn-task-removed", data, task.getTenantId());
        }
    }

    protected void addCommonTaskFields(TaskEntity task, Map<String, String> data) {
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"id", (String)task.getId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"revision", (int)task.getRevision());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"name", (String)task.getName());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"parentTaskId", (String)task.getParentTaskId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"description", (String)task.getDescription());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"owner", (String)task.getOwner());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"assignee", (String)task.getAssignee());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"startTime", (Date)this.cmmnEngineConfiguration.getClock().getCurrentTime());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"taskDefinitionKey", (String)task.getTaskDefinitionKey());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"taskDefinitionId", (String)task.getTaskDefinitionId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"priority", (int)task.getPriority());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"dueDate", (Date)task.getDueDate());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"category", (String)task.getCategory());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"formKey", (String)task.getFormKey());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"tenantId", (String)task.getTenantId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"claimTime", (Date)task.getClaimTime());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"caseInstanceId", (String)task.getScopeId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"scopeId", (String)task.getScopeId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"caseInstanceId", (String)task.getScopeId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"subScopeId", (String)task.getSubScopeId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"planItemInstanceId", (String)task.getSubScopeId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"scopeType", (String)task.getScopeType());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"scopeDefinitionId", (String)task.getScopeDefinitionId());
        if (task.getScopeDefinitionId() != null) {
            this.addCaseDefinitionFields(data, CaseDefinitionUtil.getCaseDefinition(task.getScopeDefinitionId()));
        }
    }

    @Override
    public void recordPlanItemInstanceCreated(PlanItemInstanceEntity planItemInstanceEntity) {
        if (this.cmmnEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.ACTIVITY)) {
            HashMap<String, String> data = new HashMap<String, String>();
            this.addCommonPlanItemInstanceFields(planItemInstanceEntity, data);
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "cmmn-plan-item-instance-created", data, planItemInstanceEntity.getTenantId());
        }
    }

    @Override
    public void recordPlanItemInstanceAvailable(PlanItemInstanceEntity planItemInstanceEntity) {
        this.updatePlanItemInstanceTimeStamp(planItemInstanceEntity, "cmmn-plan-item-instance-available", "lastAvailableTime");
    }

    @Override
    public void recordPlanItemInstanceEnabled(PlanItemInstanceEntity planItemInstanceEntity) {
        this.updatePlanItemInstanceTimeStamp(planItemInstanceEntity, "cmmn-plan-item-instance-enabled", "lastEnabledTime");
    }

    @Override
    public void recordPlanItemInstanceDisabled(PlanItemInstanceEntity planItemInstanceEntity) {
        this.updatePlanItemInstanceTimeStamp(planItemInstanceEntity, "cmmn-plan-item-instance-disabled", "lastDisabledTime");
    }

    @Override
    public void recordPlanItemInstanceStarted(PlanItemInstanceEntity planItemInstanceEntity) {
        this.updatePlanItemInstanceTimeStamp(planItemInstanceEntity, "cmmn-plan-item-instance-started", "lastStartedTime");
    }

    @Override
    public void recordPlanItemInstanceSuspended(PlanItemInstanceEntity planItemInstanceEntity) {
        this.updatePlanItemInstanceTimeStamp(planItemInstanceEntity, "cmmn-plan-item-instance-suspended", "lastSuspendedTime");
    }

    @Override
    public void recordPlanItemInstanceCompleted(PlanItemInstanceEntity planItemInstanceEntity) {
        this.updatePlanItemInstanceTimeStamp(planItemInstanceEntity, "cmmn-plan-item-instance-completed", "endTime", "completedTime");
    }

    @Override
    public void recordPlanItemInstanceOccurred(PlanItemInstanceEntity planItemInstanceEntity) {
        this.updatePlanItemInstanceTimeStamp(planItemInstanceEntity, "cmmn-plan-item-instance-occurred", "endTime", "occurredTime");
    }

    @Override
    public void recordPlanItemInstanceTerminated(PlanItemInstanceEntity planItemInstanceEntity) {
        this.updatePlanItemInstanceTimeStamp(planItemInstanceEntity, "cmmn-plan-item-instance-terminated", "endTime", "terminatedTime");
    }

    @Override
    public void recordPlanItemInstanceExit(PlanItemInstanceEntity planItemInstanceEntity) {
        this.updatePlanItemInstanceTimeStamp(planItemInstanceEntity, "cmmn-plan-item-instance-exit", "endTime", "exitTime");
    }

    protected void addCommonPlanItemInstanceFields(PlanItemInstanceEntity planItemInstanceEntity, Map<String, String> data) {
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"id", (String)planItemInstanceEntity.getId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"revision", (int)planItemInstanceEntity.getRevision());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"name", (String)planItemInstanceEntity.getName());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"state", (String)planItemInstanceEntity.getState());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"caseDefinitionId", (String)planItemInstanceEntity.getCaseDefinitionId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"caseInstanceId", (String)planItemInstanceEntity.getCaseInstanceId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"stageInstanceId", (String)planItemInstanceEntity.getStageInstanceId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"isStage", (Boolean)planItemInstanceEntity.isStage());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"elementId", (String)planItemInstanceEntity.getElementId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"planDefinitionId", (String)planItemInstanceEntity.getPlanItemDefinitionId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"planDefinitionType", (String)planItemInstanceEntity.getPlanItemDefinitionType());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"startUserId", (String)planItemInstanceEntity.getStartUserId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"referenceId", (String)planItemInstanceEntity.getReferenceId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"referenceType", (String)planItemInstanceEntity.getReferenceType());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"tenantId", (String)planItemInstanceEntity.getTenantId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"createTime", (Date)planItemInstanceEntity.getStartTime());
        if (planItemInstanceEntity.getCaseDefinitionId() != null) {
            this.addCaseDefinitionFields(data, CaseDefinitionUtil.getCaseDefinition(planItemInstanceEntity.getCaseDefinitionId()));
        }
    }

    protected void updatePlanItemInstanceTimeStamp(PlanItemInstanceEntity planItemInstanceEntity, String type, String ... fields) {
        if (this.cmmnEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.ACTIVITY)) {
            HashMap<String, String> data = new HashMap<String, String>();
            this.addCommonPlanItemInstanceFields(planItemInstanceEntity, data);
            Date time = this.cmmnEngineConfiguration.getClock().getCurrentTime();
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"lastUpdateTime", (Date)time);
            for (String field : fields) {
                AsyncHistoryJsonUtil.putIfNotNull(data, (String)field, (Date)time);
            }
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), type, data, planItemInstanceEntity.getTenantId());
        }
    }

    protected JobServiceConfiguration getJobServiceConfiguration() {
        return this.cmmnEngineConfiguration.getJobServiceConfiguration();
    }
}

