/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.persistence.entity;

import java.util.List;
import org.flowable.cmmn.api.history.HistoricCaseInstance;
import org.flowable.cmmn.api.history.HistoricMilestoneInstance;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.api.repository.CaseDefinitionQuery;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.history.HistoricCaseInstanceQueryImpl;
import org.flowable.cmmn.engine.impl.history.HistoricMilestoneInstanceQueryImpl;
import org.flowable.cmmn.engine.impl.persistence.entity.AbstractCmmnEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseDefinitionEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseDefinitionEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.HistoricCaseInstanceEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.HistoricMilestoneInstanceEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.HistoricPlanItemInstanceEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.data.CaseDefinitionDataManager;
import org.flowable.cmmn.engine.impl.repository.CaseDefinitionQueryImpl;
import org.flowable.cmmn.engine.impl.runtime.CaseInstanceQueryImpl;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.common.engine.impl.persistence.entity.data.DataManager;
import org.flowable.identitylink.service.impl.persistence.entity.HistoricIdentityLinkEntityManager;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.service.impl.HistoricTaskInstanceQueryImpl;
import org.flowable.task.service.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.flowable.task.service.impl.persistence.entity.HistoricTaskInstanceEntityManager;
import org.flowable.variable.service.impl.persistence.entity.HistoricVariableInstanceEntity;
import org.flowable.variable.service.impl.persistence.entity.HistoricVariableInstanceEntityManager;

public class CaseDefinitionEntityManagerImpl
extends AbstractCmmnEntityManager<CaseDefinitionEntity>
implements CaseDefinitionEntityManager {
    protected CaseDefinitionDataManager caseDefinitionDataManager;

    public CaseDefinitionEntityManagerImpl(CmmnEngineConfiguration cmmnEngineConfiguration, CaseDefinitionDataManager caseDefinitionDataManager) {
        super(cmmnEngineConfiguration);
        this.caseDefinitionDataManager = caseDefinitionDataManager;
    }

    @Override
    protected DataManager<CaseDefinitionEntity> getDataManager() {
        return this.caseDefinitionDataManager;
    }

    @Override
    public CaseDefinitionEntity findLatestCaseDefinitionByKey(String caseDefinitionKey) {
        return this.caseDefinitionDataManager.findLatestCaseDefinitionByKey(caseDefinitionKey);
    }

    @Override
    public CaseDefinitionEntity findLatestCaseDefinitionByKeyAndTenantId(String caseDefinitionKey, String tenantId) {
        return this.caseDefinitionDataManager.findLatestCaseDefinitionByKeyAndTenantId(caseDefinitionKey, tenantId);
    }

    @Override
    public CaseDefinitionEntity findCaseDefinitionByDeploymentAndKey(String deploymentId, String caseDefinitionKey) {
        return this.caseDefinitionDataManager.findCaseDefinitionByDeploymentAndKey(deploymentId, caseDefinitionKey);
    }

    @Override
    public CaseDefinitionEntity findCaseDefinitionByDeploymentAndKeyAndTenantId(String deploymentId, String caseDefinitionKey, String tenantId) {
        return this.caseDefinitionDataManager.findCaseDefinitionByDeploymentAndKeyAndTenantId(deploymentId, caseDefinitionKey, tenantId);
    }

    @Override
    public CaseDefinition findCaseDefinitionByKeyAndVersionAndTenantId(String caseDefinitionKey, Integer caseDefinitionVersion, String tenantId) {
        if (tenantId == null || "".equals(tenantId)) {
            return this.caseDefinitionDataManager.findCaseDefinitionByKeyAndVersion(caseDefinitionKey, caseDefinitionVersion);
        }
        return this.caseDefinitionDataManager.findCaseDefinitionByKeyAndVersionAndTenantId(caseDefinitionKey, caseDefinitionVersion, tenantId);
    }

    @Override
    public void deleteCaseDefinitionAndRelatedData(String caseDefinitionId, boolean cascadeHistory) {
        CaseInstanceEntityManager caseInstanceEntityManager = this.getCaseInstanceEntityManager();
        List<CaseInstance> caseInstances = caseInstanceEntityManager.findByCriteria(new CaseInstanceQueryImpl().caseDefinitionId(caseDefinitionId));
        for (CaseInstance caseInstance : caseInstances) {
            caseInstanceEntityManager.delete(caseInstance.getId(), true, null);
        }
        if (cascadeHistory) {
            HistoricIdentityLinkEntityManager historicIdentityLinkEntityManager = this.getHistoricIdentityLinkEntityManager();
            historicIdentityLinkEntityManager.deleteHistoricIdentityLinksByScopeDefinitionIdAndScopeType(caseDefinitionId, "cmmn");
            HistoricMilestoneInstanceEntityManager historicMilestoneInstanceEntityManager = this.getHistoricMilestoneInstanceEntityManager();
            List<HistoricMilestoneInstance> historicMilestoneInstances = historicMilestoneInstanceEntityManager.findHistoricMilestoneInstancesByQueryCriteria(new HistoricMilestoneInstanceQueryImpl().milestoneInstanceCaseDefinitionId(caseDefinitionId));
            for (HistoricMilestoneInstance historicMilestoneInstance : historicMilestoneInstances) {
                historicMilestoneInstanceEntityManager.delete(historicMilestoneInstance.getId());
            }
            HistoricTaskInstanceEntityManager historicTaskInstanceEntityManager = this.getHistoricTaskInstanceEntityManager();
            List historicTaskInstances = historicTaskInstanceEntityManager.findHistoricTaskInstancesByQueryCriteria(new HistoricTaskInstanceQueryImpl().scopeDefinitionId(caseDefinitionId).scopeType("cmmn"));
            for (HistoricTaskInstance historicTaskInstance : historicTaskInstances) {
                historicTaskInstanceEntityManager.delete((Entity)((HistoricTaskInstanceEntity)historicTaskInstance));
            }
            HistoricPlanItemInstanceEntityManager historicPlanItemInstanceEntityManager = this.getHistoricPlanItemInstanceEntityManager();
            historicPlanItemInstanceEntityManager.findByCaseDefinitionId(caseDefinitionId).forEach(p -> historicPlanItemInstanceEntityManager.delete(p.getId()));
            HistoricCaseInstanceEntityManager historicCaseInstanceEntityManager = this.getHistoricCaseInstanceEntityManager();
            List<HistoricCaseInstance> historicCaseInstanceEntities = historicCaseInstanceEntityManager.findByCriteria(new HistoricCaseInstanceQueryImpl().caseDefinitionId(caseDefinitionId));
            for (HistoricCaseInstance historicCaseInstanceEntity : historicCaseInstanceEntities) {
                HistoricVariableInstanceEntityManager historicVariableInstanceEntityManager = this.getHistoricVariableInstanceEntityManager();
                List historicVariableInstanceEntities = historicVariableInstanceEntityManager.findHistoricalVariableInstancesByScopeIdAndScopeType(historicCaseInstanceEntity.getId(), "cmmn");
                for (HistoricVariableInstanceEntity historicVariableInstanceEntity : historicVariableInstanceEntities) {
                    historicVariableInstanceEntityManager.delete((Entity)historicVariableInstanceEntity);
                }
                historicCaseInstanceEntityManager.delete(historicCaseInstanceEntity.getId());
            }
        }
        CaseDefinitionEntity caseDefinitionEntity = (CaseDefinitionEntity)this.findById(caseDefinitionId);
        this.delete(caseDefinitionEntity);
    }

    @Override
    public CaseDefinitionQuery createCaseDefinitionQuery() {
        return new CaseDefinitionQueryImpl(this.cmmnEngineConfiguration.getCommandExecutor());
    }

    @Override
    public List<CaseDefinition> findCaseDefinitionsByQueryCriteria(CaseDefinitionQuery caseDefinitionQuery) {
        return this.caseDefinitionDataManager.findCaseDefinitionsByQueryCriteria((CaseDefinitionQueryImpl)caseDefinitionQuery);
    }

    @Override
    public long findCaseDefinitionCountByQueryCriteria(CaseDefinitionQuery caseDefinitionQuery) {
        return this.caseDefinitionDataManager.findCaseDefinitionCountByQueryCriteria((CaseDefinitionQueryImpl)caseDefinitionQuery);
    }

    public CaseDefinitionDataManager getCaseDefinitionDataManager() {
        return this.caseDefinitionDataManager;
    }

    public void setCaseDefinitionDataManager(CaseDefinitionDataManager caseDefinitionDataManager) {
        this.caseDefinitionDataManager = caseDefinitionDataManager;
    }
}

