/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.runtime;

import java.util.Date;
import java.util.List;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.api.runtime.PlanItemInstanceQuery;
import org.flowable.cmmn.engine.impl.runtime.PlanItemInstanceQueryProperty;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.variable.service.impl.AbstractVariableQueryImpl;

public class PlanItemInstanceQueryImpl
extends AbstractVariableQueryImpl<PlanItemInstanceQuery, PlanItemInstance>
implements PlanItemInstanceQuery {
    protected String caseDefinitionId;
    protected String caseInstanceId;
    protected String stageInstanceId;
    protected String planItemInstanceId;
    protected String elementId;
    protected String planItemDefinitionId;
    protected String planItemDefinitionType;
    protected List<String> planItemDefinitionTypes;
    protected String name;
    protected String state;
    protected Date startedBefore;
    protected Date startedAfter;
    protected String startUserId;
    protected String referenceId;
    protected String referenceType;
    protected boolean completeable;
    protected String tenantId;
    protected boolean withoutTenantId;

    public PlanItemInstanceQueryImpl() {
    }

    public PlanItemInstanceQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public PlanItemInstanceQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    public PlanItemInstanceQuery caseDefinitionId(String caseDefinitionId) {
        if (caseDefinitionId == null) {
            throw new FlowableIllegalArgumentException("Case definition id is null");
        }
        this.caseDefinitionId = caseDefinitionId;
        return this;
    }

    public PlanItemInstanceQuery caseInstanceId(String caseInstanceId) {
        if (caseInstanceId == null) {
            throw new FlowableIllegalArgumentException("Case instance id is null");
        }
        this.caseInstanceId = caseInstanceId;
        return this;
    }

    public PlanItemInstanceQuery stageInstanceId(String stageInstanceId) {
        if (stageInstanceId == null) {
            throw new FlowableIllegalArgumentException("Stage instance id is null");
        }
        this.stageInstanceId = stageInstanceId;
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceId(String planItemInstanceId) {
        if (planItemInstanceId == null) {
            throw new FlowableIllegalArgumentException("Plan Item instance id is null");
        }
        this.planItemInstanceId = planItemInstanceId;
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceElementId(String elementId) {
        if (elementId == null) {
            throw new FlowableIllegalArgumentException("Element id is null");
        }
        this.elementId = elementId;
        return this;
    }

    public PlanItemInstanceQuery planItemDefinitionId(String planItemDefinitionId) {
        if (planItemDefinitionId == null) {
            throw new FlowableIllegalArgumentException("Plan item definition id is null");
        }
        this.planItemDefinitionId = planItemDefinitionId;
        return this;
    }

    public PlanItemInstanceQuery planItemDefinitionType(String planItemDefinitionType) {
        if (planItemDefinitionType == null) {
            throw new FlowableIllegalArgumentException("Plan item definition type is null");
        }
        this.planItemDefinitionType = planItemDefinitionType;
        return this;
    }

    public PlanItemInstanceQuery planItemDefinitionTypes(List<String> planItemDefinitionTypes) {
        if (planItemDefinitionTypes == null) {
            throw new FlowableIllegalArgumentException("Plan item definition types is null");
        }
        if (planItemDefinitionTypes.isEmpty()) {
            throw new FlowableIllegalArgumentException("Plan item definition types is empty");
        }
        this.planItemDefinitionTypes = planItemDefinitionTypes;
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceName(String name) {
        if (name == null) {
            throw new FlowableIllegalArgumentException("Name is null");
        }
        this.name = name;
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceState(String state) {
        if (state == null) {
            throw new FlowableIllegalArgumentException("State is null");
        }
        this.state = state;
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceStateWaitingForRepetition() {
        return this.planItemInstanceState("wait_repetition");
    }

    public PlanItemInstanceQuery planItemInstanceStateActive() {
        return this.planItemInstanceState("active");
    }

    public PlanItemInstanceQuery planItemInstanceStateEnabled() {
        return this.planItemInstanceState("enabled");
    }

    public PlanItemInstanceQuery planItemInstanceStateDisabled() {
        return this.planItemInstanceState("disabled");
    }

    public PlanItemInstanceQuery planItemInstanceStateAsyncActive() {
        return this.planItemInstanceState("async-active");
    }

    public PlanItemInstanceQuery planItemInstanceStateAvailable() {
        return this.planItemInstanceState("available");
    }

    public PlanItemInstanceQuery planItemInstanceStateCompleted() {
        return this.planItemInstanceState("completed");
    }

    public PlanItemInstanceQuery planItemInstanceStateTerminated() {
        return this.planItemInstanceState("terminated");
    }

    public PlanItemInstanceQuery planItemInstanceStartedBefore(Date startedBefore) {
        if (startedBefore == null) {
            throw new FlowableIllegalArgumentException("StartedBefore is null");
        }
        this.startedBefore = startedBefore;
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceStartedAfter(Date startedAfter) {
        if (startedAfter == null) {
            throw new FlowableIllegalArgumentException("StartedAfter is null");
        }
        this.startedAfter = startedAfter;
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceStartUserId(String startUserId) {
        if (startUserId == null) {
            throw new FlowableIllegalArgumentException("Start user id is null");
        }
        this.startUserId = startUserId;
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceReferenceId(String referenceId) {
        this.referenceId = referenceId;
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceReferenceType(String referenceType) {
        this.referenceType = referenceType;
        return this;
    }

    public PlanItemInstanceQuery planItemCompleteable() {
        this.completeable = true;
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceTenantId(String tenantId) {
        if (tenantId == null) {
            throw new FlowableIllegalArgumentException("Tenant id is null");
        }
        this.tenantId = tenantId;
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceWithoutTenantId() {
        this.withoutTenantId = true;
        return this;
    }

    public PlanItemInstanceQuery caseVariableValueEquals(String name, Object value) {
        return (PlanItemInstanceQuery)this.variableValueEquals(name, value, false);
    }

    public PlanItemInstanceQuery caseVariableValueEquals(Object value) {
        return (PlanItemInstanceQuery)this.variableValueEquals(value, false);
    }

    public PlanItemInstanceQuery caseVariableValueEqualsIgnoreCase(String name, String value) {
        return (PlanItemInstanceQuery)this.variableValueEqualsIgnoreCase(name, value, false);
    }

    public PlanItemInstanceQuery caseVariableValueNotEquals(String name, Object value) {
        return (PlanItemInstanceQuery)this.variableValueNotEquals(name, value, false);
    }

    public PlanItemInstanceQuery caseVariableValueNotEqualsIgnoreCase(String name, String value) {
        return (PlanItemInstanceQuery)this.variableValueNotEqualsIgnoreCase(name, value, false);
    }

    public PlanItemInstanceQuery caseVariableValueGreaterThan(String name, Object value) {
        return (PlanItemInstanceQuery)this.variableValueGreaterThan(name, value, false);
    }

    public PlanItemInstanceQuery caseVariableValueGreaterThanOrEqual(String name, Object value) {
        return (PlanItemInstanceQuery)this.variableValueGreaterThanOrEqual(name, value, false);
    }

    public PlanItemInstanceQuery caseVariableValueLessThan(String name, Object value) {
        return (PlanItemInstanceQuery)this.variableValueLessThan(name, value, false);
    }

    public PlanItemInstanceQuery caseVariableValueLessThanOrEqual(String name, Object value) {
        return (PlanItemInstanceQuery)this.variableValueLessThanOrEqual(name, value, false);
    }

    public PlanItemInstanceQuery caseVariableValueLike(String name, String value) {
        return (PlanItemInstanceQuery)this.variableValueLike(name, value, false);
    }

    public PlanItemInstanceQuery caseVariableValueLikeIgnoreCase(String name, String value) {
        return (PlanItemInstanceQuery)this.variableValueLikeIgnoreCase(name, value, false);
    }

    public PlanItemInstanceQuery caseVariableExists(String name) {
        return (PlanItemInstanceQuery)this.variableExists(name, false);
    }

    public PlanItemInstanceQuery caseVariableNotExists(String name) {
        return (PlanItemInstanceQuery)this.variableNotExists(name, false);
    }

    public long executeCount(CommandContext commandContext) {
        this.ensureVariablesInitialized();
        return CommandContextUtil.getPlanItemInstanceEntityManager(commandContext).countByCriteria(this);
    }

    public List<PlanItemInstance> executeList(CommandContext commandContext) {
        this.ensureVariablesInitialized();
        return CommandContextUtil.getPlanItemInstanceEntityManager(commandContext).findByCriteria(this);
    }

    public PlanItemInstanceQuery orderByStartTime() {
        this.orderProperty = PlanItemInstanceQueryProperty.START_TIME;
        return this;
    }

    public PlanItemInstanceQuery orderByName() {
        this.orderProperty = PlanItemInstanceQueryProperty.NAME;
        return this;
    }

    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public String getStageInstanceId() {
        return this.stageInstanceId;
    }

    public String getPlanItemInstanceId() {
        return this.planItemInstanceId;
    }

    public String getElementId() {
        return this.elementId;
    }

    public String getPlanItemDefinitionId() {
        return this.planItemDefinitionId;
    }

    public String getPlanItemDefinitionType() {
        return this.planItemDefinitionType;
    }

    public List<String> getPlanItemDefinitionTypes() {
        return this.planItemDefinitionTypes;
    }

    public void setPlanItemDefinitionTypes(List<String> planItemDefinitionTypes) {
        this.planItemDefinitionTypes = planItemDefinitionTypes;
    }

    public String getName() {
        return this.name;
    }

    public String getState() {
        return this.state;
    }

    public Date getStartedBefore() {
        return this.startedBefore;
    }

    public Date getStartedAfter() {
        return this.startedAfter;
    }

    public String getStartUserId() {
        return this.startUserId;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public String getReferenceType() {
        return this.referenceType;
    }

    public boolean isCompleteable() {
        return this.completeable;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public boolean isWithoutTenantId() {
        return this.withoutTenantId;
    }
}

