/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl;

import java.util.Collection;
import java.util.Map;
import org.flowable.cmmn.api.CmmnManagementService;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.cmd.GetTableCountsCmd;
import org.flowable.cmmn.engine.impl.cmd.GetTableNamesCmd;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.service.CommonEngineServiceImpl;
import org.flowable.job.api.DeadLetterJobQuery;
import org.flowable.job.api.HistoryJobQuery;
import org.flowable.job.api.Job;
import org.flowable.job.api.JobQuery;
import org.flowable.job.api.SuspendedJobQuery;
import org.flowable.job.api.TimerJobQuery;
import org.flowable.job.service.impl.DeadLetterJobQueryImpl;
import org.flowable.job.service.impl.HistoryJobQueryImpl;
import org.flowable.job.service.impl.JobQueryImpl;
import org.flowable.job.service.impl.SuspendedJobQueryImpl;
import org.flowable.job.service.impl.TimerJobQueryImpl;
import org.flowable.job.service.impl.cmd.DeleteDeadLetterJobCmd;
import org.flowable.job.service.impl.cmd.DeleteJobCmd;
import org.flowable.job.service.impl.cmd.DeleteSuspendedJobCmd;
import org.flowable.job.service.impl.cmd.DeleteTimerJobCmd;
import org.flowable.job.service.impl.cmd.ExecuteHistoryJobCmd;
import org.flowable.job.service.impl.cmd.ExecuteJobCmd;
import org.flowable.job.service.impl.cmd.GetJobExceptionStacktraceCmd;
import org.flowable.job.service.impl.cmd.JobType;
import org.flowable.job.service.impl.cmd.MoveDeadLetterJobToExecutableJobCmd;
import org.flowable.job.service.impl.cmd.MoveJobToDeadLetterJobCmd;
import org.flowable.job.service.impl.cmd.MoveTimerToExecutableJobCmd;
import org.flowable.job.service.impl.cmd.SetJobRetriesCmd;
import org.flowable.job.service.impl.cmd.SetTimerJobRetriesCmd;

public class CmmnManagementServiceImpl
extends CommonEngineServiceImpl<CmmnEngineConfiguration>
implements CmmnManagementService {
    public CmmnManagementServiceImpl(CmmnEngineConfiguration engineConfiguration) {
        super((AbstractEngineConfiguration)engineConfiguration);
    }

    public Map<String, Long> getTableCounts() {
        return (Map)this.commandExecutor.execute((Command)new GetTableCountsCmd());
    }

    public Collection<String> getTableNames() {
        return (Collection)this.commandExecutor.execute((Command)new GetTableNamesCmd());
    }

    public void executeJob(String jobId) {
        if (jobId == null) {
            throw new FlowableIllegalArgumentException("Job id is null");
        }
        try {
            this.commandExecutor.execute((Command)new ExecuteJobCmd(jobId));
        }
        catch (RuntimeException e) {
            if (e instanceof FlowableException) {
                throw e;
            }
            throw new FlowableException("Job " + jobId + " failed", (Throwable)e);
        }
    }

    public void executeHistoryJob(String historyJobId) {
        this.commandExecutor.execute((Command)new ExecuteHistoryJobCmd(historyJobId));
    }

    public Job moveTimerToExecutableJob(String jobId) {
        return (Job)this.commandExecutor.execute((Command)new MoveTimerToExecutableJobCmd(jobId));
    }

    public Job moveJobToDeadLetterJob(String jobId) {
        return (Job)this.commandExecutor.execute((Command)new MoveJobToDeadLetterJobCmd(jobId));
    }

    public Job moveDeadLetterJobToExecutableJob(String jobId, int retries) {
        return (Job)this.commandExecutor.execute((Command)new MoveDeadLetterJobToExecutableJobCmd(jobId, retries));
    }

    public void deleteJob(String jobId) {
        this.commandExecutor.execute((Command)new DeleteJobCmd(jobId));
    }

    public void deleteTimerJob(String jobId) {
        this.commandExecutor.execute((Command)new DeleteTimerJobCmd(jobId));
    }

    public void deleteSuspendedJob(String jobId) {
        this.commandExecutor.execute((Command)new DeleteSuspendedJobCmd(jobId));
    }

    public void deleteDeadLetterJob(String jobId) {
        this.commandExecutor.execute((Command)new DeleteDeadLetterJobCmd(jobId));
    }

    public void setJobRetries(String jobId, int retries) {
        this.commandExecutor.execute((Command)new SetJobRetriesCmd(jobId, retries));
    }

    public void setTimerJobRetries(String jobId, int retries) {
        this.commandExecutor.execute((Command)new SetTimerJobRetriesCmd(jobId, retries));
    }

    public JobQuery createJobQuery() {
        return new JobQueryImpl(this.commandExecutor);
    }

    public TimerJobQuery createTimerJobQuery() {
        return new TimerJobQueryImpl(this.commandExecutor);
    }

    public SuspendedJobQuery createSuspendedJobQuery() {
        return new SuspendedJobQueryImpl(this.commandExecutor);
    }

    public DeadLetterJobQuery createDeadLetterJobQuery() {
        return new DeadLetterJobQueryImpl(this.commandExecutor);
    }

    public String getJobExceptionStacktrace(String jobId) {
        return (String)this.commandExecutor.execute((Command)new GetJobExceptionStacktraceCmd(jobId, JobType.ASYNC));
    }

    public String getTimerJobExceptionStacktrace(String jobId) {
        return (String)this.commandExecutor.execute((Command)new GetJobExceptionStacktraceCmd(jobId, JobType.TIMER));
    }

    public String getSuspendedJobExceptionStacktrace(String jobId) {
        return (String)this.commandExecutor.execute((Command)new GetJobExceptionStacktraceCmd(jobId, JobType.SUSPENDED));
    }

    public String getDeadLetterJobExceptionStacktrace(String jobId) {
        return (String)this.commandExecutor.execute((Command)new GetJobExceptionStacktraceCmd(jobId, JobType.DEADLETTER));
    }

    public HistoryJobQuery createHistoryJobQuery() {
        return new HistoryJobQueryImpl(this.commandExecutor);
    }
}

