/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntityManager;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class SetCaseInstanceBusinessKeyCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String caseInstanceId;
    private final String businessKey;

    public SetCaseInstanceBusinessKeyCmd(String caseInstanceId, String businessKey) {
        if (caseInstanceId == null || caseInstanceId.length() < 1) {
            throw new FlowableIllegalArgumentException("The case instance id is mandatory, but '" + caseInstanceId + "' has not been provided.");
        }
        if (businessKey == null) {
            throw new FlowableIllegalArgumentException("The business key is mandatory, but 'null' has been provided.");
        }
        this.caseInstanceId = caseInstanceId;
        this.businessKey = businessKey;
    }

    public Void execute(CommandContext commandContext) {
        CaseInstanceEntityManager caseInstanceEntityManager = CommandContextUtil.getCaseInstanceEntityManager(commandContext);
        CaseInstanceEntity caseInstanceEntity = (CaseInstanceEntity)caseInstanceEntityManager.findById(this.caseInstanceId);
        if (caseInstanceEntity == null) {
            throw new FlowableObjectNotFoundException("No case instance found for id = '" + this.caseInstanceId + "'.", CaseInstance.class);
        }
        caseInstanceEntityManager.updateCaseInstanceBusinessKey(caseInstanceEntity, this.businessKey);
        return null;
    }
}

