/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.behavior.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.delegate.DelegatePlanItemInstance;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.agenda.CmmnEngineAgenda;
import org.flowable.cmmn.engine.impl.behavior.CoreCmmnTriggerableActivityBehavior;
import org.flowable.cmmn.engine.impl.behavior.PlanItemActivityBehavior;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.engine.impl.util.EventInstanceCmmnUtil;
import org.flowable.cmmn.engine.impl.util.PlanItemInstanceUtil;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.ExtensionElement;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.eventregistry.api.runtime.EventInstance;
import org.flowable.eventsubscription.service.EventSubscriptionService;
import org.flowable.eventsubscription.service.impl.persistence.entity.EventSubscriptionEntity;

public class EventRegistryEventListenerActivityBehaviour
extends CoreCmmnTriggerableActivityBehavior
implements PlanItemActivityBehavior {
    protected Expression eventDefinitionKeyExpression;

    public EventRegistryEventListenerActivityBehaviour(Expression eventDefinitionKeyExpression) {
        this.eventDefinitionKeyExpression = eventDefinitionKeyExpression;
    }

    @Override
    public void execute(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
    }

    protected String resolveEventDefinitionKey(PlanItemInstanceEntity planItemInstanceEntity) {
        Object key = null;
        if (this.eventDefinitionKeyExpression != null) {
            key = this.eventDefinitionKeyExpression.getValue((VariableContainer)planItemInstanceEntity);
        }
        if (key == null) {
            throw new FlowableException("Could not resolve key from expression: " + this.eventDefinitionKeyExpression);
        }
        return key.toString();
    }

    @Override
    public void trigger(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        EventInstance eventInstance = (EventInstance)planItemInstanceEntity.getTransientVariable("eventInstance");
        if (eventInstance != null) {
            this.handleEventInstance(planItemInstanceEntity, eventInstance);
        }
        PlanItemInstanceEntity eventPlanItemInstanceEntity = PlanItemInstanceUtil.copyAndInsertPlanItemInstance(commandContext, planItemInstanceEntity, false, false);
        eventPlanItemInstanceEntity.setState("available");
        CmmnEngineAgenda agenda = CommandContextUtil.getAgenda(commandContext);
        agenda.planCreatePlanItemInstanceWithoutEvaluationOperation(eventPlanItemInstanceEntity);
        agenda.planOccurPlanItemInstanceOperation(eventPlanItemInstanceEntity);
    }

    protected void handleEventInstance(PlanItemInstanceEntity planItemInstanceEntity, EventInstance eventInstance) {
        PlanItemDefinition planItemDefinition = planItemInstanceEntity.getPlanItemDefinition();
        if (planItemDefinition != null) {
            EventInstanceCmmnUtil.handleEventInstanceOutParameters(planItemInstanceEntity, (BaseElement)planItemDefinition, eventInstance);
        }
    }

    @Override
    public void onStateTransition(CommandContext commandContext, DelegatePlanItemInstance planItemInstance, String transition) {
        if ("terminate".equals(transition) || "exit".equals(transition) || "dismiss".equals(transition)) {
            CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
            EventSubscriptionService eventSubscriptionService = cmmnEngineConfiguration.getEventSubscriptionServiceConfiguration().getEventSubscriptionService();
            List eventSubscriptions = eventSubscriptionService.findEventSubscriptionsBySubScopeId(planItemInstance.getId());
            for (EventSubscriptionEntity eventSubscription : eventSubscriptions) {
                eventSubscriptionService.deleteEventSubscription(eventSubscription);
            }
        } else if ("create".equals(transition)) {
            this.createEventSubscription(commandContext, (PlanItemInstanceEntity)planItemInstance);
        }
    }

    protected void createEventSubscription(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        String eventDefinitionKey = this.resolveEventDefinitionKey(planItemInstanceEntity);
        String correlationKey = this.getCorrelationKey(commandContext, planItemInstanceEntity);
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        cmmnEngineConfiguration.getEventSubscriptionServiceConfiguration().getEventSubscriptionService().createEventSubscriptionBuilder().eventType(eventDefinitionKey).subScopeId(planItemInstanceEntity.getId()).scopeId(planItemInstanceEntity.getCaseInstanceId()).scopeDefinitionId(planItemInstanceEntity.getCaseDefinitionId()).scopeType("cmmn").tenantId(planItemInstanceEntity.getTenantId()).configuration(correlationKey).create();
    }

    protected String getCorrelationKey(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        String correlationKey;
        PlanItemDefinition planItemDefinition = planItemInstanceEntity.getPlanItemDefinition();
        if (planItemDefinition != null) {
            List eventCorrelations = planItemDefinition.getExtensionElements().getOrDefault("eventCorrelationParameter", Collections.emptyList());
            if (!eventCorrelations.isEmpty()) {
                CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
                ExpressionManager expressionManager = cmmnEngineConfiguration.getExpressionManager();
                HashMap<String, Object> correlationParameters = new HashMap<String, Object>();
                for (ExtensionElement eventCorrelation : eventCorrelations) {
                    String name = eventCorrelation.getAttributeValue(null, "name");
                    String valueExpression = eventCorrelation.getAttributeValue(null, "value");
                    if (StringUtils.isNotEmpty((CharSequence)valueExpression)) {
                        Object value = expressionManager.createExpression(valueExpression).getValue((VariableContainer)planItemInstanceEntity);
                        correlationParameters.put(name, value);
                        continue;
                    }
                    correlationParameters.put(name, null);
                }
                correlationKey = CommandContextUtil.getEventRegistry().generateKey(correlationParameters);
            } else {
                correlationKey = null;
            }
        } else {
            correlationKey = null;
        }
        return correlationKey;
    }
}

