/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.interceptor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.flowable.cmmn.engine.impl.agenda.CmmnEngineAgenda;
import org.flowable.cmmn.engine.impl.agenda.operation.CmmnOperation;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.impl.agenda.AgendaOperationRunner;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.interceptor.AbstractCommandInterceptor;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandConfig;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.common.engine.impl.interceptor.CommandInterceptor;
import org.flowable.common.engine.impl.variablelistener.VariableListenerSession;
import org.flowable.common.engine.impl.variablelistener.VariableListenerSessionData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmmnCommandInvoker
extends AbstractCommandInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CmmnCommandInvoker.class);
    protected AgendaOperationRunner agendaOperationRunner;

    public CmmnCommandInvoker(AgendaOperationRunner agendaOperationRunner) {
        this.agendaOperationRunner = agendaOperationRunner;
    }

    public <T> T execute(CommandConfig config, final Command<T> command, CommandExecutor commandExecutor) {
        final CommandContext commandContext = Context.getCommandContext();
        CmmnEngineAgenda agenda = CommandContextUtil.getAgenda(commandContext);
        if (commandContext.isReused() && !agenda.isEmpty()) {
            commandContext.setResult(command.execute(commandContext));
        } else {
            agenda.planOperation(new Runnable(){

                @Override
                public void run() {
                    commandContext.setResult(command.execute(commandContext));
                }
            });
            this.executeOperations(commandContext, true);
            this.evaluateUntilStable(commandContext);
        }
        return (T)commandContext.getResult();
    }

    protected void executeOperations(CommandContext commandContext, boolean isStoreCaseInstanceIdOfNoOperation) {
        CmmnEngineAgenda agenda = CommandContextUtil.getAgenda(commandContext);
        while (!agenda.isEmpty()) {
            Runnable runnable = agenda.getNextOperation();
            this.executeOperation(commandContext, isStoreCaseInstanceIdOfNoOperation, runnable);
        }
    }

    protected void executeOperation(CommandContext commandContext, boolean isStoreCaseInstanceIdOfNoOperation, Runnable runnable) {
        if (runnable instanceof CmmnOperation) {
            String caseInstanceId;
            CmmnOperation operation = (CmmnOperation)runnable;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Executing agenda operation {}", (Object)runnable);
            }
            this.agendaOperationRunner.executeOperation(commandContext, runnable);
            if ((isStoreCaseInstanceIdOfNoOperation || !operation.isNoop()) && (caseInstanceId = operation.getCaseInstanceId()) != null) {
                CommandContextUtil.addInvolvedCaseInstanceId(commandContext, caseInstanceId);
            }
        } else {
            runnable.run();
        }
    }

    protected void evaluateUntilStable(CommandContext commandContext) {
        Set<String> involvedCaseInstanceIds = CommandContextUtil.getInvolvedCaseInstanceIds(commandContext);
        if (involvedCaseInstanceIds != null && !involvedCaseInstanceIds.isEmpty()) {
            CmmnEngineAgenda agenda = CommandContextUtil.getAgenda(commandContext);
            for (String caseInstanceId : involvedCaseInstanceIds) {
                VariableListenerSession variableListenerSession = (VariableListenerSession)commandContext.getSession(VariableListenerSession.class);
                Map variableSessionData = variableListenerSession.getVariableData();
                if (variableSessionData != null) {
                    ArrayList<String> variableListenerCaseInstanceIds = new ArrayList<String>();
                    for (String variableName : variableSessionData.keySet()) {
                        List variableListenerDataList = (List)variableSessionData.get(variableName);
                        for (VariableListenerSessionData variableListenerData : variableListenerDataList) {
                            if (variableListenerCaseInstanceIds.contains(variableListenerData.getScopeId()) || !caseInstanceId.equals(variableListenerData.getScopeId())) continue;
                            variableListenerCaseInstanceIds.add(variableListenerData.getScopeId());
                            agenda.planEvaluateVariableEventListenersOperation(variableListenerData.getScopeId());
                        }
                    }
                }
                agenda.planEvaluateCriteriaOperation(caseInstanceId, true);
            }
            involvedCaseInstanceIds.clear();
            this.executeOperations(commandContext, false);
            if (!involvedCaseInstanceIds.isEmpty()) {
                this.evaluateUntilStable(commandContext);
            }
        }
    }

    public void setNext(CommandInterceptor next) {
        throw new UnsupportedOperationException("CommandInvoker must be the last interceptor in the chain");
    }

    public AgendaOperationRunner getAgendaOperationRunner() {
        return this.agendaOperationRunner;
    }

    public void setAgendaOperationRunner(AgendaOperationRunner agendaOperationRunner) {
        this.agendaOperationRunner = agendaOperationRunner;
    }
}

