/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.flowable.cmmn.engine.CmmnEngine;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.EngineInfo;
import org.flowable.common.engine.impl.util.ReflectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CmmnEngines {
    private static final Logger LOGGER = LoggerFactory.getLogger(CmmnEngines.class);
    public static final String NAME_DEFAULT = "default";
    protected static boolean isInitialized;
    protected static Map<String, CmmnEngine> cmmnEngines;
    protected static Map<String, EngineInfo> cmmnEngineInfosByName;
    protected static Map<String, EngineInfo> cmmnEngineInfosByResourceUrl;
    protected static List<EngineInfo> cmmnEngineInfos;

    public static synchronized void init() {
        if (!CmmnEngines.isInitialized()) {
            if (cmmnEngines == null) {
                cmmnEngines = new HashMap<String, CmmnEngine>();
            }
            ClassLoader classLoader = CmmnEngines.class.getClassLoader();
            Enumeration<URL> resources = null;
            try {
                resources = classLoader.getResources("flowable.cmmn.cfg.xml");
            }
            catch (IOException e) {
                throw new FlowableException("problem retrieving flowable.cmmn.cfg.xml resources on the classpath: " + System.getProperty("java.class.path"), (Throwable)e);
            }
            HashSet<URL> configUrls = new HashSet<URL>();
            while (resources.hasMoreElements()) {
                configUrls.add(resources.nextElement());
            }
            for (URL resource : configUrls) {
                LOGGER.info("Initializing cmmn engine using configuration '{}'", (Object)resource);
                CmmnEngines.initCmmnEngineFromResource(resource);
            }
            try {
                resources = classLoader.getResources("flowable-cmmn-context.xml");
            }
            catch (IOException e) {
                throw new FlowableException("problem retrieving flowable-cmmn-context.xml resources on the classpath: " + System.getProperty("java.class.path"), (Throwable)e);
            }
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                LOGGER.info("Initializing cmmn engine using Spring configuration '{}'", (Object)resource);
                CmmnEngines.initCmmnEngineFromSpringResource(resource);
            }
            CmmnEngines.setInitialized(true);
        } else {
            LOGGER.info("Cmmn engines already initialized");
        }
    }

    protected static void initCmmnEngineFromSpringResource(URL resource) {
        try {
            Class springConfigurationHelperClass = ReflectUtil.loadClass((String)"org.flowable.cmmn.spring.SpringCmmnConfigurationHelper");
            Method method = springConfigurationHelperClass.getDeclaredMethod("buildCmmnEngine", URL.class);
            CmmnEngine cmmnEngine = (CmmnEngine)method.invoke(null, resource);
            String cmmnEngineName = cmmnEngine.getName();
            EngineInfo cmmnEngineInfo = new EngineInfo(cmmnEngineName, resource.toString(), null);
            cmmnEngineInfosByName.put(cmmnEngineName, cmmnEngineInfo);
            cmmnEngineInfosByResourceUrl.put(resource.toString(), cmmnEngineInfo);
        }
        catch (Exception e) {
            throw new FlowableException("couldn't initialize cmmn engine from spring configuration resource " + resource + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public static void registerCmmnEngine(CmmnEngine cmmnEngine) {
        cmmnEngines.put(cmmnEngine.getName(), cmmnEngine);
    }

    public static void unregister(CmmnEngine cmmnEngine) {
        cmmnEngines.remove(cmmnEngine.getName());
    }

    private static EngineInfo initCmmnEngineFromResource(URL resourceUrl) {
        EngineInfo cmmnEngineInfo = cmmnEngineInfosByResourceUrl.get(resourceUrl.toString());
        if (cmmnEngineInfo != null) {
            cmmnEngineInfos.remove(cmmnEngineInfo);
            if (cmmnEngineInfo.getException() == null) {
                String cmmnEngineName = cmmnEngineInfo.getName();
                cmmnEngines.remove(cmmnEngineName);
                cmmnEngineInfosByName.remove(cmmnEngineName);
            }
            cmmnEngineInfosByResourceUrl.remove(cmmnEngineInfo.getResourceUrl());
        }
        String resourceUrlString = resourceUrl.toString();
        try {
            LOGGER.info("initializing cmmn engine for resource {}", (Object)resourceUrl);
            CmmnEngine cmmnEngine = CmmnEngines.buildCmmnEngine(resourceUrl);
            String cmmnEngineName = cmmnEngine.getName();
            LOGGER.info("initialised cmmn engine {}", (Object)cmmnEngineName);
            cmmnEngineInfo = new EngineInfo(cmmnEngineName, resourceUrlString, null);
            cmmnEngines.put(cmmnEngineName, cmmnEngine);
            cmmnEngineInfosByName.put(cmmnEngineName, cmmnEngineInfo);
        }
        catch (Throwable e) {
            LOGGER.error("Exception while initializing cmmn engine: {}", (Object)e.getMessage(), (Object)e);
            cmmnEngineInfo = new EngineInfo(null, resourceUrlString, ExceptionUtils.getStackTrace((Throwable)e));
        }
        cmmnEngineInfosByResourceUrl.put(resourceUrlString, cmmnEngineInfo);
        cmmnEngineInfos.add(cmmnEngineInfo);
        return cmmnEngineInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static CmmnEngine buildCmmnEngine(URL resource) {
        try (InputStream inputStream = resource.openStream();){
            CmmnEngineConfiguration cmmnEngineConfiguration = CmmnEngineConfiguration.createCmmnEngineConfigurationFromInputStream(inputStream);
            CmmnEngine cmmnEngine = cmmnEngineConfiguration.buildCmmnEngine();
            return cmmnEngine;
        }
        catch (IOException e) {
            throw new FlowableException("couldn't open resource stream: " + e.getMessage(), (Throwable)e);
        }
    }

    public static List<EngineInfo> getCmmnEngineInfos() {
        return cmmnEngineInfos;
    }

    public static EngineInfo getCmmnEngineInfo(String cmmnEngineName) {
        return cmmnEngineInfosByName.get(cmmnEngineName);
    }

    public static CmmnEngine getDefaultCmmnEngine() {
        return CmmnEngines.getCmmnEngine(NAME_DEFAULT);
    }

    public static CmmnEngine getCmmnEngine(String cmmnEngineName) {
        if (!CmmnEngines.isInitialized()) {
            CmmnEngines.init();
        }
        return cmmnEngines.get(cmmnEngineName);
    }

    public static EngineInfo retry(String resourceUrl) {
        LOGGER.debug("retying initializing of resource {}", (Object)resourceUrl);
        try {
            return CmmnEngines.initCmmnEngineFromResource(new URL(resourceUrl));
        }
        catch (MalformedURLException e) {
            throw new FlowableException("invalid url: " + resourceUrl, (Throwable)e);
        }
    }

    public static Map<String, CmmnEngine> getCmmnEngines() {
        return cmmnEngines;
    }

    public static synchronized void destroy() {
        if (CmmnEngines.isInitialized()) {
            HashMap<String, CmmnEngine> engines = new HashMap<String, CmmnEngine>(cmmnEngines);
            cmmnEngines = new HashMap<String, CmmnEngine>();
            for (String cmmnEngineName : engines.keySet()) {
                CmmnEngine cmmnEngine = (CmmnEngine)engines.get(cmmnEngineName);
                try {
                    cmmnEngine.close();
                }
                catch (Exception e) {
                    LOGGER.error("exception while closing {}", (Object)(cmmnEngineName == null ? "the default cmmn engine" : "cmmn engine " + cmmnEngineName), (Object)e);
                }
            }
            cmmnEngineInfosByName.clear();
            cmmnEngineInfosByResourceUrl.clear();
            cmmnEngineInfos.clear();
            CmmnEngines.setInitialized(false);
        }
    }

    public static boolean isInitialized() {
        return isInitialized;
    }

    public static void setInitialized(boolean isInitialized) {
        CmmnEngines.isInitialized = isInitialized;
    }

    static {
        cmmnEngines = new HashMap<String, CmmnEngine>();
        cmmnEngineInfosByName = new HashMap<String, EngineInfo>();
        cmmnEngineInfosByResourceUrl = new HashMap<String, EngineInfo>();
        cmmnEngineInfos = new ArrayList<EngineInfo>();
    }
}

