/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.agenda.operation;

import org.flowable.cmmn.api.runtime.PlanItemInstanceState;
import org.flowable.cmmn.engine.impl.agenda.operation.AbstractMovePlanItemInstanceToTerminalStateOperation;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.engine.impl.util.CompletionEvaluationResult;
import org.flowable.cmmn.engine.impl.util.PlanItemInstanceContainerUtil;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class ExitPlanItemInstanceOperation
extends AbstractMovePlanItemInstanceToTerminalStateOperation {
    protected String exitCriterionId;
    protected String exitType;
    protected String exitEventType;
    protected Boolean isStage = null;

    public ExitPlanItemInstanceOperation(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity, String exitCriterionId, String exitType, String exitEventType) {
        super(commandContext, planItemInstanceEntity);
        this.exitCriterionId = exitCriterionId;
        this.exitType = exitType;
        this.exitEventType = exitEventType;
    }

    @Override
    public String getNewState() {
        if (this.shouldStageGoIntoCompletedState()) {
            return "completed";
        }
        if (this.shouldPlanItemStayInCurrentState()) {
            return this.planItemInstanceEntity.getState();
        }
        return "terminated";
    }

    @Override
    public boolean abortOperationIfNewStateEqualsOldState() {
        return true;
    }

    public boolean shouldStageGoIntoCompletedState() {
        return this.isStage() && ("complete".equals(this.exitEventType) || "forceComplete".equals(this.exitEventType));
    }

    public boolean shouldPlanItemStayInCurrentState() {
        return !this.isStage() && ("activeInstances".equals(this.exitType) && ("enabled".equals(this.planItemInstanceEntity.getState()) || PlanItemInstanceState.EVALUATE_STATES.contains(this.planItemInstanceEntity.getState())) || "activeAndEnabledInstances".equals(this.exitType) && PlanItemInstanceState.EVALUATE_STATES.contains(this.planItemInstanceEntity.getState()));
    }

    @Override
    public String getLifeCycleTransition() {
        if (this.shouldStageGoIntoCompletedState()) {
            return "complete";
        }
        return "exit";
    }

    @Override
    protected void internalExecute() {
        if (this.isStage()) {
            CompletionEvaluationResult completionEvaluationResult;
            if ("complete".equals(this.exitEventType) && !(completionEvaluationResult = PlanItemInstanceContainerUtil.shouldPlanItemContainerComplete(this.commandContext, this.planItemInstanceEntity, true)).isCompletable()) {
                throw new FlowableIllegalArgumentException("Cannot exit stage with 'complete' event type as the stage '" + this.planItemInstanceEntity.getId() + "' is not yet completable. The plan item '" + completionEvaluationResult.getPlanItemInstance().getName() + " (" + completionEvaluationResult.getPlanItemInstance().getPlanItemDefinitionId() + ")' prevented it from completion.");
            }
            this.exitChildPlanItemInstances("exit", this.exitCriterionId, this.exitEventType);
        }
        this.planItemInstanceEntity.setExitCriterionId(this.exitCriterionId);
        this.planItemInstanceEntity.setEndedTime(this.getCurrentTime(this.commandContext));
        if (this.isStage() && ("complete".equals(this.exitEventType) || "forceComplete".equals(this.exitEventType))) {
            this.planItemInstanceEntity.setCompletedTime(this.planItemInstanceEntity.getEndedTime());
            CommandContextUtil.getCmmnHistoryManager(this.commandContext).recordPlanItemInstanceCompleted(this.planItemInstanceEntity);
        } else {
            this.planItemInstanceEntity.setExitTime(this.planItemInstanceEntity.getEndedTime());
            CommandContextUtil.getCmmnHistoryManager(this.commandContext).recordPlanItemInstanceExit(this.planItemInstanceEntity);
        }
    }

    @Override
    public boolean isEvaluateRepetitionRule() {
        return ("activeInstances".equals(this.exitType) || "activeAndEnabledInstances".equals(this.exitType)) && "terminated".equals(this.getNewState());
    }

    @Override
    protected boolean shouldAggregateForSingleInstance() {
        return false;
    }

    @Override
    protected boolean shouldAggregateForMultipleInstances() {
        return false;
    }

    public boolean isStage() {
        if (this.isStage == null) {
            this.isStage = this.isStage(this.planItemInstanceEntity);
        }
        return this.isStage;
    }

    @Override
    public String getOperationName() {
        return "[Exit plan item]";
    }

    public String getExitCriterionId() {
        return this.exitCriterionId;
    }

    public void setExitCriterionId(String exitCriterionId) {
        this.exitCriterionId = exitCriterionId;
    }

    public String getExitType() {
        return this.exitType;
    }

    public void setExitType(String exitType) {
        this.exitType = exitType;
    }

    public String getExitEventType() {
        return this.exitEventType;
    }

    public void setExitEventType(String exitEventType) {
        this.exitEventType = exitEventType;
    }

    public Boolean getStage() {
        return this.isStage;
    }

    public void setStage(Boolean stage) {
        this.isStage = stage;
    }
}

