/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseDefinitionEntity;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntity;

public class AddIdentityLinkForCaseDefinitionCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected CmmnEngineConfiguration cmmnEngineConfiguration;
    protected String caseDefinitionId;
    protected String userId;
    protected String groupId;

    public AddIdentityLinkForCaseDefinitionCmd(String caseDefinitionId, String userId, String groupId, CmmnEngineConfiguration cmmnEngineConfiguration) {
        this.validateParams(userId, groupId, caseDefinitionId);
        this.caseDefinitionId = caseDefinitionId;
        this.userId = userId;
        this.groupId = groupId;
        this.cmmnEngineConfiguration = cmmnEngineConfiguration;
    }

    protected void validateParams(String userId, String groupId, String caseDefinitionId) {
        if (caseDefinitionId == null) {
            throw new FlowableIllegalArgumentException("caseDefinitionId is null");
        }
        if (userId == null && groupId == null) {
            throw new FlowableIllegalArgumentException("userId and groupId cannot both be null");
        }
    }

    public Void execute(CommandContext commandContext) {
        CaseDefinitionEntity caseDefinition = (CaseDefinitionEntity)this.cmmnEngineConfiguration.getCaseDefinitionEntityManager().findById(this.caseDefinitionId);
        if (caseDefinition == null) {
            throw new FlowableObjectNotFoundException("Cannot find case definition with id " + this.caseDefinitionId, CaseDefinition.class);
        }
        IdentityLinkEntity identityLinkEntity = this.cmmnEngineConfiguration.getIdentityLinkServiceConfiguration().getIdentityLinkService().createScopeDefinitionIdentityLink(caseDefinition.getId(), "cmmn", this.userId, this.groupId);
        caseDefinition.getIdentityLinks().add(identityLinkEntity);
        return null;
    }
}

