/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.io.InputStream;
import java.io.Serializable;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.engine.impl.cmd.GetDeploymentResourceCmd;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetDeploymentCaseDiagramCmd
implements Command<InputStream>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(GetDeploymentCaseDiagramCmd.class);
    protected String caseDefinitionId;

    public GetDeploymentCaseDiagramCmd(String caseDefinitionId) {
        if (caseDefinitionId == null || caseDefinitionId.length() == 0) {
            throw new FlowableIllegalArgumentException("The case definition id is mandatory, but '" + caseDefinitionId + "' has been provided.");
        }
        this.caseDefinitionId = caseDefinitionId;
    }

    public InputStream execute(CommandContext commandContext) {
        CaseDefinition caseDefinition = CommandContextUtil.getCmmnEngineConfiguration(commandContext).getDeploymentManager().findDeployedCaseDefinitionById(this.caseDefinitionId);
        String deploymentId = caseDefinition.getDeploymentId();
        String resourceName = caseDefinition.getDiagramResourceName();
        if (resourceName == null) {
            LOGGER.info("Resource name is null! No case diagram stream exists.");
            return null;
        }
        InputStream caseDiagramStream = new GetDeploymentResourceCmd(deploymentId, resourceName).execute(commandContext);
        return caseDiagramStream;
    }
}

