/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.history.async.json.transformer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import java.util.List;
import org.flowable.cmmn.api.history.HistoricPlanItemInstance;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.history.HistoricPlanItemInstanceQueryImpl;
import org.flowable.cmmn.engine.impl.history.async.json.transformer.AbstractNeedsHistoricCaseInstanceJsonTransformer;
import org.flowable.cmmn.engine.impl.persistence.entity.HistoricCaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.HistoricCaseInstanceEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.HistoricPlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.HistoricPlanItemInstanceEntityManager;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.service.impl.history.async.util.AsyncHistoryJsonUtil;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.service.HistoricTaskService;
import org.flowable.task.service.impl.HistoricTaskInstanceQueryImpl;
import org.flowable.task.service.impl.persistence.entity.HistoricTaskInstanceEntity;

public class UpdateCaseDefinitionCascadeHistoryJsonTransformer
extends AbstractNeedsHistoricCaseInstanceJsonTransformer {
    public UpdateCaseDefinitionCascadeHistoryJsonTransformer(CmmnEngineConfiguration cmmnEngineConfiguration) {
        super(cmmnEngineConfiguration);
    }

    public List<String> getTypes() {
        return Collections.singletonList("cmmn-update-case-definition-cascade");
    }

    public void transformJson(HistoryJobEntity job, ObjectNode historicalData, CommandContext commandContext) {
        String caseDefinitionId = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"caseDefinitionId");
        String caseInstanceId = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"caseInstanceId");
        HistoricCaseInstanceEntityManager historicCaseInstanceEntityManager = this.cmmnEngineConfiguration.getHistoricCaseInstanceEntityManager();
        HistoricCaseInstanceEntity historicCaseInstance = (HistoricCaseInstanceEntity)historicCaseInstanceEntityManager.findById(caseInstanceId);
        historicCaseInstance.setCaseDefinitionId(caseDefinitionId);
        historicCaseInstanceEntityManager.update(historicCaseInstance);
        HistoricTaskService historicTaskService = this.cmmnEngineConfiguration.getTaskServiceConfiguration().getHistoricTaskService();
        HistoricTaskInstanceQueryImpl taskQuery = new HistoricTaskInstanceQueryImpl();
        taskQuery.caseInstanceId(caseInstanceId);
        List historicTasks = historicTaskService.findHistoricTaskInstancesByQueryCriteria(taskQuery);
        if (historicTasks != null) {
            for (HistoricTaskInstance historicTaskInstance : historicTasks) {
                HistoricTaskInstanceEntity taskEntity = (HistoricTaskInstanceEntity)historicTaskInstance;
                taskEntity.setScopeDefinitionId(caseDefinitionId);
                historicTaskService.updateHistoricTask(taskEntity, true);
            }
        }
        HistoricPlanItemInstanceQueryImpl historicPlanItemQuery = new HistoricPlanItemInstanceQueryImpl();
        historicPlanItemQuery.planItemInstanceCaseInstanceId(caseInstanceId);
        HistoricPlanItemInstanceEntityManager historicPlanItemInstanceEntityManager = this.cmmnEngineConfiguration.getHistoricPlanItemInstanceEntityManager();
        List<HistoricPlanItemInstance> historicPlanItems = historicPlanItemInstanceEntityManager.findByCriteria(historicPlanItemQuery);
        if (historicPlanItems != null) {
            for (HistoricPlanItemInstance historicPlanItemInstance : historicPlanItems) {
                HistoricPlanItemInstanceEntity planItemEntity = (HistoricPlanItemInstanceEntity)historicPlanItemInstance;
                planItemEntity.setCaseDefinitionId(caseDefinitionId);
                historicPlanItemInstanceEntityManager.update(planItemEntity);
            }
        }
    }
}

