/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.flowable.cmmn.api.migration.ActivatePlanItemDefinitionMapping;
import org.flowable.cmmn.api.migration.MoveToAvailablePlanItemDefinitionMapping;
import org.flowable.cmmn.api.migration.RemoveWaitingForRepetitionPlanItemDefinitionMapping;
import org.flowable.cmmn.api.migration.TerminatePlanItemDefinitionMapping;
import org.flowable.cmmn.api.migration.WaitingForRepetitionPlanItemDefinitionMapping;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.api.runtime.PlanItemInstanceState;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;

public class CaseInstanceChangeState {
    protected String caseInstanceId;
    protected CaseDefinition caseDefinitionToMigrateTo;
    protected Map<String, Object> caseVariables = new HashMap<String, Object>();
    protected Map<String, List<PlanItemInstanceEntity>> currentPlanItemInstances;
    protected Set<ActivatePlanItemDefinitionMapping> activatePlanItemDefinitions;
    protected Set<MoveToAvailablePlanItemDefinitionMapping> changePlanItemToAvailables;
    protected Set<TerminatePlanItemDefinitionMapping> terminatePlanItemDefinitions;
    protected Set<WaitingForRepetitionPlanItemDefinitionMapping> waitingForRepetitionPlanItemDefinitions;
    protected Set<RemoveWaitingForRepetitionPlanItemDefinitionMapping> removeWaitingForRepetitionPlanItemDefinitions;
    protected Map<String, Map<String, Object>> childInstanceTaskVariables = new HashMap<String, Map<String, Object>>();
    protected Map<String, PlanItemInstanceEntity> createdStageInstances = new HashMap<String, PlanItemInstanceEntity>();
    protected Map<String, PlanItemInstanceEntity> terminatedPlanItemInstances = new HashMap<String, PlanItemInstanceEntity>();

    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public CaseInstanceChangeState setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
        return this;
    }

    public CaseDefinition getCaseDefinitionToMigrateTo() {
        return this.caseDefinitionToMigrateTo;
    }

    public CaseInstanceChangeState setCaseDefinitionToMigrateTo(CaseDefinition caseDefinitionToMigrateTo) {
        this.caseDefinitionToMigrateTo = caseDefinitionToMigrateTo;
        return this;
    }

    public Map<String, Object> getCaseVariables() {
        return this.caseVariables;
    }

    public CaseInstanceChangeState setCaseVariables(Map<String, Object> caseVariables) {
        this.caseVariables = caseVariables;
        return this;
    }

    public Map<String, List<PlanItemInstanceEntity>> getCurrentPlanItemInstances() {
        return this.currentPlanItemInstances;
    }

    public void setCurrentPlanItemInstances(Map<String, List<PlanItemInstanceEntity>> currentPlanItemInstances) {
        this.currentPlanItemInstances = currentPlanItemInstances;
    }

    public PlanItemInstanceEntity getRuntimePlanItemInstance(String planItemDefinitionId) {
        if (this.currentPlanItemInstances != null && this.currentPlanItemInstances.containsKey(planItemDefinitionId)) {
            List<PlanItemInstanceEntity> currentPlanItemInstanceList = this.currentPlanItemInstances.get(planItemDefinitionId);
            for (PlanItemInstanceEntity planItemInstance : currentPlanItemInstanceList) {
                if (PlanItemInstanceState.TERMINAL_STATES.contains(planItemInstance.getState())) continue;
                return planItemInstance;
            }
        }
        return null;
    }

    public Map<String, List<PlanItemInstanceEntity>> getActivePlanItemInstances() {
        HashMap<String, List<PlanItemInstanceEntity>> activePlanItemInstanceMap = new HashMap<String, List<PlanItemInstanceEntity>>();
        if (this.currentPlanItemInstances != null) {
            for (String planItemDefinitionId : this.currentPlanItemInstances.keySet()) {
                List<PlanItemInstanceEntity> planItemInstances = this.currentPlanItemInstances.get(planItemDefinitionId);
                ArrayList<PlanItemInstanceEntity> activePlanItemInstances = null;
                for (PlanItemInstanceEntity planItemInstance : planItemInstances) {
                    if (!PlanItemInstanceState.ACTIVE_STATES.contains(planItemInstance.getState())) continue;
                    if (activePlanItemInstances == null) {
                        activePlanItemInstances = new ArrayList<PlanItemInstanceEntity>();
                    }
                    activePlanItemInstances.add(planItemInstance);
                }
                if (activePlanItemInstances == null) continue;
                activePlanItemInstanceMap.put(planItemDefinitionId, activePlanItemInstances);
            }
        }
        return activePlanItemInstanceMap;
    }

    public Map<String, List<PlanItemInstanceEntity>> getRuntimePlanItemInstances() {
        HashMap<String, List<PlanItemInstanceEntity>> runtimePlanItemInstanceMap = new HashMap<String, List<PlanItemInstanceEntity>>();
        if (this.currentPlanItemInstances != null) {
            for (String planItemDefinitionId : this.currentPlanItemInstances.keySet()) {
                List<PlanItemInstanceEntity> planItemInstances = this.currentPlanItemInstances.get(planItemDefinitionId);
                ArrayList<PlanItemInstanceEntity> runtimePlanItemInstances = null;
                for (PlanItemInstanceEntity planItemInstance : planItemInstances) {
                    if (PlanItemInstanceState.TERMINAL_STATES.contains(planItemInstance.getState())) continue;
                    if (runtimePlanItemInstances == null) {
                        runtimePlanItemInstances = new ArrayList<PlanItemInstanceEntity>();
                    }
                    runtimePlanItemInstances.add(planItemInstance);
                }
                if (runtimePlanItemInstances == null) continue;
                runtimePlanItemInstanceMap.put(planItemDefinitionId, runtimePlanItemInstances);
            }
        }
        return runtimePlanItemInstanceMap;
    }

    public Set<ActivatePlanItemDefinitionMapping> getActivatePlanItemDefinitions() {
        return this.activatePlanItemDefinitions;
    }

    public CaseInstanceChangeState setActivatePlanItemDefinitions(Set<ActivatePlanItemDefinitionMapping> planItemDefinitionMappings) {
        this.activatePlanItemDefinitions = planItemDefinitionMappings;
        return this;
    }

    public Set<MoveToAvailablePlanItemDefinitionMapping> getChangePlanItemDefinitionsToAvailable() {
        return this.changePlanItemToAvailables;
    }

    public CaseInstanceChangeState setChangePlanItemDefinitionsToAvailable(Set<MoveToAvailablePlanItemDefinitionMapping> planItemDefinitionMappings) {
        this.changePlanItemToAvailables = planItemDefinitionMappings;
        return this;
    }

    public Set<TerminatePlanItemDefinitionMapping> getTerminatePlanItemDefinitions() {
        return this.terminatePlanItemDefinitions;
    }

    public CaseInstanceChangeState setTerminatePlanItemDefinitions(Set<TerminatePlanItemDefinitionMapping> planItemDefinitionMappings) {
        this.terminatePlanItemDefinitions = planItemDefinitionMappings;
        return this;
    }

    public Set<WaitingForRepetitionPlanItemDefinitionMapping> getWaitingForRepetitionPlanItemDefinitions() {
        return this.waitingForRepetitionPlanItemDefinitions;
    }

    public CaseInstanceChangeState setWaitingForRepetitionPlanItemDefinitions(Set<WaitingForRepetitionPlanItemDefinitionMapping> waitingForRepetitionPlanItemDefinitions) {
        this.waitingForRepetitionPlanItemDefinitions = waitingForRepetitionPlanItemDefinitions;
        return this;
    }

    public Set<RemoveWaitingForRepetitionPlanItemDefinitionMapping> getRemoveWaitingForRepetitionPlanItemDefinitions() {
        return this.removeWaitingForRepetitionPlanItemDefinitions;
    }

    public CaseInstanceChangeState setRemoveWaitingForRepetitionPlanItemDefinitions(Set<RemoveWaitingForRepetitionPlanItemDefinitionMapping> removeWaitingForRepetitionPlanItemDefinitions) {
        this.removeWaitingForRepetitionPlanItemDefinitions = removeWaitingForRepetitionPlanItemDefinitions;
        return this;
    }

    public Map<String, Map<String, Object>> getChildInstanceTaskVariables() {
        return this.childInstanceTaskVariables;
    }

    public CaseInstanceChangeState setChildInstanceTaskVariables(Map<String, Map<String, Object>> childInstanceTaskVariables) {
        this.childInstanceTaskVariables = childInstanceTaskVariables;
        return this;
    }

    public Map<String, PlanItemInstanceEntity> getCreatedStageInstances() {
        return this.createdStageInstances;
    }

    public CaseInstanceChangeState setCreatedStageInstances(HashMap<String, PlanItemInstanceEntity> createdStageInstances) {
        this.createdStageInstances = createdStageInstances;
        return this;
    }

    public void addCreatedStageInstance(String key, PlanItemInstanceEntity planItemInstance) {
        this.createdStageInstances.put(key, planItemInstance);
    }

    public Map<String, PlanItemInstanceEntity> getTerminatedPlanItemInstances() {
        return this.terminatedPlanItemInstances;
    }

    public CaseInstanceChangeState setTerminatedPlanItemInstances(HashMap<String, PlanItemInstanceEntity> terminatedPlanItemInstances) {
        this.terminatedPlanItemInstances = terminatedPlanItemInstances;
        return this;
    }

    public void addTerminatedPlanItemInstance(String key, PlanItemInstanceEntity planItemInstance) {
        this.terminatedPlanItemInstances.put(key, planItemInstance);
    }
}

