/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.ExtensionElement;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.eventregistry.api.runtime.EventInstance;
import org.flowable.eventregistry.api.runtime.EventPayloadInstance;
import org.flowable.eventregistry.impl.runtime.EventPayloadInstanceImpl;
import org.flowable.eventregistry.model.EventModel;
import org.flowable.eventregistry.model.EventPayload;
import org.flowable.variable.api.delegate.VariableScope;

public class EventInstanceCmmnUtil {
    public static void handleEventInstanceOutParameters(VariableScope variableScope, BaseElement baseElement, EventInstance eventInstance) {
        List outParameters = baseElement.getExtensionElements().getOrDefault("eventOutParameter", Collections.emptyList());
        if (!outParameters.isEmpty()) {
            Map payloadInstances = eventInstance.getPayloadInstances().stream().collect(Collectors.toMap(EventPayloadInstance::getDefinitionName, Function.identity()));
            for (ExtensionElement outParameter : outParameters) {
                Object value;
                String payloadSourceName = outParameter.getAttributeValue(null, "source");
                EventPayloadInstance payloadInstance = (EventPayloadInstance)payloadInstances.get(payloadSourceName);
                String variableName = outParameter.getAttributeValue(null, "target");
                if (!StringUtils.isNotEmpty((CharSequence)variableName)) continue;
                Boolean isTransient = Boolean.valueOf(outParameter.getAttributeValue(null, "transient"));
                Object object = value = payloadInstance != null ? payloadInstance.getValue() : null;
                if (Boolean.TRUE.equals(isTransient)) {
                    variableScope.setTransientVariable(variableName, value);
                    continue;
                }
                variableScope.setVariable(variableName, value);
            }
        }
    }

    public static Collection<EventPayloadInstance> createEventPayloadInstances(VariableScope variableScope, ExpressionManager expressionManager, BaseElement baseElement, EventModel eventDefinition) {
        ArrayList<EventPayloadInstance> eventPayloadInstances = new ArrayList<EventPayloadInstance>();
        List inParameters = baseElement.getExtensionElements().getOrDefault("eventInParameter", Collections.emptyList());
        if (!inParameters.isEmpty()) {
            for (ExtensionElement inParameter : inParameters) {
                String source = inParameter.getAttributeValue(null, "source");
                String target = inParameter.getAttributeValue(null, "target");
                EventPayload eventPayloadDefinition = eventDefinition.getPayload(target);
                if (eventPayloadDefinition == null) continue;
                Expression sourceExpression = expressionManager.createExpression(source);
                Object value = sourceExpression.getValue((VariableContainer)variableScope);
                eventPayloadInstances.add((EventPayloadInstance)new EventPayloadInstanceImpl(eventPayloadDefinition, value));
            }
        }
        return eventPayloadInstances;
    }
}

