/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.util;

import java.util.HashMap;
import java.util.Map;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.engine.impl.agenda.PlanItemEvaluationResult;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceContainer;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.engine.impl.util.ExpressionUtil;
import org.flowable.cmmn.model.Criterion;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.RepetitionRule;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class PlanItemInstanceUtil {
    public static PlanItemInstanceEntity copyAndInsertPlanItemInstance(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntityToCopy, boolean addToParent, boolean silentNameExpressionEvaluation) {
        return PlanItemInstanceUtil.copyAndInsertPlanItemInstance(commandContext, planItemInstanceEntityToCopy, null, addToParent, silentNameExpressionEvaluation);
    }

    public static PlanItemInstanceEntity copyAndInsertPlanItemInstance(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntityToCopy, Map<String, Object> localVariables, boolean addToParent, boolean silentNameExpressionEvaluation) {
        PlanItemInstanceEntity stagePlanItem;
        if (ExpressionUtil.hasRepetitionRule(planItemInstanceEntityToCopy)) {
            int counter = PlanItemInstanceUtil.getRepetitionCounter(planItemInstanceEntityToCopy);
            if (localVariables == null) {
                localVariables = new HashMap<String, Object>(0);
            }
            localVariables.put(PlanItemInstanceUtil.getCounterVariable(planItemInstanceEntityToCopy), counter);
        }
        if ((stagePlanItem = planItemInstanceEntityToCopy.getStagePlanItemInstanceEntity()) == null && planItemInstanceEntityToCopy.getStageInstanceId() != null) {
            stagePlanItem = (PlanItemInstance)CommandContextUtil.getPlanItemInstanceEntityManager(commandContext).findById(planItemInstanceEntityToCopy.getStageInstanceId());
        }
        PlanItemInstanceEntity planItemInstanceEntity = CommandContextUtil.getPlanItemInstanceEntityManager(commandContext).createPlanItemInstanceEntityBuilder().planItem(planItemInstanceEntityToCopy.getPlanItem()).caseDefinitionId(planItemInstanceEntityToCopy.getCaseDefinitionId()).caseInstanceId(planItemInstanceEntityToCopy.getCaseInstanceId()).stagePlanItemInstance((PlanItemInstance)stagePlanItem).tenantId(planItemInstanceEntityToCopy.getTenantId()).localVariables(localVariables).addToParent(addToParent).silentNameExpressionEvaluation(silentNameExpressionEvaluation).create();
        return planItemInstanceEntity;
    }

    public static boolean evaluateRepetitionRule(PlanItemInstanceEntity planItemInstanceEntity, Criterion satisfiedEntryCriterion, PlanItemInstanceContainer planItemInstanceContainer, PlanItemEvaluationResult evaluationResult, CommandContext commandContext) {
        PlanItem planItem = planItemInstanceEntity.getPlanItem();
        boolean activatePlanItemInstance = true;
        if (ExpressionUtil.hasRepetitionRule(planItemInstanceEntity)) {
            boolean noEntryCriteria = planItem.getEntryCriteria().isEmpty();
            if (ExpressionUtil.hasRepetitionOnCollection(planItemInstanceEntity)) {
                Iterable<Object> collection = ExpressionUtil.evaluateRepetitionCollectionVariableValue(commandContext, planItemInstanceEntity);
                if (collection == null && !ExpressionUtil.hasOnParts(planItem)) {
                    activatePlanItemInstance = false;
                } else {
                    if (collection != null) {
                        RepetitionRule repetitionRule = ExpressionUtil.getRepetitionRule(planItemInstanceEntity);
                        int index = 0;
                        for (Object item : collection) {
                            PlanItemInstanceEntity childPlanItemInstanceEntity = PlanItemInstanceUtil.createPlanItemInstanceDuplicateForCollectionRepetition(repetitionRule, planItemInstanceEntity, null, item, index++, commandContext);
                            evaluationResult.addChildPlanItemInstance(childPlanItemInstanceEntity);
                        }
                    }
                    CommandContextUtil.getPlanItemInstanceEntityManager(commandContext).deleteSentryRelatedData(planItemInstanceEntity.getId());
                    activatePlanItemInstance = false;
                    if (!ExpressionUtil.hasOnParts(planItem)) {
                        CommandContextUtil.getAgenda(commandContext).planTerminatePlanItemInstanceOperation(planItemInstanceEntity, null, null);
                    }
                }
            } else if (!noEntryCriteria) {
                if (ExpressionUtil.evaluateRepetitionRule(commandContext, planItemInstanceEntity, planItemInstanceContainer)) {
                    evaluationResult.addChildPlanItemInstance(PlanItemInstanceUtil.createPlanItemInstanceDuplicateForRepetition(planItemInstanceEntity, commandContext));
                } else {
                    activatePlanItemInstance = false;
                }
            }
        }
        return activatePlanItemInstance;
    }

    public static PlanItemInstanceEntity createPlanItemInstanceDuplicateForRepetition(PlanItemInstanceEntity planItemInstanceEntity, CommandContext commandContext) {
        PlanItemInstanceEntity childPlanItemInstanceEntity = PlanItemInstanceUtil.copyAndInsertPlanItemInstance(commandContext, planItemInstanceEntity, false, false);
        CommandContextUtil.getAgenda(commandContext).planCreatePlanItemInstanceForRepetitionOperation(childPlanItemInstanceEntity);
        return childPlanItemInstanceEntity;
    }

    public static int getRepetitionCounter(PlanItemInstanceEntity repeatingPlanItemInstanceEntity) {
        Integer counter = (Integer)repeatingPlanItemInstanceEntity.getVariableLocal(PlanItemInstanceUtil.getCounterVariable(repeatingPlanItemInstanceEntity));
        if (counter == null) {
            return 0;
        }
        return counter;
    }

    public static String getCounterVariable(PlanItemInstanceEntity repeatingPlanItemInstanceEntity) {
        String repetitionCounterVariableName = repeatingPlanItemInstanceEntity.getPlanItem().getItemControl().getRepetitionRule().getRepetitionCounterVariableName();
        return repetitionCounterVariableName;
    }

    protected static PlanItemInstanceEntity createPlanItemInstanceDuplicateForCollectionRepetition(RepetitionRule repetitionRule, PlanItemInstanceEntity planItemInstanceEntity, String entryCriterionId, Object item, int index, CommandContext commandContext) {
        HashMap<String, Object> localVariables = new HashMap<String, Object>(2);
        if (repetitionRule.hasElementVariable()) {
            localVariables.put(repetitionRule.getElementVariableName(), item);
        }
        if (repetitionRule.hasElementIndexVariable()) {
            localVariables.put(repetitionRule.getElementIndexVariableName(), index);
        }
        PlanItemInstanceEntity childPlanItemInstanceEntity = PlanItemInstanceUtil.copyAndInsertPlanItemInstance(commandContext, planItemInstanceEntity, localVariables, false, false);
        CommandContextUtil.getAgenda(commandContext).planCreateRepeatedPlanItemInstanceOperation(childPlanItemInstanceEntity);
        childPlanItemInstanceEntity.setVariableLocal(PlanItemInstanceUtil.getCounterVariable(childPlanItemInstanceEntity), index + 1);
        CommandContextUtil.getAgenda(commandContext).planActivatePlanItemInstanceOperation(childPlanItemInstanceEntity, entryCriterionId);
        return childPlanItemInstanceEntity;
    }
}

