/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.agenda.operation;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.engine.impl.agenda.PlanItemEvaluationResult;
import org.flowable.cmmn.engine.impl.agenda.operation.PlanItemCreationType;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceContainer;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.repository.CaseDefinitionUtil;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.engine.impl.util.ExpressionUtil;
import org.flowable.cmmn.engine.impl.util.PlanItemInstanceUtil;
import org.flowable.cmmn.model.Case;
import org.flowable.cmmn.model.EventListener;
import org.flowable.cmmn.model.PlanFragment;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.PlanItemControl;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.cmmn.model.ReactivationRule;
import org.flowable.cmmn.model.Stage;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public abstract class CmmnOperation
implements Runnable {
    protected CommandContext commandContext;
    protected boolean isNoop = false;

    public CmmnOperation() {
    }

    public CmmnOperation(CommandContext commandContext) {
        this.commandContext = commandContext;
    }

    public abstract String getCaseInstanceId();

    protected CaseInstanceEntity getCaseInstance() {
        String caseId = this.getCaseInstanceId();
        if (caseId == null) {
            return null;
        }
        return (CaseInstanceEntity)CommandContextUtil.getCaseInstanceEntityManager(this.commandContext).findById(caseId);
    }

    protected Stage getStage(PlanItemInstanceEntity planItemInstanceEntity) {
        PlanItemDefinition planItemDefinition = planItemInstanceEntity.getPlanItem().getPlanItemDefinition();
        if (planItemDefinition instanceof Stage) {
            return (Stage)planItemDefinition;
        }
        return planItemDefinition.getParentStage();
    }

    public boolean isStage(PlanItemInstanceEntity planItemInstanceEntity) {
        return planItemInstanceEntity.getPlanItem() != null && planItemInstanceEntity.getPlanItem().getPlanItemDefinition() != null && planItemInstanceEntity.getPlanItem().getPlanItemDefinition() instanceof Stage;
    }

    public Stage getPlanModel(CaseInstanceEntity caseInstanceEntity) {
        return CaseDefinitionUtil.getCase(caseInstanceEntity.getCaseDefinitionId()).getPlanModel();
    }

    protected List<PlanItemInstanceEntity> createPlanItemInstancesForNewOrReactivatedStage(CommandContext commandContext, Case caseModel, List<PlanItem> planItems, List<PlanItem> directlyReactivatedPlanItems, CaseInstanceEntity caseInstanceEntity, PlanItemInstanceEntity stagePlanItemInstanceEntity, String tenantId) {
        ArrayList<PlanItemInstanceEntity> newPlanItemInstances = new ArrayList<PlanItemInstanceEntity>();
        for (PlanItem planItem : planItems) {
            if (planItem.isInstanceLifecycleEnabled()) {
                if (directlyReactivatedPlanItems != null && !directlyReactivatedPlanItems.stream().noneMatch(i -> i.getId().equals(planItem.getId()))) continue;
                this.createPlanItemInstanceIfNeeded(commandContext, planItem, caseModel, caseInstanceEntity, stagePlanItemInstanceEntity, tenantId, newPlanItemInstances);
                continue;
            }
            if (planItem.getPlanItemDefinition() == null || !(planItem.getPlanItemDefinition() instanceof PlanFragment)) continue;
            PlanFragment planFragment = (PlanFragment)planItem.getPlanItemDefinition();
            List planFragmentPlanItems = planFragment.getDirectChildPlanItemsWithLifecycleEnabled();
            for (PlanItem planFragmentPlanItem : planFragmentPlanItems) {
                this.createPlanItemInstanceIfNeeded(commandContext, planFragmentPlanItem, caseModel, caseInstanceEntity, stagePlanItemInstanceEntity, tenantId, newPlanItemInstances);
            }
        }
        return newPlanItemInstances;
    }

    protected void createPlanItemInstanceIfNeeded(CommandContext commandContext, PlanItem planItem, Case caseModel, CaseInstanceEntity caseInstanceEntity, PlanItemInstanceEntity stagePlanItemInstanceEntity, String tenantId, List<PlanItemInstanceEntity> newPlanItemInstances) {
        PlanItemCreationType creationType;
        if (!(stagePlanItemInstanceEntity != null && this.childPlanItemInstanceForPlanItemExists(stagePlanItemInstanceEntity, planItem) || (creationType = this.getPlanItemCreationOrReactivationType(caseInstanceEntity, caseModel, planItem, (VariableContainer)stagePlanItemInstanceEntity)).isTypeIgnore())) {
            String caseInstanceId = null;
            if (caseInstanceEntity != null) {
                caseInstanceId = caseInstanceEntity.getId();
            } else if (stagePlanItemInstanceEntity != null) {
                caseInstanceId = stagePlanItemInstanceEntity.getCaseInstanceId();
            }
            PlanItemInstanceEntity childPlanItemInstance = CommandContextUtil.getPlanItemInstanceEntityManager(commandContext).createPlanItemInstanceEntityBuilder().planItem(planItem).caseDefinitionId(caseInstanceEntity.getCaseDefinitionId()).caseInstanceId(caseInstanceId).stagePlanItemInstance((PlanItemInstance)stagePlanItemInstanceEntity).tenantId(tenantId).addToParent(true).silentNameExpressionEvaluation(ExpressionUtil.hasRepetitionOnCollection(planItem)).create();
            PlanItemEvaluationResult evaluationResult = null;
            if (creationType.isTypeActivate()) {
                evaluationResult = new PlanItemEvaluationResult();
                PlanItemInstanceUtil.evaluateRepetitionRule(childPlanItemInstance, null, stagePlanItemInstanceEntity, evaluationResult, commandContext);
            }
            newPlanItemInstances.add(childPlanItemInstance);
            if (creationType.isTypeActivate() && evaluationResult.getNewChildPlanItemInstances() != null && !evaluationResult.getNewChildPlanItemInstances().isEmpty()) {
                newPlanItemInstances.addAll(evaluationResult.getNewChildPlanItemInstances());
            }
            CommandContextUtil.getAgenda(commandContext).planCreatePlanItemInstanceOperation(childPlanItemInstance);
            if (creationType.isTypeActivate()) {
                CommandContextUtil.getAgenda(commandContext).planActivatePlanItemInstanceOperation(childPlanItemInstance, null);
            }
        }
    }

    protected boolean childPlanItemInstanceForPlanItemExists(PlanItemInstanceContainer planItemInstanceContainer, PlanItem planItem) {
        List<PlanItemInstanceEntity> childPlanItemInstances = planItemInstanceContainer.getChildPlanItemInstances();
        if (childPlanItemInstances != null && !childPlanItemInstances.isEmpty()) {
            for (PlanItemInstanceEntity childPlanItemInstanceEntity : childPlanItemInstances) {
                if (childPlanItemInstanceEntity.getPlanItem() == null || !planItem.getId().equals(childPlanItemInstanceEntity.getPlanItem().getId())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isEventListenerWithAvailableCondition(PlanItem planItem) {
        if (planItem != null && planItem.getPlanItemDefinition() != null && planItem.getPlanItemDefinition() instanceof EventListener) {
            EventListener eventListener = (EventListener)planItem.getPlanItemDefinition();
            return StringUtils.isNotEmpty((CharSequence)eventListener.getAvailableConditionExpression());
        }
        return false;
    }

    protected void setRepetitionCounter(PlanItemInstanceEntity repeatingPlanItemInstanceEntity, int counterValue) {
        repeatingPlanItemInstanceEntity.setVariableLocal(PlanItemInstanceUtil.getCounterVariable(repeatingPlanItemInstanceEntity), counterValue);
    }

    protected PlanItemCreationType getPlanItemCreationOrReactivationType(CaseInstanceEntity caseInstanceEntity, Case caseModel, PlanItem planItem, VariableContainer parentPlanItemInstance) {
        PlanItemCreationType creationType;
        if (caseInstanceEntity.getLastReactivationTime() == null) {
            return PlanItemCreationType.typeDefault();
        }
        PlanItemControl itemControl = planItem.getItemControl();
        if (itemControl != null && itemControl.getReactivationRule() != null && (creationType = this.evaluateReactivationRule(itemControl.getReactivationRule(), caseInstanceEntity, parentPlanItemInstance)) != null) {
            return creationType;
        }
        if (caseModel.getReactivateEventListener() != null && caseModel.getReactivateEventListener().getDefaultReactivationRule() != null && (creationType = this.evaluateReactivationRule(caseModel.getReactivateEventListener().getDefaultReactivationRule(), caseInstanceEntity, parentPlanItemInstance)) != null) {
            return creationType;
        }
        return PlanItemCreationType.typeDefault();
    }

    protected PlanItemCreationType evaluateReactivationRule(ReactivationRule reactivationRule, CaseInstanceEntity caseInstanceEntity, VariableContainer parentPlanItemInstance) {
        Boolean condition = this.evaluateReactivationCondition(reactivationRule.getActivateCondition(), caseInstanceEntity, parentPlanItemInstance);
        if (condition != null && condition.booleanValue()) {
            return PlanItemCreationType.typeActivate();
        }
        condition = this.evaluateReactivationCondition(reactivationRule.getIgnoreCondition(), caseInstanceEntity, parentPlanItemInstance);
        if (condition != null && condition.booleanValue()) {
            return PlanItemCreationType.typeIgnore();
        }
        condition = this.evaluateReactivationCondition(reactivationRule.getDefaultCondition(), caseInstanceEntity, parentPlanItemInstance);
        if (condition != null) {
            if (condition.booleanValue()) {
                return PlanItemCreationType.typeDefault();
            }
            return PlanItemCreationType.typeIgnore();
        }
        return null;
    }

    protected Boolean evaluateReactivationCondition(String condition, CaseInstanceEntity caseInstanceEntity, VariableContainer parentPlanItemInstance) {
        if (StringUtils.isEmpty((CharSequence)condition)) {
            return null;
        }
        if (Boolean.parseBoolean(condition)) {
            return true;
        }
        return ExpressionUtil.evaluateBooleanExpression(this.commandContext, (VariableContainer)(parentPlanItemInstance == null ? caseInstanceEntity : parentPlanItemInstance), condition);
    }

    public void markAsNoop() {
        this.isNoop = true;
    }

    public boolean isNoop() {
        return this.isNoop;
    }
}

