/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.identitylink.api.IdentityLink;

public class GetIdentityLinksForPlanItemInstanceCmd
implements Command<List<IdentityLink>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String planItemInstanceId;

    public GetIdentityLinksForPlanItemInstanceCmd(String planItemInstanceId) {
        this.planItemInstanceId = planItemInstanceId;
    }

    public List<IdentityLink> execute(CommandContext commandContext) {
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        PlanItemInstance planItemInstance = (PlanItemInstance)cmmnEngineConfiguration.getPlanItemInstanceEntityManager().findById(this.planItemInstanceId);
        if (planItemInstance == null) {
            throw new FlowableObjectNotFoundException("Cannot find plan item instance with id " + this.planItemInstanceId, PlanItemInstanceEntity.class);
        }
        return cmmnEngineConfiguration.getIdentityLinkServiceConfiguration().getIdentityLinkService().findIdentityLinksBySubScopeIdAndType(this.planItemInstanceId, "planItem");
    }
}

