/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.io.Serializable;
import java.util.Objects;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.cmd.AbstractCaseStartEventSubscriptionCmd;
import org.flowable.cmmn.engine.impl.runtime.CaseInstanceStartEventSubscriptionBuilderImpl;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.Case;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.eventsubscription.api.EventSubscription;
import org.flowable.eventsubscription.api.EventSubscriptionBuilder;
import org.flowable.eventsubscription.service.EventSubscriptionService;

public class RegisterCaseInstanceStartEventSubscriptionCmd
extends AbstractCaseStartEventSubscriptionCmd
implements Command<EventSubscription>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final CaseInstanceStartEventSubscriptionBuilderImpl builder;

    public RegisterCaseInstanceStartEventSubscriptionCmd(CaseInstanceStartEventSubscriptionBuilderImpl builder) {
        this.builder = builder;
    }

    public EventSubscription execute(CommandContext commandContext) {
        CaseDefinition caseDefinition = this.getLatestCaseDefinitionByKey(this.builder.getCaseDefinitionKey(), this.builder.getTenantId(), commandContext);
        Case caze = this.getCase(caseDefinition.getId(), commandContext);
        EventSubscription eventSubscription = null;
        String eventDefinitionKey = caze.getStartEventType();
        String startCorrelationConfiguration = this.getStartCorrelationConfiguration(caseDefinition.getId(), commandContext);
        if (eventDefinitionKey != null && Objects.equals(startCorrelationConfiguration, "manualSubscription")) {
            String correlationKey = this.generateCorrelationConfiguration(eventDefinitionKey, this.builder.getTenantId(), this.builder.getCorrelationParameterValues(), commandContext);
            eventSubscription = this.insertEventRegistryEvent(eventDefinitionKey, this.builder.isDoNotUpdateToLatestVersionAutomatically(), caseDefinition, correlationKey, commandContext);
        }
        if (eventSubscription == null) {
            throw new FlowableIllegalArgumentException("The case definition with id '" + caseDefinition.getId() + "' does not have an event-registry based start event with a manual subscription behavior.");
        }
        return eventSubscription;
    }

    protected EventSubscription insertEventRegistryEvent(String eventDefinitionKey, boolean doNotUpdateToLatestVersionAutomatically, CaseDefinition caseDefinition, String correlationKey, CommandContext commandContext) {
        CmmnEngineConfiguration caseEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        EventSubscriptionService eventSubscriptionService = caseEngineConfiguration.getEventSubscriptionServiceConfiguration().getEventSubscriptionService();
        EventSubscriptionBuilder eventSubscriptionBuilder = eventSubscriptionService.createEventSubscriptionBuilder().eventType(eventDefinitionKey).scopeDefinitionId(caseDefinition.getId()).scopeType("cmmn").configuration(correlationKey);
        if (caseDefinition.getTenantId() != null) {
            eventSubscriptionBuilder.tenantId(caseDefinition.getTenantId());
        }
        if (!doNotUpdateToLatestVersionAutomatically) {
            eventSubscriptionBuilder.scopeDefinitionKey(caseDefinition.getKey());
        }
        return eventSubscriptionBuilder.create();
    }
}

