/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.parser;

import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.engine.impl.behavior.CmmnActivityBehavior;
import org.flowable.cmmn.engine.impl.behavior.impl.CasePageTaskActivityBehaviour;
import org.flowable.cmmn.engine.impl.behavior.impl.CaseTaskActivityBehavior;
import org.flowable.cmmn.engine.impl.behavior.impl.DecisionTaskActivityBehavior;
import org.flowable.cmmn.engine.impl.behavior.impl.EventRegistryEventListenerActivityBehaviour;
import org.flowable.cmmn.engine.impl.behavior.impl.ExternalWorkerTaskActivityBehavior;
import org.flowable.cmmn.engine.impl.behavior.impl.GenericEventListenerActivityBehaviour;
import org.flowable.cmmn.engine.impl.behavior.impl.HumanTaskActivityBehavior;
import org.flowable.cmmn.engine.impl.behavior.impl.MilestoneActivityBehavior;
import org.flowable.cmmn.engine.impl.behavior.impl.PlanItemDelegateExpressionActivityBehavior;
import org.flowable.cmmn.engine.impl.behavior.impl.PlanItemExpressionActivityBehavior;
import org.flowable.cmmn.engine.impl.behavior.impl.ProcessTaskActivityBehavior;
import org.flowable.cmmn.engine.impl.behavior.impl.ScriptTaskActivityBehavior;
import org.flowable.cmmn.engine.impl.behavior.impl.SendEventActivityBehavior;
import org.flowable.cmmn.engine.impl.behavior.impl.SignalEventListenerActivityBehaviour;
import org.flowable.cmmn.engine.impl.behavior.impl.StageActivityBehavior;
import org.flowable.cmmn.engine.impl.behavior.impl.TaskActivityBehavior;
import org.flowable.cmmn.engine.impl.behavior.impl.TimerEventListenerActivityBehaviour;
import org.flowable.cmmn.engine.impl.behavior.impl.UserEventListenerActivityBehaviour;
import org.flowable.cmmn.engine.impl.behavior.impl.VariableEventListenerActivityBehaviour;
import org.flowable.cmmn.engine.impl.behavior.impl.http.DefaultCmmnHttpActivityDelegate;
import org.flowable.cmmn.engine.impl.behavior.impl.mail.CmmnMailActivityDelegate;
import org.flowable.cmmn.engine.impl.delegate.CmmnClassDelegate;
import org.flowable.cmmn.engine.impl.delegate.CmmnClassDelegateFactory;
import org.flowable.cmmn.engine.impl.parser.CmmnActivityBehaviorFactory;
import org.flowable.cmmn.model.CasePageTask;
import org.flowable.cmmn.model.CaseTask;
import org.flowable.cmmn.model.DecisionTask;
import org.flowable.cmmn.model.ExternalWorkerServiceTask;
import org.flowable.cmmn.model.FieldExtension;
import org.flowable.cmmn.model.GenericEventListener;
import org.flowable.cmmn.model.HumanTask;
import org.flowable.cmmn.model.Milestone;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.ProcessTask;
import org.flowable.cmmn.model.ScriptServiceTask;
import org.flowable.cmmn.model.SendEventServiceTask;
import org.flowable.cmmn.model.ServiceTask;
import org.flowable.cmmn.model.SignalEventListener;
import org.flowable.cmmn.model.Stage;
import org.flowable.cmmn.model.Task;
import org.flowable.cmmn.model.TimerEventListener;
import org.flowable.cmmn.model.UserEventListener;
import org.flowable.cmmn.model.VariableEventListener;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.impl.el.ExpressionManager;

public class DefaultCmmnActivityBehaviorFactory
implements CmmnActivityBehaviorFactory {
    protected CmmnClassDelegateFactory classDelegateFactory;
    protected ExpressionManager expressionManager;

    @Override
    public StageActivityBehavior createStageActivityBehavior(PlanItem planItem, Stage stage) {
        return new StageActivityBehavior(stage);
    }

    @Override
    public MilestoneActivityBehavior createMilestoneActivityBehavior(PlanItem planItem, Milestone milestone) {
        String name = null;
        if (!StringUtils.isEmpty((CharSequence)planItem.getName())) {
            name = planItem.getName();
        } else if (StringUtils.isNotEmpty((CharSequence)milestone.getName())) {
            name = milestone.getName();
        }
        return new MilestoneActivityBehavior(this.expressionManager.createExpression(name), milestone.getMilestoneVariable(), milestone.getBusinessStatus());
    }

    @Override
    public TaskActivityBehavior createTaskActivityBehavior(PlanItem planItem, Task task) {
        return new TaskActivityBehavior(task.isBlocking(), task.getBlockingExpression());
    }

    @Override
    public HumanTaskActivityBehavior createHumanTaskActivityBehavior(PlanItem planItem, HumanTask humanTask) {
        return new HumanTaskActivityBehavior(humanTask);
    }

    @Override
    public CaseTaskActivityBehavior createCaseTaskActivityBehavior(PlanItem planItem, CaseTask caseTask) {
        Expression caseRefExpression = this.createExpression(caseTask.getCaseRefExpression());
        return new CaseTaskActivityBehavior(caseRefExpression, caseTask);
    }

    @Override
    public ProcessTaskActivityBehavior createProcessTaskActivityBehavior(PlanItem planItem, ProcessTask processTask) {
        Expression processRefExpression = this.createExpression(processTask.getProcessRefExpression());
        return new ProcessTaskActivityBehavior(processTask.getProcess(), processRefExpression, processTask);
    }

    @Override
    public CmmnClassDelegate createCmmnClassDelegate(PlanItem planItem, ServiceTask task) {
        return this.classDelegateFactory.create(task.getImplementation(), task.getFieldExtensions());
    }

    @Override
    public PlanItemExpressionActivityBehavior createPlanItemExpressionActivityBehavior(PlanItem planItem, ServiceTask task) {
        return new PlanItemExpressionActivityBehavior(task.getImplementation(), task.getResultVariableName(), task.isStoreResultVariableAsTransient());
    }

    @Override
    public PlanItemDelegateExpressionActivityBehavior createPlanItemDelegateExpressionActivityBehavior(PlanItem planItem, ServiceTask task) {
        return new PlanItemDelegateExpressionActivityBehavior(task.getImplementation(), task.getFieldExtensions());
    }

    @Override
    public TimerEventListenerActivityBehaviour createTimerEventListenerActivityBehavior(PlanItem planItem, TimerEventListener timerEventListener) {
        return new TimerEventListenerActivityBehaviour(timerEventListener);
    }

    @Override
    public UserEventListenerActivityBehaviour createUserEventListenerActivityBehavior(PlanItem planItem, UserEventListener userEventListener) {
        return new UserEventListenerActivityBehaviour(userEventListener);
    }

    @Override
    public SignalEventListenerActivityBehaviour createSignalEventListenerActivityBehavior(PlanItem planItem, SignalEventListener signalEventListener) {
        return new SignalEventListenerActivityBehaviour(signalEventListener);
    }

    @Override
    public GenericEventListenerActivityBehaviour createGenericEventListenerActivityBehavior(PlanItem planItem, GenericEventListener genericEventListener) {
        return new GenericEventListenerActivityBehaviour();
    }

    @Override
    public EventRegistryEventListenerActivityBehaviour createEventRegistryEventListenerActivityBehaviour(PlanItem planItem, GenericEventListener genericEventListener) {
        return new EventRegistryEventListenerActivityBehaviour(this.createExpression(genericEventListener.getEventType()));
    }

    @Override
    public VariableEventListenerActivityBehaviour createVariableEventListenerActivityBehaviour(PlanItem planItem, VariableEventListener variableEventListener) {
        return new VariableEventListenerActivityBehaviour(variableEventListener);
    }

    @Override
    public DecisionTaskActivityBehavior createDecisionTaskActivityBehavior(PlanItem planItem, DecisionTask decisionTask) {
        return new DecisionTaskActivityBehavior(this.createExpression(decisionTask.getDecisionRefExpression()), decisionTask);
    }

    @Override
    public CmmnActivityBehavior createHttpActivityBehavior(PlanItem planItem, ServiceTask task) {
        try {
            Class<?> theClass = null;
            FieldExtension behaviorExtension = null;
            for (FieldExtension fieldExtension : task.getFieldExtensions()) {
                if (!"httpActivityBehaviorClass".equals(fieldExtension.getFieldName()) || !StringUtils.isNotEmpty((CharSequence)fieldExtension.getStringValue())) continue;
                theClass = Class.forName(fieldExtension.getStringValue());
                behaviorExtension = fieldExtension;
                break;
            }
            if (behaviorExtension != null) {
                task.getFieldExtensions().remove(behaviorExtension);
            }
            if (theClass == null) {
                return this.createDefaultHttpActivityBehaviour(planItem, task);
            }
            return this.classDelegateFactory.create(theClass.getName(), task.getFieldExtensions());
        }
        catch (ClassNotFoundException e) {
            throw new FlowableException("Could not find org.flowable.http.HttpActivityBehavior: ", (Throwable)e);
        }
    }

    protected CmmnActivityBehavior createDefaultHttpActivityBehaviour(PlanItem planItem, ServiceTask serviceTask) {
        if ("class".equals(serviceTask.getImplementationType())) {
            return this.createCmmnClassDelegate(planItem, serviceTask);
        }
        if ("delegateExpression".equals(serviceTask.getImplementationType())) {
            return this.createPlanItemDelegateExpressionActivityBehavior(planItem, serviceTask);
        }
        return this.classDelegateFactory.create(DefaultCmmnHttpActivityDelegate.class.getName(), serviceTask.getFieldExtensions());
    }

    @Override
    public CmmnActivityBehavior createEmailActivityBehavior(PlanItem planItem, ServiceTask task) {
        return this.classDelegateFactory.create(CmmnMailActivityDelegate.class.getName(), task.getFieldExtensions());
    }

    @Override
    public SendEventActivityBehavior createSendEventActivityBehavior(PlanItem planItem, SendEventServiceTask sendEventServiceTask) {
        return new SendEventActivityBehavior(sendEventServiceTask);
    }

    @Override
    public ExternalWorkerTaskActivityBehavior createExternalWorkerActivityBehaviour(PlanItem planItem, ExternalWorkerServiceTask externalWorkerServiceTask) {
        return new ExternalWorkerTaskActivityBehavior(externalWorkerServiceTask);
    }

    @Override
    public ScriptTaskActivityBehavior createScriptTaskActivityBehavior(PlanItem planItem, ScriptServiceTask task) {
        return new ScriptTaskActivityBehavior(task);
    }

    @Override
    public CasePageTaskActivityBehaviour createCasePageTaskActivityBehaviour(PlanItem planItem, CasePageTask task) {
        return new CasePageTaskActivityBehaviour(task);
    }

    public void setClassDelegateFactory(CmmnClassDelegateFactory classDelegateFactory) {
        this.classDelegateFactory = classDelegateFactory;
    }

    public ExpressionManager getExpressionManager() {
        return this.expressionManager;
    }

    public void setExpressionManager(ExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
    }

    protected Expression createExpression(String refExpressionString) {
        Expression expression = null;
        if (StringUtils.isNotEmpty((CharSequence)refExpressionString)) {
            expression = this.expressionManager.createExpression(refExpressionString);
        }
        return expression;
    }
}

